/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.tycho.m2e.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.internal.project.registry.AbstractMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.ILifecycleMapping2;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractCustomizableLifecycleMapping;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.sonatype.tycho.m2e.felix.internal.MavenBundlePluginConfigurator;
import org.sonatype.tycho.m2e.internal.PDEMavenBundlePluginConfigurator;
import org.sonatype.tycho.m2e.internal.PDEProjectHelper;

public class TychoLifecycleMapping
extends AbstractCustomizableLifecycleMapping
implements ILifecycleMapping,
ILifecycleMapping2 {
    private PDEProjectHelper pdeHelper = PDEProjectHelper.getInstance();
    private static final AbstractMavenDependencyResolver NOOP_DEPENDENCY_RESOLVER = new AbstractMavenDependencyResolver(){

        public void resolveProjectDependencies(IMavenProjectFacade facade, MavenExecutionRequest mavenRequest, Set<Capability> capabilities, Set<RequiredCapability> requirements, IProgressMonitor monitor) throws CoreException {
        }
    };

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        super.configure(request, monitor);
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        String packaging = mavenProject.getPackaging();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            this.pdeHelper.configurePDEBundleProject(project, mavenProject, monitor);
        } else if ("eclipse-feature".equals(packaging)) {
            if (!project.hasNature("org.eclipse.pde.FeatureNature")) {
                CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
            }
        } else if ("eclipse-update-site".equals(packaging) && !project.hasNature("org.eclipse.pde.UpdateSiteNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.UpdateSiteNature", (IProgressMonitor)monitor);
        }
    }

    public List<AbstractProjectConfigurator> getProjectConfigurators(IMavenProjectFacade projectFacade, IProgressMonitor monitor) {
        ArrayList<AbstractProjectConfigurator> configurators = new ArrayList<AbstractProjectConfigurator>(super.getProjectConfigurators(projectFacade, monitor));
        ListIterator li = configurators.listIterator();
        while (li.hasNext()) {
            AbstractProjectConfigurator configurator = (AbstractProjectConfigurator)li.next();
            if (!(configurator instanceof MavenBundlePluginConfigurator) && !(configurator instanceof PDEMavenBundlePluginConfigurator)) continue;
            li.remove();
        }
        return configurators;
    }

    public AbstractMavenDependencyResolver getDependencyResolver(IProgressMonitor monitor) {
        return NOOP_DEPENDENCY_RESOLVER;
    }
}

