/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.actions.DeleteAction;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelSelectorDialog;
import org.teiid.designer.ui.viewsupport.ModelSelectorInfo;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.ModelerXmlUiPlugin;
import org.teiid.designer.xml.ui.actions.ViewXmlMessageStructureWizard;
import org.teiid.designer.xml.ui.dialogs.ConfirmSaveXsdModelDialog;
import org.teiid.designer.xml.ui.wizards.XmlViewModelSelectionValidator;

public class CreateXmlViewFromXsdAction
extends SortableSelectionAction
implements ModelerXmlUiConstants {
    private static final String KEY_NO_SEL_DLG_MSG = "CreateXmlViewFromXsdAction.noSelMsg";
    private static final String NO_SEL_DLG_TITLE = Util.getString("CreateXmlViewFromXsdAction.noSelTitle", new Object[0]);
    private static final String DEFAULT_EXPLORER_TITLE = Util.getString("CreateXmlViewFromXsdAction.defaultViewName", new Object[0]);

    protected void activateModelEditor(final ModelResource theModel) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IFile file = (IFile)theModel.getUnderlyingResource();
                    if (file != null) {
                        ModelEditorManager.openInEditMode((Object)theModel, (boolean)true, (int)0);
                        ModelEditorManager.save((IFile)file);
                    }
                }
                catch (ModelWorkspaceException theException) {
                    Util.log((Throwable)theException);
                }
            }
        });
    }

    protected boolean executeBuild(List theXsdRoots, IProgressMonitor theMonitor) {
        IFile theFile;
        Object[] selectedObjects;
        boolean result = false;
        String PREFIX = I18nUtil.getPropertyPrefix(CreateXmlViewFromXsdAction.class);
        theMonitor.beginTask("Building View Model Documents:  ", 100);
        ModelResource xmlDocModel = null;
        ModelSelectorInfo newModelInfo = new ModelSelectorInfo(Util.getString(String.valueOf(PREFIX) + "modelTypeName", new Object[0]), ModelType.VIRTUAL_LITERAL, "http://www.metamatrix.com/metamodels/XmlDocument", Util.getString(String.valueOf(PREFIX) + "newModelNameLabel", new Object[0]), Util.getString(String.valueOf(PREFIX) + "modelSelectorTitle", new Object[0]));
        ModelSelectorDialog mwdDialog = new ModelSelectorDialog(this.getShell(), newModelInfo);
        mwdDialog.addFilter((ViewerFilter)new ModelWorkspaceViewerFilter(true));
        mwdDialog.setValidator((ISelectionStatusValidator)new XmlViewModelSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        boolean modelCreated = mwdDialog.isNewModel();
        if (mwdDialog.getReturnCode() == 0 && (selectedObjects = mwdDialog.getResult()).length == 1 && selectedObjects[0] instanceof IFile && (theFile = (IFile)selectedObjects[0]) != null) {
            try {
                xmlDocModel = ModelUtil.getModelResource((IFile)theFile, (boolean)false);
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
        }
        if (xmlDocModel != null) {
            final ModelResource xmlModel = xmlDocModel;
            ModelResource schemaModelResource = this.getSchemaModel(theXsdRoots);
            if (schemaModelResource != null) {
                try {
                    IFile schemaModel = (IFile)schemaModelResource.getUnderlyingResource();
                    StructuredSelection schemaSelection = new StructuredSelection((Object)schemaModel);
                    ViewXmlMessageStructureWizard wizard = new ViewXmlMessageStructureWizard(xmlModel, (ISelection)schemaSelection);
                    XSDElementDeclaration[] roots = theXsdRoots.toArray(new XSDElementDeclaration[theXsdRoots.size()]);
                    wizard.setDocumentRoots(roots);
                    if (new WizardDialog(this.getShell(), (IWizard)wizard).open() == 0) {
                        result = true;
                        this.activateModelEditor(xmlModel);
                    } else if (modelCreated && !xmlModel.getPath().toFile().getAbsoluteFile().exists()) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IResource resource = xmlModel.getUnderlyingResource();
                                    if (resource != null) {
                                        DeleteAction action = new DeleteAction();
                                        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)resource));
                                        action.run();
                                    }
                                }
                                catch (ModelWorkspaceException theException) {
                                    Util.log((Throwable)theException);
                                }
                            }
                        });
                    }
                    IViewPart part = UiUtil.getViewPart((String)"explorer.view");
                    if (part != null) {
                        ((ResourceNavigator)part).getViewer().refresh((Object)schemaModel);
                    }
                }
                catch (Exception theException) {
                    Util.log((Throwable)theException);
                }
            }
        }
        this.notifyResult(result);
        return result;
    }

    protected boolean processXsdRoots(final List theXsdRoots) {
        boolean[] result;
        block15: {
            result = new boolean[1];
            if (theXsdRoots != null && !theXsdRoots.isEmpty()) {
                block16: {
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                        public void execute(IProgressMonitor theMonitor) {
                            try {
                                if (CreateXmlViewFromXsdAction.this.isXsdSaved(theXsdRoots)) {
                                    result[0] = CreateXmlViewFromXsdAction.this.executeBuild(theXsdRoots, theMonitor);
                                }
                            }
                            finally {
                                theMonitor.done();
                            }
                        }
                    };
                    boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create XML View Model", (Object)this);
                    boolean success = false;
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(false, false, (IRunnableWithProgress)op);
                        success = result[0];
                    }
                    catch (InterruptedException interruptedException) {
                        success = false;
                        if (startedTxn) {
                            if (success) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        break block15;
                    }
                    catch (InvocationTargetException theException) {
                        try {
                            String PREFIX = I18nUtil.getPropertyPrefix(CreateXmlViewFromXsdAction.class);
                            success = false;
                            Throwable realException = theException.getTargetException();
                            String msg = realException.getMessage();
                            if (CoreStringUtil.isEmpty((String)msg)) {
                                msg = Util.getString(String.valueOf(PREFIX) + "noDetailsMsg", new Object[0]);
                            }
                            String title = Util.getString(String.valueOf(PREFIX) + "errorBuildingDialogTitle", new Object[0]);
                            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (startedTxn) {
                                if (success) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                        }
                    }
                    if (!startedTxn) break block15;
                    if (!success) break block16;
                    ModelerCore.commitTxn();
                    break block15;
                }
                ModelerCore.rollbackTxn();
            }
        }
        return result[0];
    }

    protected ModelResource getSchemaModel(List theXsdRoots) {
        ModelResource result = null;
        try {
            result = ModelUtil.getModel(theXsdRoots.get(0));
        }
        catch (ModelWorkspaceException theException) {
            Util.log((Throwable)theException);
        }
        return result;
    }

    protected Shell getShell() {
        return ModelerXmlUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    protected boolean isXsdSaved(List theXsdRoots) {
        boolean result = true;
        try {
            ModelResource schemaModelResource = this.getSchemaModel(theXsdRoots);
            if (schemaModelResource == null) {
                result = false;
            } else if (schemaModelResource.getEmfResource().isModified()) {
                ConfirmSaveXsdModelDialog dialog = new ConfirmSaveXsdModelDialog(this.getShell(), schemaModelResource);
                result = dialog.open() == 0 && dialog.isSchemaSaved();
            }
        }
        catch (ModelWorkspaceException theException) {
            result = false;
            Util.log((Throwable)theException);
        }
        return result;
    }

    public void run() {
        IWorkbenchWindow iww = ModelerXmlUiPlugin.getDefault().getCurrentWorkbenchWindow();
        ISelection selection = this.getSelection();
        if (!this.isValidSelection(selection)) {
            String viewId = ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId();
            IViewReference viewRef = iww.getActivePage().findViewReference(viewId);
            String viewTitle = viewRef == null ? DEFAULT_EXPLORER_TITLE : viewRef.getTitle();
            String dlgMsg = Util.getString(KEY_NO_SEL_DLG_MSG, (Object)viewTitle);
            MessageDialog.openError((Shell)iww.getShell(), (String)NO_SEL_DLG_TITLE, (String)dlgMsg);
            return;
        }
        List docRoots = SelectionUtilities.getSelectedEObjects((ISelection)selection);
        this.processXsdRoots(docRoots);
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            XSDSchema schema = null;
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            for (Object nextObj : objs) {
                if (nextObj instanceof XSDElementDeclaration) {
                    XSDSchema temp = ((XSDElementDeclaration)nextObj).getSchema();
                    if (schema == null) {
                        schema = temp;
                    } else {
                        isValid = schema.equals(temp);
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) break;
            }
        }
        return isValid;
    }

    public boolean isApplicable(ISelection theSelection) {
        return this.isValidSelection(theSelection);
    }
}

