/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.actions;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.ModelSelectorInfo;
import org.teiid.designer.xml.ui.actions.CreateXmlViewFromXsdAction;
import org.teiid.designer.xml.ui.actions.ViewXmlMessageStructureWizard;
import org.teiid.designer.xml.ui.wizards.VirtualDocumentWizardContributor;

public class ViewXmlMessageStructureAction
extends CreateXmlViewFromXsdAction {
    private static final String MODEL_NAME = Util.getString("ViewXmlMessageStructureAction.modelName", new Object[0]);
    private static final String NEW_MODEL_NAME_LABEL = Util.getString("ViewXmlMessageStructureAction.newModelNameLabel", new Object[0]);
    private static final String XMI_FILE_EXT = "xmi";
    private static final String DOT_XMI_FILE_EXT = ".xmi";
    private static final String UNDERSCORE_MS = "_MS";
    private static ModelSelectorInfo newModelInfo;

    public ViewXmlMessageStructureAction() {
        if (newModelInfo == null) {
            newModelInfo = new ModelSelectorInfo(MODEL_NAME, ModelType.LOGICAL_LITERAL, "http://www.metamatrix.com/metamodels/XmlDocument", NEW_MODEL_NAME_LABEL, null);
        }
    }

    @Override
    protected boolean executeBuild(List theXsdRoots, IProgressMonitor theMonitor) {
        boolean result = false;
        theMonitor.beginTask("Building View Model Documents:  ", 100);
        try {
            ModelResource schemaModelResource = this.getSchemaModel(theXsdRoots);
            if (schemaModelResource == null) {
                result = false;
            } else {
                IViewPart part;
                IFile schemaModel = (IFile)schemaModelResource.getUnderlyingResource();
                StructuredSelection selection = new StructuredSelection((Object)schemaModel);
                String newModelName = schemaModel.getProjectRelativePath().removeFileExtension().lastSegment().concat(UNDERSCORE_MS);
                ModelResource xmlDocModel = this.getModelResource(schemaModel.getParent(), newModelName);
                ViewXmlMessageStructureWizard wizard = new ViewXmlMessageStructureWizard(xmlDocModel, (ISelection)selection);
                wizard.setDocumentRoots(theXsdRoots.toArray(new XSDElementDeclaration[theXsdRoots.size()]));
                VirtualDocumentWizardContributor contributor = (VirtualDocumentWizardContributor)wizard.getContributor();
                contributor.setMappingClassBuilderStrategy(MappingClassBuilderStrategy.compositorStrategy);
                if (new WizardDialog(this.getShell(), (IWizard)wizard).open() == 0) {
                    result = true;
                    this.activateModelEditor(xmlDocModel);
                }
                if ((part = UiUtil.getViewPart((String)"explorer.view")) != null) {
                    ((ResourceNavigator)part).getViewer().refresh((Object)schemaModel);
                }
            }
        }
        catch (ModelWorkspaceException theException) {
            result = false;
            Util.log((Throwable)theException);
        }
        return result;
    }

    private ModelResource getModelResource(IContainer modelContainer, String name) {
        ModelResource modelResource = null;
        IPath modelPath = modelContainer.getProjectRelativePath().append(name).removeFileExtension().addFileExtension(XMI_FILE_EXT);
        File theModel = modelPath.toFile();
        if (theModel.exists()) {
            IResource modelFile = modelContainer.getProject().findMember(modelPath);
            if (modelFile != null) {
                try {
                    modelResource = ModelUtil.getModelResource((IFile)((IFile)modelFile), (boolean)false);
                }
                catch (ModelWorkspaceException theException) {
                    theException.printStackTrace();
                }
            }
        } else {
            modelResource = this.constructModel((IResource)modelContainer, name);
        }
        return modelResource;
    }

    private ModelResource constructModel(IResource targetRes, String sModelName) {
        String sFileName = this.getFileName(sModelName);
        IPath relativeModelPath = targetRes.getProjectRelativePath().append(sFileName);
        IFile modelFile = targetRes.getProject().getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            resrc.getModelAnnotation().setPrimaryMetamodelUri(newModelInfo.getModelURI());
            resrc.getModelAnnotation().setModelType(newModelInfo.getModelType());
        }
        catch (ModelWorkspaceException mwe) {
            mwe.printStackTrace();
        }
        return resrc;
    }

    private String getFileName(String sModelName) {
        String sResult = sModelName.trim();
        if (!sResult.endsWith(DOT_XMI_FILE_EXT)) {
            sResult = String.valueOf(sResult) + DOT_XMI_FILE_EXT;
        }
        return sResult;
    }
}

