/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.dialogs;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;

public class ConvertSimpleTypesToEnteriseTypesDialog
extends Dialog
implements ModelerXmlUiConstants {
    private CLabel messageLabel;
    private Set xsdResources;

    public ConvertSimpleTypesToEnteriseTypesDialog(Shell shell, Set xsdResources) {
        super(shell, Util.getString("ConvertSimpleTypesToEnterpriseTypesDialog.dialogTitle", new Object[0]));
        this.setCenterOnDisplay(true);
        this.xsdResources = xsdResources;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        c.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        StyledText txtInfo = new StyledText(c, 72);
        StringBuffer fBuf = new StringBuffer();
        Iterator fileIter = this.xsdResources.iterator();
        while (fileIter.hasNext()) {
            XSDResourceImpl xsdResource = (XSDResourceImpl)fileIter.next();
            IPath resourcePath = null;
            ModelResource modelRsrc = ModelUtilities.getModelResource((Resource)xsdResource, (boolean)true);
            if (modelRsrc != null) {
                resourcePath = modelRsrc.getPath();
            }
            String fileName = "";
            fileName = resourcePath != null ? resourcePath.makeRelative().toOSString() : String.valueOf(Util.getString("ConvertSimpleTypesToEnterpriseTypesDialog.unableToLoadResource", new Object[0])) + xsdResource.getURI().toString();
            fBuf.append("\n");
            fBuf.append("\t");
            fBuf.append(fileName);
            if (!fileIter.hasNext()) continue;
            fBuf.append(",");
        }
        Object[] params = new Object[]{fBuf.toString()};
        StringBuffer sbuf = new StringBuffer(Util.getString("ConvertSimpleTypesToEnterpriseTypesDialog.text", params));
        txtInfo.setText(sbuf.toString());
        txtInfo.setBackground(UiUtil.getSystemColor((int)22));
        txtInfo.setLayoutData((Object)new GridData(768));
        txtInfo.setEnabled(false);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        c.setLayoutData((Object)gridData);
        this.messageLabel = WidgetFactory.createLabel((Composite)c);
        this.messageLabel.setText(" ");
        GridData messageData = new GridData(1808);
        messageData.grabExcessHorizontalSpace = true;
        messageData.grabExcessVerticalSpace = true;
        this.messageLabel.setLayoutData((Object)messageData);
        return c;
    }

    protected void okPressed() {
        this.close();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            label = IDialogConstants.NO_LABEL;
        } else {
            label = IDialogConstants.YES_LABEL;
            defaultButton = true;
        }
        return super.createButton(parent, id, label, defaultButton);
    }
}

