/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.mapping.factory.MappingClassFactory;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.viewsupport.ModelSelectorDialog;
import org.teiid.designer.ui.viewsupport.ModelSelectorInfo;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.xml.factory.VirtualDocumentModelPopulator;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.wizards.XmlViewModelSelectionValidator;

public class CreateXmlViewFromXsdMainPage
extends WizardDataTransferPage
implements ModelerXmlUiConstants {
    private ModelSelectorInfo newModelInfo;
    private List xsdRoots;
    private ModelResource targetXmlStructureModel;
    private Text modelFolderNameField;
    private Button modelFolderBrowseButton;
    private boolean initializing = false;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateXmlViewFromXsdMainPage.class);
    private static final String MODEL_SELECTOR_TITLE = CreateXmlViewFromXsdMainPage.getString("modelSelectorTitle");
    private static final String INITIAL_MESSAGE = CreateXmlViewFromXsdMainPage.getString("initialMessage");
    private static final String PAGE_TITLE = CreateXmlViewFromXsdMainPage.getString("pageTitle");
    private static final String MODEL_NAME = CreateXmlViewFromXsdMainPage.getString("modelName");
    private static final String NEW_MODEL_NAME_LABEL = CreateXmlViewFromXsdMainPage.getString("newModelNameLabel");
    private static final String BROWSE_LABEL = CreateXmlViewFromXsdMainPage.getString("browseLabel");
    private static final String MODEL_LABEL = CreateXmlViewFromXsdMainPage.getString("modelLabel");
    private static final String NO_MODEL_MESSAGE = CreateXmlViewFromXsdMainPage.getString("noModelMessage");
    private static final String ERROR_BUILDING_DOCUMENTS = CreateXmlViewFromXsdMainPage.getString("errorBuildingDocuments");

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object obj) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, obj);
    }

    public CreateXmlViewFromXsdMainPage(List xsdRoots) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.xsdRoots = new ArrayList(xsdRoots);
        this.newModelInfo = new ModelSelectorInfo(MODEL_NAME, ModelType.VIRTUAL_LITERAL, "http://www.metamatrix.com/metamodels/XmlDocument", NEW_MODEL_NAME_LABEL, MODEL_SELECTOR_TITLE);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.modelFolderBrowseButton) {
                this.handleModelFolderBrowseButtonPressed();
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(MODEL_LABEL);
        resourcesLabel.setFont(parent.getFont());
        this.modelFolderNameField = new Text(containerGroup, 2052);
        this.modelFolderNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.modelFolderNameField.setLayoutData((Object)data);
        this.modelFolderNameField.setFont(parent.getFont());
        this.modelFolderNameField.setEditable(false);
        this.modelFolderBrowseButton = new Button(containerGroup, 8);
        this.modelFolderBrowseButton.setText(BROWSE_LABEL);
        this.modelFolderBrowseButton.setLayoutData((Object)new GridData());
        this.modelFolderBrowseButton.addListener(13, (Listener)this);
        this.modelFolderBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.modelFolderBrowseButton);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(true);
        this.setMessage(INITIAL_MESSAGE);
        this.setControl((Control)containerGroup);
    }

    public void dispose() {
        super.dispose();
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    private boolean setCompletionStatus() {
        if (this.targetXmlStructureModel == null) {
            this.setErrorMessage(NO_MODEL_MESSAGE);
            this.setPageComplete(false);
            return false;
        }
        if (!this.targetXmlStructureModel.exists()) {
            String msg = CreateXmlViewFromXsdMainPage.getString(I18N_PREFIX, this.modelFolderNameField.getText());
            this.setErrorMessage(msg);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(INITIAL_MESSAGE);
        this.setPageComplete(true);
        return true;
    }

    public boolean finish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                try {
                    CreateXmlViewFromXsdMainPage.this.executeBuild(theMonitor);
                }
                finally {
                    theMonitor.done();
                }
            }
        };
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create XML View Model", (Object)this);
        boolean success = false;
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
                success = true;
            }
            catch (InterruptedException interruptedException) {
                success = false;
                if (startedTxn) {
                    if (success) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return false;
            }
            catch (InvocationTargetException e) {
                block14: {
                    block15: {
                        success = false;
                        Throwable realException = e.getTargetException();
                        MessageDialog.openError((Shell)this.getShell(), (String)ERROR_BUILDING_DOCUMENTS, (String)realException.getMessage());
                        if (!startedTxn) break block14;
                        if (!success) break block15;
                        ModelerCore.commitTxn();
                        break block14;
                    }
                    ModelerCore.rollbackTxn();
                }
                return false;
            }
        }
        finally {
            if (startedTxn) {
                if (success) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.saveWidgetValues();
        return true;
    }

    void executeBuild(IProgressMonitor theMonitor) {
        if (this.xsdRoots != null && !this.xsdRoots.isEmpty()) {
            theMonitor.beginTask("Building View Model Documents:  ", 100);
            VirtualDocumentModelPopulator populator = new VirtualDocumentModelPopulator(this.xsdRoots);
            ModelResource mr = null;
            IContainer schemaModelContainer = null;
            try {
                IFile schemaModel;
                mr = ModelUtil.getModel(this.xsdRoots.get(0));
                if (mr != null && (schemaModel = (IFile)mr.getUnderlyingResource()) != null) {
                    schemaModelContainer = schemaModel.getParent();
                }
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
            if (schemaModelContainer != null && this.targetXmlStructureModel != null) {
                populator.buildModel(this.targetXmlStructureModel, true, true, MappingClassFactory.getDefaultStrategy(), (IProgressMonitor)new SubProgressMonitor(theMonitor, 100));
            }
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
    }

    protected void handleModelFolderBrowseButtonPressed() {
        Object[] selectedObjects;
        ModelSelectorDialog mwdDialog = new ModelSelectorDialog(this.getShell(), this.newModelInfo);
        mwdDialog.addFilter((ViewerFilter)new ModelWorkspaceViewerFilter(true));
        mwdDialog.setValidator((ISelectionStatusValidator)new XmlViewModelSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (selectedObjects = mwdDialog.getResult()).length > 0 && selectedObjects[0] instanceof IFile) {
            IFile theFile = (IFile)selectedObjects[0];
            if (theFile != null) {
                try {
                    this.targetXmlStructureModel = ModelUtil.getModelResource((IFile)theFile, (boolean)false);
                }
                catch (ModelWorkspaceException theException) {
                    Util.log((Throwable)theException);
                }
            }
            if (this.targetXmlStructureModel != null) {
                this.modelFolderNameField.setText(this.targetXmlStructureModel.getPath().toOSString());
            }
        }
    }

    public ModelResource getTargetXmlStructureModel() {
        return this.targetXmlStructureModel;
    }
}

