/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.mapping.factory.MappingClassBuilderStrategy;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.xml.IVirtualDocumentFragmentSource;
import org.teiid.designer.xml.ModelerXmlPlugin;

public class NewDocumentWizardModel {
    private Composite wizHolder;
    private IVirtualDocumentFragmentSource source;
    private XmlFragment[] fragments;
    private int selectedFragmentCount;
    private boolean fragmentsNeedUpdating = true;
    private boolean buildEntireDocuments;
    private boolean buildMappingClasses;
    private int estimatedNodeCount;
    private boolean useSchemaTypes = true;
    private boolean buildGlobalOnly;
    private Collection unhandledModelImports;
    private MappingClassBuilderStrategy strategy;

    public NewDocumentWizardModel() {
        ModelerXmlPlugin plugin = ModelerXmlPlugin.getDefault();
        if (plugin != null) {
            IEclipsePreferences defaultPrefs = ModelerCore.getDefaultPreferences((String)"org.teiid.designer.xml.ui");
            defaultPrefs.putBoolean("mappingTypeFromXsd", true);
        }
    }

    public XmlFragment[] getFragments(ModelResource modelResource, IProgressMonitor monitor) {
        if (this.fragmentsNeedUpdating || this.fragments == null) {
            this.fragments = this.source.getFragments(modelResource, monitor);
            this.fragmentsNeedUpdating = false;
        }
        return this.fragments;
    }

    public void setBuildEntireDocuments(boolean buildEntireDocuments) {
        if (this.buildEntireDocuments != buildEntireDocuments) {
            this.fragmentsNeedUpdating = true;
            this.buildEntireDocuments = buildEntireDocuments;
        }
    }

    public boolean getBuildEntireDocuments() {
        return this.buildEntireDocuments;
    }

    public void setSource(IVirtualDocumentFragmentSource source) {
        if (this.source != source) {
            this.fragmentsNeedUpdating = true;
            this.source = source;
        }
    }

    public IVirtualDocumentFragmentSource getSource() {
        return this.source;
    }

    public void setSelectedFragmentCount(int selectedFragmentCount) {
        if (this.selectedFragmentCount != selectedFragmentCount) {
            this.fragmentsNeedUpdating = true;
            this.selectedFragmentCount = selectedFragmentCount;
        }
    }

    public int getSelectedFragmentCount() {
        return this.selectedFragmentCount;
    }

    public void setBuildMappingClasses(boolean buildMappingClasses) {
        this.buildMappingClasses = buildMappingClasses;
    }

    public boolean getBuildMappingClasses() {
        return this.buildMappingClasses;
    }

    public void setEstimatedNodeCount(int estimatedNodeCount) {
        this.estimatedNodeCount = estimatedNodeCount;
    }

    public int getEstimatedNodeCount() {
        return this.estimatedNodeCount;
    }

    public void setUseSchemaTypes(boolean useSchemaTypes) {
        if (this.useSchemaTypes != useSchemaTypes) {
            this.fragmentsNeedUpdating = true;
            this.useSchemaTypes = useSchemaTypes;
        }
    }

    public boolean getUseSchemaTypes() {
        return this.useSchemaTypes;
    }

    public void setBuildGlobalOnly(boolean buildGlobalOnly) {
        if (this.buildGlobalOnly != buildGlobalOnly) {
            this.fragmentsNeedUpdating = true;
            this.buildGlobalOnly = buildGlobalOnly;
        }
    }

    public boolean getBuildGlobalOnly() {
        return this.buildGlobalOnly;
    }

    public Composite getWizHolder() {
        return this.wizHolder;
    }

    public void setWizHolder(Composite wizHolder) {
        this.wizHolder = wizHolder;
    }

    public void setReferencedResources(Collection refs) {
        this.unhandledModelImports = refs;
    }

    public Collection getUnhandledModelImports() {
        if (this.unhandledModelImports == null) {
            this.unhandledModelImports = new HashSet();
        }
        return this.unhandledModelImports;
    }

    public void setMappingClassBuilderStrategy(MappingClassBuilderStrategy strategy) {
        this.strategy = strategy;
    }

    public MappingClassBuilderStrategy getMappingClassBuilderStrategy() {
        return this.strategy;
    }
}

