/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.xml.ui.wizards.NewVirtualDocumentWizardPanel;

class NewVirtualDocumentAccumulatorSource
implements IAccumulatorSource {
    private static final IStatus OK_STATUS = new StatusInfo("org.teiid.designer.xml");
    private NewVirtualDocumentWizardPanel caller;
    private int whichAccumulator;

    public NewVirtualDocumentAccumulatorSource(NewVirtualDocumentWizardPanel cllr, int accType) {
        this.caller = cllr;
        this.whichAccumulator = accType;
    }

    public void accumulatedValuesRemoved(Collection values) {
        switch (this.whichAccumulator) {
            case 1: {
                this.caller.documentsAccumulatedValuesRemoved(values);
                this.caller.selectedDocumentsChanged();
                break;
            }
            case 2: {
                this.caller.fragmentsAccumulatedValuesRemoved(values);
                this.caller.selectedFragmentsChanged();
            }
        }
    }

    public void accumulatedValuesAdded(Collection values) {
        switch (this.whichAccumulator) {
            case 1: {
                this.caller.documentsAccumulatedValuesAdded(values);
                this.caller.selectedDocumentsChanged();
                break;
            }
            case 2: {
                this.caller.fragmentsAccumulatedValuesAdded(values);
                this.caller.selectedFragmentsChanged();
            }
        }
    }

    public Collection getAvailableValues() {
        Collection values = null;
        switch (this.whichAccumulator) {
            case 1: {
                values = this.caller.getDocumentsAvailableValues();
                break;
            }
            case 2: {
                values = this.caller.getFragmentsAvailableValues();
            }
        }
        return values;
    }

    public int getAvailableValuesCount() {
        int count = -1;
        switch (this.whichAccumulator) {
            case 1: {
                count = this.caller.getDocumentsAvailableValuesCount();
                break;
            }
            case 2: {
                count = this.caller.getFragmentsAvailableValuesCount();
            }
        }
        return count;
    }

    public Collection getSelectedAvailableValues() {
        Collection values = null;
        switch (this.whichAccumulator) {
            case 1: {
                values = this.caller.getDocumentsSelectedAvailableValues();
                break;
            }
            case 2: {
                values = this.caller.getFragmentsSelectedAvailableValues();
            }
        }
        return values;
    }

    public int getSelectedAvailableValuesCount() {
        int count = -1;
        switch (this.whichAccumulator) {
            case 1: {
                count = this.caller.getDocumentsSelectedAvailableValuesCount();
                break;
            }
            case 2: {
                count = this.caller.getFragmentsSelectedAvailableValuesCount();
            }
        }
        return count;
    }

    public Control createControl(Composite parent) {
        Control control = null;
        switch (this.whichAccumulator) {
            case 1: {
                control = this.caller.documentsCreateControl(parent);
                break;
            }
            case 2: {
                control = this.caller.fragmentsCreateControl(parent);
            }
        }
        return control;
    }

    public void addSelectionListener(SelectionListener listener) {
        switch (this.whichAccumulator) {
            case 1: {
                this.caller.documentsAddSelectionListener(listener);
                break;
            }
            case 2: {
                this.caller.fragmentsAddSelectionListener(listener);
            }
        }
    }

    public boolean supportsAddAll() {
        return true;
    }

    public IStatus getSelectionStatus() {
        return OK_STATUS;
    }
}

