/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.INewModelObjectWizard;
import org.teiid.designer.xml.IVirtualDocumentFragmentSource;
import org.teiid.designer.xml.factory.IDocumentsAndFragmentsPopulator;
import org.teiid.designer.xml.factory.VirtualDocumentModelPopulator;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;
import org.teiid.designer.xml.ui.ModelerXmlUiPlugin;
import org.teiid.designer.xml.ui.dialogs.ConvertSimpleTypesToEnteriseTypesDialog;
import org.teiid.designer.xml.ui.wizards.NewDocumentWizardModel;
import org.teiid.designer.xml.ui.wizards.NewVirtualDocumentWizardPage;
import org.teiid.designer.xml.ui.wizards.PreviewVirtualDocumentWizardPage;
import org.teiid.designer.xml.ui.wizards.VirtualDocumentStatisticsWizardPage;

public class XMLDocumentWizard
extends AbstractWizard
implements INewModelObjectWizard,
ModelerXmlUiConstants {
    static final String DOC_ERROR_MSG = Util.getString("XMLDocumentWizard.documentErrorMessage", new Object[0]);
    private ModelResource modelResource;
    private NewVirtualDocumentWizardPage docPage;
    private VirtualDocumentStatisticsWizardPage statsPage;
    private PreviewVirtualDocumentWizardPage previewPage;
    private IWizardPage priorPage;
    private boolean completedOperation = false;
    private NewDocumentWizardModel model;
    boolean txnStarted = false;
    boolean txnSucceeded = false;
    boolean txnCancelled = false;

    public XMLDocumentWizard() {
        super((AbstractUIPlugin)ModelerXmlUiPlugin.getDefault(), Util.getString("XMLDocumentWizard.title", new Object[0]), null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.model = new NewDocumentWizardModel();
        this.startTransaction();
    }

    private void startTransaction() {
        this.txnStarted = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Build XML Document", (Object)this);
        this.txnSucceeded = false;
        this.txnCancelled = false;
    }

    private void commitTransaction() {
        if (this.txnStarted) {
            if (this.txnSucceeded) {
                ModelerCore.commitTxn();
            } else {
                ModelerCore.rollbackTxn();
            }
        }
    }

    private void cancelTransaction() {
        if (this.txnStarted) {
            ModelerCore.rollbackTxn();
        }
    }

    public void setModel(ModelResource model) {
        this.modelResource = model;
    }

    public void addPages() {
        this.docPage = new NewVirtualDocumentWizardPage(this.model, null);
        this.addPage((IWizardPage)this.docPage);
        this.model.setSource(this.docPage);
        this.statsPage = new VirtualDocumentStatisticsWizardPage(this.model);
        this.addPage((IWizardPage)this.statsPage);
        this.previewPage = new PreviewVirtualDocumentWizardPage(this.model);
        this.addPage((IWizardPage)this.previewPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currP = this.getContainer().getCurrentPage();
        try {
            DocSrcUpdater dsi = null;
            if (this.priorPage == this.docPage && currP == this.statsPage) {
                dsi = new DocSrcUpdater(this.statsPage, true, this.model.getSelectedFragmentCount());
            } else if (currP == this.previewPage) {
                dsi = new DocSrcUpdater(this.previewPage, true, this.model.getEstimatedNodeCount());
            }
            if (dsi != null) {
                this.getContainer().run(false, true, dsi);
            }
        }
        catch (Exception ex) {
            Util.log((Throwable)ex);
        }
        this.priorPage = currP;
        return super.getNextPage(page);
    }

    public boolean finish() {
        this.completedOperation = XMLDocumentWizard.finishWizard(this.docPage, this.previewPage, this.modelResource, this.getContainer(), this.model);
        if (this.completedOperation) {
            this.txnSucceeded = true;
            this.commitTransaction();
        }
        return this.completedOperation;
    }

    public static boolean finishWizard(final NewVirtualDocumentWizardPage docPage, final PreviewVirtualDocumentWizardPage previewPage, final ModelResource modelResource, final IWizardContainer container, final NewDocumentWizardModel wizModel) {
        final boolean useXsdTypes = wizModel.getUseSchemaTypes();
        IEclipsePreferences prefs = ModelerCore.getPreferences((String)"org.teiid.designer.xml.ui");
        prefs.putBoolean("mappingTypeFromXsd", useXsdTypes);
        try {
            ModelerCore.savePreferences((String)"org.teiid.designer.xml.ui");
        }
        catch (BackingStoreException e) {
            Util.log((Throwable)e);
        }
        final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
        final boolean[] completedOperation = new boolean[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Could not resolve type clashes
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        IDocumentsAndFragmentsPopulator populator = docPage.getPopulator();
                        IWizardPage currentPage = container.getCurrentPage();
                        boolean buildMappingClasses = wizModel.getBuildMappingClasses();
                        Collection<Object> fragments = new ArrayList();
                        if (currentPage != previewPage) {
                            fragments = previewPage.getRoots(modelResource, monitor);
                            Resource res = modelResource.getEmfResource();
                            if (res instanceof MtkXmiResourceImpl && !buildMappingClasses) {
                                ((MtkXmiResourceImpl)res).addMany(fragments);
                            } else {
                                EList contents = modelResource.getEmfResource().getContents();
                                HashSet<Object> missingFragments = new HashSet<Object>();
                                for (Object obj : fragments) {
                                    if (contents.contains(obj)) continue;
                                    missingFragments.add(obj);
                                }
                                if (!missingFragments.isEmpty()) {
                                    ModelerCore.getModelEditor().addValue((Object)res, missingFragments, contents);
                                }
                            }
                        } else {
                            XmlFragment[] xfs = previewPage.getFragments(modelResource, monitor);
                            fragments = Arrays.asList(xfs);
                            Resource res = modelResource.getEmfResource();
                            EList contents = modelResource.getEmfResource().getContents();
                            ModelerCore.getModelEditor().addValue((Object)res, fragments, contents);
                        }
                        if (buildMappingClasses && populator != null) {
                            for (XmlFragment fragment : fragments) {
                                populator.buildMappingClasses(fragment, wizModel.getMappingClassBuilderStrategy());
                            }
                        }
                        System.gc();
                        Thread.yield();
                        if (useXsdTypes && populator != null) {
                            HashMap<String, XSDSchema> simpleTypeMap = new HashMap<String, XSDSchema>();
                            for (Object type : ((VirtualDocumentModelPopulator)populator).getAccumulatedDatatypes()) {
                                if (!(type instanceof XSDSimpleTypeDefinition) || dtMgr.isEnterpriseDatatype((EObject)type)) continue;
                                simpleTypeMap.put(((XSDSimpleTypeDefinition)type).getName(), ((XSDSimpleTypeDefinition)type).getSchema());
                            }
                            if (simpleTypeMap.size() > 0) {
                                HashSet<Resource> resources = new HashSet<Resource>();
                                ModelResource modelResrc = ModelUtil.getModelResource((IFile)((IFile)populator.getItem()), (boolean)true);
                                if (modelResrc != null) {
                                    Resource xsdResource = modelResrc.getEmfResource();
                                    resources.add(xsdResource);
                                    this.loadReferencedXsdResources(xsdResource, resources, xsdResource.getResourceSet());
                                    Set affectedSchemas = this.getAffectedSchemas(resources, simpleTypeMap);
                                    this.removeExternalSchemas(affectedSchemas);
                                    if (!affectedSchemas.isEmpty() && this.displayDialog(affectedSchemas)) {
                                        for (Resource resource : affectedSchemas) {
                                            if (!ModelUtilities.getModelResource((Resource)resource, (boolean)false).isReadOnly()) continue;
                                            throw new IOException(Util.getString("XMLDocumentWizard.readOnly", (Object)resource.getURI()));
                                        }
                                        this.convertToEnterpriseType(affectedSchemas, simpleTypeMap, monitor);
                                    }
                                }
                            }
                        }
                        System.gc();
                        Thread.yield();
                        modelResource.save(monitor, true);
                        modelResource.getEmfResource().setModified(false);
                        completedOperation[0] = true;
                    }
                    catch (ModelWorkspaceException ex) {
                        Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                        monitor.done();
                    }
                    catch (ModelerCoreException ex) {
                        Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                        monitor.done();
                    }
                    catch (Exception ex) {
                        Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private boolean displayDialog(Set resources) {
                ConvertSimpleTypesToEnteriseTypesDialog dialog = null;
                dialog = new ConvertSimpleTypesToEnteriseTypesDialog(null, resources);
                dialog.open();
                return dialog.getReturnCode() == 0;
            }

            private void removeExternalSchemas(Set schemas) {
                Iterator iter = schemas.iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    ModelResource modelRsrc = null;
                    modelRsrc = ModelUtilities.getModelResource((Resource)resource, (boolean)false);
                    if (modelRsrc != null) continue;
                    iter.remove();
                }
            }

            private void convertToEnterpriseType(final Set resources, final HashMap simpleTypeMap, IProgressMonitor monitor) throws Exception {
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) {
                        XSDSchema schema = null;
                        ModelEditor me = ModelerCore.getModelEditor();
                        Iterator xsdIter = resources.iterator();
                        while (xsdIter.hasNext()) {
                            boolean updated = false;
                            XSDResourceImpl xsdResource = (XSDResourceImpl)xsdIter.next();
                            for (Object next : xsdResource.getContents()) {
                                if (!(next instanceof XSDSchema)) continue;
                                schema = (XSDSchema)next;
                                schema.setIncrementalUpdate(false);
                                for (Object child : ((XSDSchema)next).eContents()) {
                                    Object value;
                                    if (!(child instanceof XSDSimpleTypeDefinition) || (value = simpleTypeMap.get(((XSDSimpleTypeDefinition)child).getName())) == null || !((XSDSchema)value).getSchemaLocation().equals(((XSDSchema)next).getSchemaLocation())) continue;
                                    EnterpriseDatatypeInfo edi = this.getEDIForType((XSDSimpleTypeDefinition)child);
                                    me.setEnterpriseDatatypePropertyValue((EObject)((XSDSimpleTypeDefinition)child), (Object)edi);
                                    updated = true;
                                }
                            }
                            try {
                                if (!updated) continue;
                                xsdResource.save(new HashMap());
                                IResource iResource = ModelUtilities.getModelResource((Resource)xsdResource, (boolean)true).getResource();
                                iResource.refreshLocal(0, null);
                            }
                            catch (Exception err) {
                                String msg = Util.getString("XMLDocumentWizard.convertToEnterpriseTypesSaveError", new Object[0]);
                                Util.log(4, (Throwable)err, msg);
                            }
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(null).run(false, false, (IRunnableWithProgress)operation);
                }
                catch (InterruptedException e) {
                    Util.log(4, (Throwable)e, DOC_ERROR_MSG);
                }
                catch (InvocationTargetException e) {
                    Util.log(4, (Throwable)e, DOC_ERROR_MSG);
                }
            }

            private Set getAffectedSchemas(Set resources, HashMap simpleTypeMap) {
                HashSet<XSDResourceImpl> affectedSchemas = new HashSet<XSDResourceImpl>();
                for (XSDResourceImpl xsdResource : resources) {
                    for (Object next : xsdResource.getContents()) {
                        for (Object child : ((XSDSchema)next).eContents()) {
                            Object value;
                            if (!(child instanceof XSDSimpleTypeDefinition) || (value = simpleTypeMap.get(((XSDSimpleTypeDefinition)child).getName())) == null || !((XSDSchema)value).getSchemaLocation().equals(((XSDSchema)next).getSchemaLocation())) continue;
                            affectedSchemas.add(xsdResource);
                        }
                    }
                }
                return affectedSchemas;
            }

            private void loadReferencedXsdResources(Resource xsdSource, Set resources, ResourceSet container2) throws Exception {
                CoreArgCheck.isNotNull((Object)ModelerCore.getContainer((Resource)xsdSource));
                ResourceFinder finder = ModelerCore.getContainer((Resource)xsdSource).getResourceFinder();
                if (!xsdSource.isLoaded()) {
                    ResourceSet ctnr = xsdSource.getResourceSet();
                    if (ctnr == null) {
                        ctnr = ModelerCore.getModelContainer();
                    }
                    Map options = ctnr == null ? null : ctnr.getLoadOptions();
                    xsdSource.load(options);
                }
                XSDSchema schema = ((XSDResourceImpl)xsdSource).getSchema();
                for (Object obj : schema.getContents()) {
                    if (!(obj instanceof XSDSchemaDirective) || (xsdSource = finder.findByImport((XSDSchemaDirective)obj, false)) == null || xsdSource.getResourceSet() != container2 || !resources.add(xsdSource)) continue;
                    this.loadReferencedXsdResources(xsdSource, resources, container2);
                }
            }

            EnterpriseDatatypeInfo getEDIForType(XSDSimpleTypeDefinition type) {
                EnterpriseDatatypeInfo edi = new EnterpriseDatatypeInfo();
                Object superType = type;
                XSDSimpleTypeDefinition enterpriseParent = null;
                while (superType != null && enterpriseParent == null) {
                    if (dtMgr.isEnterpriseDatatype((EObject)superType)) {
                        enterpriseParent = superType;
                        continue;
                    }
                    XSDSimpleTypeDefinition tmp = superType.getBaseTypeDefinition();
                    superType = tmp != superType ? superType.getBaseTypeDefinition() : null;
                }
                if (enterpriseParent != null) {
                    edi.setRuntimeTypeFixed(dtMgr.getRuntimeTypeFixed(enterpriseParent));
                    edi.setRuntimeType(dtMgr.getRuntimeTypeName((EObject)enterpriseParent));
                }
                ModelEditorImpl.fillWithDefaultValues((EnterpriseDatatypeInfo)edi, (XSDSimpleTypeDefinition)type);
                return edi;
            }
        };
        try {
            container.run(false, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null) {
                message = realException.getClass().getName();
            }
            MessageDialog.openError((Shell)container.getShell(), (String)Util.getString("XMLDocumentWizard.error", new Object[0]), (String)message);
            ModelerXmlUiConstants.Util.log(realException);
            return false;
        }
        return completedOperation[0];
    }

    public boolean completedOperation() {
        return this.completedOperation;
    }

    public boolean performCancel() {
        this.cancelTransaction();
        return super.performCancel();
    }

    public void setCommand(Command descriptor) {
    }

    public static class DocSrcUpdater
    implements IRunnableWithProgress {
        private int units;
        private IVirtualDocumentFragmentSource srcToUpdate;
        private boolean isVis;

        public DocSrcUpdater(IVirtualDocumentFragmentSource thingToUpdate, boolean isVisible, int nodes) {
            this.srcToUpdate = thingToUpdate;
            this.isVis = isVisible;
            this.units = nodes * 2;
        }

        public void run(IProgressMonitor monitor) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(Util.getString("XMLDocumentWizard.taskGathering", new Object[0]), this.units);
            this.srcToUpdate.updateSourceFragments(this.isVis, monitor);
            monitor.done();
        }
    }
}

