/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;

public class XmlDocumentSelectorDialog
extends ModelWorkspaceDialog
implements ModelerXmlUiConstants {
    private EObject selectedEObject;
    private static final String TITLE = ModelerXmlUiConstants.Util.getString("XmlDocumentSelectorDialog.title", new Object[0]);
    private static final String INITIAL_MESSAGE = ModelerXmlUiConstants.Util.getString("XmlDocumentSelectorDialog.initialMessage", new Object[0]);
    private static final String INVALID_SELECTION_MESSAGE = ModelerXmlUiConstants.Util.getString("XmlDocumentSelectorDialog.invalidSelectionMessage", new Object[0]);

    public XmlDocumentSelectorDialog(Shell parent) {
        this(parent, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public XmlDocumentSelectorDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, TITLE, labelProvider, contentProvider);
        this.setMessage(INITIAL_MESSAGE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createModelCreationComposite(composite);
        return composite;
    }

    private Composite createModelCreationComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout nameCompositeLayout = new GridLayout();
        nameComposite.setLayout((Layout)nameCompositeLayout);
        nameCompositeLayout.numColumns = 3;
        nameCompositeLayout.marginWidth = 0;
        GridData nameCompositeGridData = new GridData(768);
        nameCompositeGridData.horizontalIndent = 20;
        nameComposite.setLayoutData((Object)nameCompositeGridData);
        this.setCreateControlsEnabled(false);
        return nameComposite;
    }

    public Object[] getResult() {
        if (this.selectedEObject != null) {
            return new Object[]{this.selectedEObject};
        }
        return null;
    }

    private void updateDialogMessage(String sMessage, boolean bIsError) {
        int iStatusCode = 0;
        if (bIsError) {
            iStatusCode = 4;
        }
        StatusInfo status = new StatusInfo("org.teiid.designer.xml.ui", iStatusCode, sMessage);
        this.updateStatus((IStatus)status);
    }

    protected void registerControls() {
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        Object oSelection = sel.getFirstElement();
        if (oSelection instanceof XmlDocument || oSelection instanceof XmlRoot) {
            this.selectedEObject = (EObject)oSelection;
            this.setCreateControlsEnabled(true);
            this.updateOKStatus();
        } else {
            this.selectedEObject = null;
            this.updateDialogMessage(INVALID_SELECTION_MESSAGE, true);
            this.setCreateControlsEnabled(false);
        }
    }

    private void setCreateControlsEnabled(boolean b) {
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean result = true;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (!project.isOpen()) {
                        result = false;
                    } else {
                        try {
                            if (!project.hasNature("org.teiid.designer.core.modelNature")) {
                                result = false;
                            }
                        }
                        catch (CoreException theException) {
                            ModelerCore.Util.log((Throwable)theException);
                            result = false;
                        }
                    }
                }
                return result;
            }
        });
        result.expandToLevel(2);
        return result;
    }

    public boolean close() {
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        return super.close();
    }
}

