/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.base.test.validation.TestUtil;
import org.jboss.tools.common.refactoring.TestableResolutionWithDialog;
import org.jboss.tools.common.refactoring.TestableResolutionWithRefactoringProcessor;
import org.jboss.tools.common.ui.marker.AddSuppressWarningsMarkerResolution;
import org.jboss.tools.common.ui.marker.ConfigureProblemSeverityMarkerResolution;
import org.jboss.tools.common.util.FileUtil;

public class MarkerResolutionTestUtil {
    private static void checkForConfigureProblemSeverity(IMarkerResolution[] resolutions) {
        IMarkerResolution[] iMarkerResolutionArray = resolutions;
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerResolution resolution = iMarkerResolutionArray[n2];
            if (resolution.getClass().equals(ConfigureProblemSeverityMarkerResolution.class)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Configure Problem Severity marker resolution not found");
    }

    private static void checkForAddSuppressWarnings(IFile file, IMarker marker, IMarkerResolution[] resolutions) {
        int severity = marker.getAttribute("severity", 0);
        if (file.getFileExtension().equals("java") && severity == 1) {
            IMarkerResolution[] iMarkerResolutionArray = resolutions;
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution resolution = iMarkerResolutionArray[n2];
                if (resolution.getClass().equals(AddSuppressWarningsMarkerResolution.class)) {
                    return;
                }
                ++n2;
            }
            Assert.fail((String)"Add @SuppressWarnings marker resolution not found");
        }
    }

    public static void checkResolution(IProject project, String[] fileNames, String markerType, String idName, int id, Class<? extends IMarkerResolution> resolutionClass) throws CoreException {
        MarkerResolutionTestUtil.checkResolution(project, fileNames, new String[0], markerType, idName, id, resolutionClass);
    }

    public static void checkResolution(IProject project, String[] fileNames, String[] results, String markerType, String idName, int id, Class<? extends IMarkerResolution> resolutionClass) throws CoreException {
        IFile file = project.getFile(fileNames[0]);
        Assert.assertTrue((String)("File - " + file.getFullPath() + " must be exist"), (boolean)file.exists());
        MarkerResolutionTestUtil.copyFiles(project, fileNames);
        TestUtil.validate((IResource)file);
        try {
            file = project.getFile(fileNames[0]);
            IMarker[] markers = file.findMarkers(markerType, true, 2);
            int i = 0;
            while (i < markers.length) {
                int messageId;
                IMarker marker = markers[i];
                Integer attribute = (Integer)marker.getAttribute(idName);
                if (attribute != null && (messageId = attribute.intValue()) == id) {
                    IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                    MarkerResolutionTestUtil.checkForConfigureProblemSeverity(resolutions);
                    MarkerResolutionTestUtil.checkForAddSuppressWarnings(file, marker, resolutions);
                    int j = 0;
                    while (j < resolutions.length) {
                        IMarkerResolution resolution = resolutions[j];
                        if (resolution.getClass().equals(resolutionClass)) {
                            if (resolution instanceof TestableResolutionWithRefactoringProcessor) {
                                RefactoringProcessor processor = ((TestableResolutionWithRefactoringProcessor)resolution).getRefactoringProcessor();
                                RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                                Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
                                status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
                                Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
                                CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
                                rootChange.perform((IProgressMonitor)new NullProgressMonitor());
                            } else if (resolution instanceof TestableResolutionWithDialog) {
                                ((TestableResolutionWithDialog)resolution).runForTest(marker);
                            } else {
                                resolution.run(marker);
                            }
                            TestUtil.validate((IResource)file);
                            file = project.getFile(fileNames[0]);
                            IMarker[] newMarkers = file.findMarkers(markerType, true, 2);
                            Assert.assertTrue((String)("Marker resolution did not decrease number of problems. was: " + markers.length + " now: " + newMarkers.length), (newMarkers.length < markers.length ? 1 : 0) != 0);
                            MarkerResolutionTestUtil.checkResults(project, fileNames, results);
                            return;
                        }
                        ++j;
                    }
                    Assert.fail((String)("Marker resolution: " + resolutionClass + " not found"));
                }
                ++i;
            }
            Assert.fail((String)("Problem marker with id: " + id + " not found"));
        }
        finally {
            MarkerResolutionTestUtil.restoreFiles(project, fileNames);
            TestUtil.validate((IResource)file);
        }
    }

    public static void checkResolution(IProject project, String markerType, String idName, int id, Class<? extends IMarkerResolution> resolutionClass) throws CoreException {
        TestUtil.validate((IResource)project);
        try {
            IMarker[] markers = project.findMarkers(markerType, true, 2);
            int i = 0;
            while (i < markers.length) {
                int messageId;
                IMarker marker = markers[i];
                Integer attribute = (Integer)marker.getAttribute(idName);
                if (attribute != null && (messageId = attribute.intValue()) == id) {
                    IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                    MarkerResolutionTestUtil.checkForConfigureProblemSeverity(resolutions);
                    int j = 0;
                    while (j < resolutions.length) {
                        IMarkerResolution resolution = resolutions[j];
                        if (resolution.getClass().equals(resolutionClass)) {
                            if (resolution instanceof TestableResolutionWithRefactoringProcessor) {
                                RefactoringProcessor processor = ((TestableResolutionWithRefactoringProcessor)resolution).getRefactoringProcessor();
                                RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                                Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
                                status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
                                Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
                                CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
                                rootChange.perform((IProgressMonitor)new NullProgressMonitor());
                            } else if (resolution instanceof TestableResolutionWithDialog) {
                                ((TestableResolutionWithDialog)resolution).runForTest(marker);
                            } else {
                                resolution.run(marker);
                            }
                            TestUtil._waitForValidation(project);
                            IMarker[] newMarkers = project.findMarkers(markerType, true, 2);
                            Assert.assertTrue((String)("Marker resolution did not decrease number of problems. was: " + markers.length + " now: " + newMarkers.length), (newMarkers.length < markers.length ? 1 : 0) != 0);
                            return;
                        }
                        ++j;
                    }
                    Assert.fail((String)("Marker resolution: " + resolutionClass + " not found"));
                }
                ++i;
            }
            Assert.fail((String)("Problem marker with id: " + id + " not found"));
        }
        finally {
            TestUtil.validate((IResource)project);
        }
    }

    public static void copyFiles(IProject project, String[] fileNames) throws CoreException {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IFile file = project.getFile(fileName);
            IFile copyFile = project.getFile(String.valueOf(fileName) + ".copy");
            if (copyFile.exists()) {
                copyFile.delete(true, null);
            }
            InputStream is = null;
            try {
                is = file.getContents();
                copyFile.create(is, true, null);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public static void restoreFiles(IProject project, String[] fileNames) throws CoreException {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            IFile file = project.getFile(fileName);
            IFile copyFile = project.getFile(String.valueOf(fileName) + ".copy");
            InputStream is = null;
            try {
                is = copyFile.getContents();
                file.setContents(is, true, false, null);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            copyFile.delete(true, null);
            ++n2;
        }
    }

    private static void checkResults(IProject project, String[] fileNames, String[] results) throws CoreException {
        int i = 0;
        while (i < results.length) {
            IFile file = project.getFile(fileNames[i]);
            IFile resultFile = project.getFile(results[i]);
            String fileContent = FileUtil.readStream((IFile)file);
            String resultContent = FileUtil.readStream((IFile)resultFile);
            Assert.assertEquals((String)"Wrong result of resolution", (String)resultContent, (String)fileContent);
            ++i;
        }
    }
}

