/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.quickfix.QuickFixManager;
import org.jboss.tools.common.ui.marker.AddSuppressWarningsMarkerResolution;
import org.jboss.tools.common.ui.marker.ConfigureProblemSeverityMarkerResolution;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.validation.ValidationMessage;
import org.jboss.tools.common.validation.java.TempJavaProblem;
import org.jboss.tools.common.validation.java.TempJavaProblemAnnotation;
import org.junit.Assert;

public class QuickFixTestUtil {
    private static final int MAX_SECONDS_TO_WAIT = 3;

    protected ISourceViewer getViewer(IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            return ((JavaEditor)editor).getViewer();
        }
        if (editor instanceof EditorPartWrapper) {
            IEditorPart ed = ((EditorPartWrapper)editor).getEditor();
            if (ed instanceof ObjectMultiPageEditor) {
                ((ObjectMultiPageEditor)ed).selectPageByName("Source");
                return ((ObjectMultiPageEditor)ed).getSourceEditor().getTextViewer();
            }
            Assert.fail((String)("Editor must be ObjectMultiPageEditor, was - " + ed.getClass()));
        } else {
            Assert.fail((String)("editor must be instanceof JavaEditor or EditorPartWrapper, but was " + editor.getClass()));
        }
        return null;
    }

    protected String getEditorId(String filename) {
        if (filename.endsWith(".xml")) {
            return "org.jboss.tools.common.model.ui.editor.EditorPartWrapper";
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(filename);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private void checkForConfigureProblemSeverity(IJavaCompletionProposal[] proposals) {
        IJavaCompletionProposal[] iJavaCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal proposal = iJavaCompletionProposalArray[n2];
            if (proposal.getClass().equals(ConfigureProblemSeverityMarkerResolution.class)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Configure Problem Severity quick fix not found");
    }

    private void checkForAddSuppressWarnings(IFile file, Annotation annotation, IJavaCompletionProposal[] proposals) {
        if (annotation instanceof TempJavaProblemAnnotation) {
            String severity = ((TempJavaProblemAnnotation)annotation).getMarkerType();
            if (file.getFileExtension().equals("java") && severity.equals("org.eclipse.jdt.ui.warning")) {
                IJavaCompletionProposal[] iJavaCompletionProposalArray = proposals;
                int n = proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaCompletionProposal proposal = iJavaCompletionProposalArray[n2];
                    if (proposal.getClass().equals(AddSuppressWarningsMarkerResolution.class)) {
                        return;
                    }
                    ++n2;
                }
                Assert.fail((String)"Add @SuppressWarnings marker resolution not found");
            }
        }
    }

    public void checkProposal(IProject project, String fileName, String newFile, String str, int id, Class<? extends IJavaCompletionProposal> proposalClass, boolean checkResult, String problemType) throws CoreException {
        IFile file = project.getFile(fileName);
        IFile nFile = project.getFile(newFile);
        Assert.assertTrue((String)("File - " + file.getFullPath() + " must be exist"), (boolean)file.exists());
        Assert.assertTrue((String)("File - " + nFile.getFullPath() + " must be exist"), (boolean)nFile.exists());
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, this.getEditorId(file.getName()), true);
        ISourceViewer viewer = this.getViewer(editor);
        try {
            IDocument document = viewer.getDocument();
            String text = FileUtil.getContentFromEditorOrFile((IFile)nFile);
            document.set(text);
            int offset = text.indexOf(str);
            Assert.assertTrue((String)("String - " + str + " not found"), (offset > 0 ? 1 : 0) != 0);
            int length = str.length();
            Annotation annotation = this.createAnnotation(problemType, file, id, offset, length);
            Position position = new Position(offset, length);
            IJavaCompletionProposal[] proposals = QuickFixTestUtil.getCompletionProposals(annotation, position);
            this.checkForConfigureProblemSeverity(proposals);
            this.checkForAddSuppressWarnings(file, annotation, proposals);
            IJavaCompletionProposal[] iJavaCompletionProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaCompletionProposal proposal = iJavaCompletionProposalArray[n2];
                if (proposal.getClass().equals(proposalClass)) {
                    return;
                }
                ++n2;
            }
            Assert.fail((String)("Quick fix: " + proposalClass + " not found"));
        }
        finally {
            Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
        }
    }

    public static IJavaCompletionProposal[] getCompletionProposals(Annotation annotation, Position position) {
        ArrayList proposals = new ArrayList();
        if (QuickFixManager.getInstance().hasProposals(annotation, position)) {
            List list = QuickFixManager.getInstance().getProposals(annotation, position);
            proposals.addAll(list);
        }
        return proposals.toArray(new IJavaCompletionProposal[0]);
    }

    private static void checkResults(IFile file, String text) throws CoreException {
        String fileContent = FileUtil.readStream((IFile)file);
        Assert.assertEquals((String)"Wrong result of resolution", (Object)fileContent, (Object)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotation createAnnotation(String problemType, IFile file, int quickFixId, int offset, int length) {
        if ("java".equals(file.getFileExtension())) {
            ICompilationUnit compilationUnit;
            ICompilationUnit iCompilationUnit = compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
            synchronized (iCompilationUnit) {
                try {
                    compilationUnit.reconcile(0, true, null, null);
                }
                catch (JavaModelException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
            Assert.assertNotNull((Object)("Compilation unit not found for file - " + file.getName()));
            ValidationMessage message = new ValidationMessage(2, "Message", compilationUnit.getResource());
            message.setOffset(offset);
            message.setLength(length);
            message.setLineNo(1);
            message.setBundleName("org.jboss.tools.cdi.internal.core.validation.messages");
            message.setAttribute("org.jboss.tools.common.validation.asyoutype", (Object)Boolean.TRUE);
            message.setAttribute("Message_id", (Object)quickFixId);
            message.setAttribute("preference_key", (Object)"preferenceKey");
            message.setAttribute("jbt.type", (Object)problemType);
            TempJavaProblem problem = new TempJavaProblem(message, "origin");
            TempJavaProblemAnnotation annotation = new TempJavaProblemAnnotation(problem, compilationUnit);
            return annotation;
        }
        TemporaryAnnotation annotation = new TemporaryAnnotation(new Position(offset, length), "org.eclipse.wst.sse.ui.temp.warning", "message", null, quickFixId);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.jboss.tools.common.validation.asyoutype", Boolean.TRUE);
        attributes.put("Message_id", quickFixId);
        attributes.put("preference_key", "preferenceKey");
        attributes.put("jbt.type", problemType);
        annotation.setAttributes(attributes);
        return annotation;
    }
}

