/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.test.util.JobUtils;
import org.junit.Assert;

public class RenameParticipantTestUtil {
    public static void checkRenameParticipant(IJavaElement element, RenameProcessor renameProcessor, RefactoringParticipant participant, String newName, List<TestChangeStructure> changeList) throws CoreException, BadLocationException {
        RenameParticipantTestUtil.processTestChanges(changeList);
        JobUtils.waitForIdle();
        participant.initialize((RefactoringProcessor)renameProcessor, (Object)element, (RefactoringArguments)new RenameArguments(newName, true));
        RefactoringStatus status = participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        Assert.assertNotNull((String)"Rename participant returned null status", (Object)status);
        Assert.assertFalse((String)"There is fatal errors in rename participant", (boolean)status.hasFatalError());
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        RenameParticipantTestUtil.checkChanges(rootChange, changeList);
    }

    public static void checkRenameProcessor(RenameProcessor processor, List<TestChangeStructure> changeList) throws CoreException, BadLocationException {
        RefactoringStatusEntry entry;
        RefactoringStatusEntry[] entries;
        RenameParticipantTestUtil.processTestChanges(changeList);
        JobUtils.waitForIdle();
        RenameParticipantTestUtil.checkBeforeRefactoring(changeList);
        RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        status = processor.checkFinalConditions((IProgressMonitor)new NullProgressMonitor(), null);
        refactoringStatusEntryArray = entries = status.getEntries();
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)processor.createChange((IProgressMonitor)new NullProgressMonitor());
        RenameParticipantTestUtil.checkChanges(rootChange, changeList);
    }

    public static void checkMoveParticipant(RefactoringProcessor processor, IResource oldObject, IResource destinationObject, MoveParticipant participant, List<TestChangeStructure> changeList) throws CoreException, BadLocationException {
        RefactoringStatusEntry[] entries;
        RenameParticipantTestUtil.processTestChanges(changeList);
        JobUtils.waitForIdle();
        RenameParticipantTestUtil.checkBeforeRefactoring(changeList);
        MoveArguments arguments = new MoveArguments((Object)destinationObject, true);
        boolean initialized = participant.initialize(processor, (Object)oldObject, (RefactoringArguments)arguments);
        Assert.assertTrue((String)"Participant has not been initialized", (boolean)initialized);
        RefactoringStatus status = participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Move processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change mainChange = processor.createChange((IProgressMonitor)new NullProgressMonitor());
        mainChange.perform((IProgressMonitor)new NullProgressMonitor());
        RenameParticipantTestUtil.checkChanges(rootChange, changeList);
    }

    public static void checkRenameParticipant(RefactoringProcessor processor, IResource oldObject, String newName, RenameParticipant participant, List<TestChangeStructure> changeList) throws CoreException, BadLocationException {
        RefactoringStatusEntry[] entries;
        RenameParticipantTestUtil.processTestChanges(changeList);
        JobUtils.waitForIdle((long)2000L);
        RenameParticipantTestUtil.checkBeforeRefactoring(changeList);
        RenameArguments arguments = new RenameArguments(newName, true);
        boolean initialized = participant.initialize(processor, (Object)oldObject, (RefactoringArguments)arguments);
        Assert.assertTrue((String)"Participant has not been initialized", (boolean)initialized);
        RefactoringStatus status = participant.checkConditions((IProgressMonitor)new NullProgressMonitor(), null);
        RefactoringStatusEntry[] refactoringStatusEntryArray = entries = status.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringStatusEntry entry = refactoringStatusEntryArray[n2];
            System.out.println("Refactor status - " + entry.getMessage());
            ++n2;
        }
        Assert.assertNull((String)"Rename processor returns fatal error", (Object)status.getEntryMatchingSeverity(4));
        CompositeChange rootChange = (CompositeChange)participant.createChange((IProgressMonitor)new NullProgressMonitor());
        Change mainChange = processor.createChange((IProgressMonitor)new NullProgressMonitor());
        mainChange.perform((IProgressMonitor)new NullProgressMonitor());
        RenameParticipantTestUtil.checkChanges(rootChange, changeList);
    }

    private static void processTestChanges(List<TestChangeStructure> structureList) throws CoreException, BadLocationException {
        for (TestChangeStructure tStructure : structureList) {
            IFile file = tStructure.getProject().getFile(tStructure.getFileName());
            FileEditorInput editorInput = new FileEditorInput(file);
            IDocumentProvider documentProvider = null;
            documentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)editorInput);
            Assert.assertNotNull((String)("The document provider for the file \"" + file.getFullPath() + "\" is not loaded"), (Object)documentProvider);
            documentProvider.connect((Object)editorInput);
            IDocument document = documentProvider.getDocument((Object)editorInput);
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
            Region region = new Region(0, 0);
            for (TestTextChange tChange : tStructure.getTextChanges()) {
                if (tChange.getOffset() != -1) continue;
                IRegion newRegion = adapter.find(region.getOffset() + region.getLength(), tChange.getSearchText(), true, true, false, false);
                if (newRegion != null) {
                    tChange.setOffset(newRegion.getOffset());
                    region = newRegion;
                    continue;
                }
                Assert.fail((String)("Can not find string - " + tChange.getSearchText()));
            }
            documentProvider.disconnect((Object)editorInput);
        }
    }

    private static void checkBeforeRefactoring(List<TestChangeStructure> changeList) {
        for (TestChangeStructure changeStructure : changeList) {
            IFile file = changeStructure.getProject().getFile(changeStructure.getFileName());
            String content = null;
            try {
                content = RenameParticipantTestUtil.readStream(file);
            }
            catch (CoreException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            for (TestTextChange change : changeStructure.getTextChanges()) {
                Assert.assertNotSame((Object)change.getText(), (Object)content.substring(change.getOffset(), change.getOffset() + change.getLength()));
            }
        }
    }

    private static void checkChanges(CompositeChange rootChange, List<TestChangeStructure> changeList) throws CoreException {
        Assert.assertNotNull((String)"Root change is null", (Object)rootChange);
        int cfr_ignored_0 = rootChange.getChildren().length;
        int i = 0;
        while (i < rootChange.getChildren().length) {
            Change fileChange = rootChange.getChildren()[i];
            MultiTextEdit edit = null;
            IFile file = null;
            if (fileChange instanceof TextFileChange) {
                edit = (MultiTextEdit)((TextFileChange)fileChange).getEdit();
                file = ((TextFileChange)fileChange).getFile();
            } else {
                Assert.fail((String)("fileChange must be instance of TextFileChange but was - " + fileChange.getClass()));
            }
            TestChangeStructure change = RenameParticipantTestUtil.findChange(changeList, file);
            Assert.assertNotNull((String)("Change not found for file - " + file.getFullPath()), (Object)change);
            Assert.assertEquals((long)change.size(), (long)edit.getChildrenSize());
            TextEdit[] textEditArray = edit.getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit te = textEditArray[n2];
                RenameParticipantTestUtil.checkEdit(change, (ReplaceEdit)te);
                ++n2;
            }
            ++i;
        }
    }

    public static TestChangeStructure findChange(List<TestChangeStructure> changeList, IFile file) {
        for (TestChangeStructure tcs : changeList) {
            if (!tcs.getFileName().endsWith(file.getFullPath().removeFirstSegments(1).toString())) continue;
            return tcs;
        }
        return null;
    }

    private static void checkEdit(TestChangeStructure change, ReplaceEdit edit) throws CoreException {
        IFile file = change.getProject().getFile(change.getFileName());
        String fileContent = FileUtil.readStream((IFile)file);
        String newText = edit.getText();
        String editText = fileContent.substring(edit.getOffset(), edit.getOffset() + edit.getLength());
        for (TestTextChange ttc : change.getTextChanges()) {
            if (ttc.getOffset() != edit.getOffset()) continue;
            Assert.assertEquals((String)("Wrong length of TextEdit  file - " + file.getFullPath() + " editText - " + editText + " newText - " + newText), (long)ttc.getLength(), (long)newText.length());
            Assert.assertEquals((String)("Wrong text of TextEdit  file - " + file.getFullPath() + " editText - " + editText), (Object)ttc.getText(), (Object)newText);
            return;
        }
        Assert.fail((String)("Unexpected edit file - " + file.getFullPath() + " offset - " + edit.getOffset() + " length - " + edit.getLength() + " text - " + editText + " newText - " + newText));
    }

    public static IType getJavaType(IProject project, String className) {
        IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            try {
                return javaProject.findType(className);
            }
            catch (JavaModelException ex) {
                Assert.fail((String)ex.getMessage());
            }
        }
        return null;
    }

    public static IMethod getJavaMethod(IProject project, String className, String methodName) {
        IType type = RenameParticipantTestUtil.getJavaType(project, className);
        if (type != null) {
            return type.getMethod(methodName, new String[0]);
        }
        return null;
    }

    public static IField getJavaField(IProject project, String className, String fieldName) {
        IType type = RenameParticipantTestUtil.getJavaType(project, className);
        if (type != null) {
            return type.getField(fieldName);
        }
        return null;
    }

    public static String readStream(IFile file) throws CoreException {
        String content = null;
        InputStream in = null;
        try {
            in = file.getContents();
            content = RenameParticipantTestUtil.readStream(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }
        return content;
    }

    public static String readStream(InputStream is) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer("");
            try {
                try {
                    int l;
                    byte[] b = new byte[4096];
                    while ((l = is.read(b, 0, b.length)) >= 0) {
                        sb.append(new String(b, 0, l));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        Assert.fail((String)e2.getMessage());
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        return sb.toString();
    }

    public static class TestChangeStructure {
        private IProject project;
        private String fileName;
        ArrayList<TestTextChange> textChanges = new ArrayList();

        public TestChangeStructure(IProject project, String fileName) {
            this.project = project;
            this.fileName = fileName;
        }

        public IProject getProject() {
            return this.project;
        }

        public String getFileName() {
            return this.fileName;
        }

        public ArrayList<TestTextChange> getTextChanges() {
            return this.textChanges;
        }

        public void addTextChange(TestTextChange change) {
            this.textChanges.add(change);
        }

        public int size() {
            return this.textChanges.size();
        }
    }

    public static class TestTextChange {
        private String searchText;
        private int offset;
        private int length;
        private String text;

        public TestTextChange(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public TestTextChange(String searchText, int length, String text) {
            this.offset = -1;
            this.searchText = searchText;
            this.length = length;
            this.text = text;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getSearchText() {
            return this.searchText;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            return this.text;
        }
    }
}

