/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.contentassist;

import java.lang.reflect.Field;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.jboss.tools.common.base.test.contentassist.CATestUtil;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.test.util.WorkbenchUtils;

public abstract class AbstractContentAssistantTestCase
extends TestCase {
    protected String fileName;
    protected IProject project = null;
    protected IEditorPart editorPart = null;
    protected ITextEditor textEditor = null;
    protected ISourceViewer viewer = null;
    protected IContentAssistant contentAssistant = null;
    protected IDocument document = null;

    public void openEditor(String fileName) {
        this.fileName = fileName;
        IFile testfile = this.project.getFile(fileName);
        AbstractContentAssistantTestCase.assertTrue((String)("Test file doesn't exist: " + this.project.getName() + "/" + fileName), (testfile.exists() && testfile.isAccessible() ? 1 : 0) != 0);
        this.editorPart = WorkbenchUtils.openEditor((String)(String.valueOf(this.project.getName()) + "/" + fileName));
        this.obtainTextEditor(this.editorPart);
        this.viewer = this.getTextViewer();
        this.document = this.viewer.getDocument();
        AbstractContentAssistantTestCase.assertNotNull((String)("Cannot get the Source Viewer for the editor for page \"" + fileName + "\""), (Object)this.viewer);
        this.contentAssistant = this.getContentAssistantInternal();
        if (this.contentAssistant instanceof ContentAssistant) {
            ((ContentAssistant)this.contentAssistant).enableAutoInsert(false);
        }
        AbstractContentAssistantTestCase.assertNotNull((String)("Cannot get the Content Assistant instance for the editor for page \"" + fileName + "\""), (Object)this.contentAssistant);
    }

    private IContentAssistant getContentAssistantInternal() {
        try {
            Field f = SourceViewer.class.getDeclaredField("fContentAssistant");
            f.setAccessible(true);
            return (IContentAssistant)f.get(this.viewer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract ISourceViewer getTextViewer();

    protected void obtainTextEditor(IEditorPart editorPart) {
    }

    public ICompletionProposal[] checkProposals(String fileName, int offset, String[] proposals, boolean exactly) {
        return this.checkProposals(fileName, null, offset, proposals, null, exactly, true);
    }

    public ICompletionProposal[] checkProposals(String fileName, String substring, int offset, String[] proposals, boolean exactly) {
        return this.checkProposals(fileName, substring, offset, proposals, null, exactly, false);
    }

    public ICompletionProposal[] checkProposals(String fileName, String substring, int offset, String[] proposals, Image[] images, boolean exactly) {
        return this.checkProposals(fileName, substring, offset, proposals, images, exactly, false);
    }

    public ICompletionProposal[] checkProposals(String fileName, String substring, int offset, String[] proposals, boolean exactly, boolean excludeELProposalsFromExactTest) {
        return this.checkProposals(fileName, substring, offset, proposals, null, exactly, excludeELProposalsFromExactTest);
    }

    public ICompletionProposal[] checkProposals(String fileName, String substring, int offset, String[] proposals, Image[] images, boolean exactly, boolean excludeELProposalsFromExactTest) {
        List<ICompletionProposal> res;
        if (images != null) {
            AbstractContentAssistantTestCase.assertEquals((String)"number of images and number of proposals must be the same or images must be null", (int)proposals.length, (int)images.length);
        }
        this.openEditor(fileName);
        AbstractContentAssistantTestCase.assertNotNull((String)"Viewer is not initialized", (Object)this.viewer);
        AbstractContentAssistantTestCase.assertNotNull((String)"Content Assistant is not initialized", (Object)this.contentAssistant);
        int position = 0;
        if (substring != null) {
            String documentContent = this.document.get();
            position = documentContent.indexOf(substring);
        }
        AbstractContentAssistantTestCase.assertTrue((String)"Content Assistant returned no proposals", ((res = CATestUtil.collectProposals(this.contentAssistant, (ITextViewer)this.viewer, position + offset)) != null && res.size() > 0 ? 1 : 0) != 0);
        ICompletionProposal[] result = res.toArray(new ICompletionProposal[res.size()]);
        StringBuffer sb = new StringBuffer("[");
        ICompletionProposal[] iCompletionProposalArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal p = iCompletionProposalArray[n2];
            sb.append(p.getDisplayString()).append("; ");
            ++n2;
        }
        sb.append("]");
        int foundCounter = 0;
        int i = 0;
        while (i < proposals.length) {
            boolean found;
            Image image = null;
            if (images != null) {
                image = images[i];
            }
            if (found = this.compareProposal(proposals[i], image, result)) {
                ++foundCounter;
            }
            AbstractContentAssistantTestCase.assertTrue((String)("Proposal " + proposals[i] + " not found! Found proposals: " + sb.toString()), (boolean)found);
            ++i;
        }
        if (exactly) {
            if (excludeELProposalsFromExactTest) {
                AbstractContentAssistantTestCase.assertEquals((String)("Some other proposals were found! Found proposals: " + sb.toString()), (int)foundCounter, (int)proposals.length);
            } else {
                AbstractContentAssistantTestCase.assertEquals((String)("Some other proposals were found! Found proposals: " + sb.toString()), (int)result.length, (int)proposals.length);
            }
        }
        return result;
    }

    protected boolean isRelevantProposal(ICompletionProposal proposal) {
        return false;
    }

    public boolean compareProposal(String proposalName, Image image, ICompletionProposal[] proposals) {
        int i = 0;
        while (i < proposals.length) {
            if (this.isRelevantProposal(proposals[i])) {
                CustomCompletionProposal ap = (CustomCompletionProposal)proposals[i];
                String replacementString = ap.getReplacementString().toLowerCase();
                if (replacementString.equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
                if (replacementString.indexOf("/>") != -1) {
                    replacementString = replacementString.substring(0, replacementString.indexOf("/>"));
                }
                if (replacementString.indexOf(62) != -1) {
                    replacementString = replacementString.substring(0, replacementString.indexOf(62));
                }
                if (replacementString.equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
                String[] replacementStringParts = replacementString.split(" ");
                if (replacementStringParts != null && replacementStringParts.length > 0 && replacementStringParts[0].equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
                replacementStringParts = replacementString.split("=");
                if (replacementStringParts != null && replacementStringParts.length > 0 && replacementStringParts[0].equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
                replacementStringParts = replacementString.split("}");
                if (replacementStringParts != null && replacementStringParts.length > 0 && replacementStringParts[0].equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
                if ((replacementString = Utils.trimQuotes((String)replacementString)).equalsIgnoreCase(proposalName)) {
                    return this.compareImages(image, proposals[i]);
                }
            } else if (proposals[i].getDisplayString().toLowerCase().equals(proposalName.toLowerCase())) {
                return this.compareImages(image, proposals[i]);
            }
            ++i;
        }
        return false;
    }

    private boolean compareImages(Image expected, ICompletionProposal proposal) {
        if (expected != null) {
            AbstractContentAssistantTestCase.assertEquals((String)("<" + proposal.getDisplayString() + "> completion proposal returns wrong image"), (Object)expected, (Object)proposal.getImage());
        }
        return true;
    }

    public void closeEditor() {
        if (this.editorPart != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(this.editorPart, false);
            this.editorPart = null;
        }
        this.viewer = null;
        this.document = null;
        this.contentAssistant = null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ITextEditor getTextEditor() {
        return this.textEditor;
    }

    public ISourceViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    public IContentAssistant getContentAssistant() {
        return this.contentAssistant;
    }

    public void setContentAssistant(IContentAssistant contentAssistant) {
        this.contentAssistant = contentAssistant;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }
}

