/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.kb;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.util.FileUtil;

public class QueryParticipantTestUtils
extends TestCase {
    public static final int FIELD_SEARCH = 1;
    public static final int METHOD_SEARCH = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int PARAMETER_SEARCH = 4;

    public static void testSearchParticipant(IProject project, String fileName, int searchType, String elementName, String parameterName, IQueryParticipant participant, List<MatchStructure> matches) throws CoreException {
        IFile file = project.getFile(fileName);
        QueryParticipantTestUtils.assertNotNull((String)("File - " + fileName + " not found"), (Object)file);
        ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
        QueryParticipantTestUtils.assertNotNull((String)"CompilationUnit not found", (Object)compilationUnit);
        IField element = null;
        IType type = compilationUnit.findPrimaryType();
        QueryParticipantTestUtils.assertNotNull((String)"Primary type not found", (Object)type);
        if (searchType == 1) {
            element = type.getField(elementName);
        } else if (searchType == 2) {
            element = QueryParticipantTestUtils.getMethod(type, elementName);
        } else if (searchType == 3) {
            element = type;
        } else if (searchType == 4) {
            IMethod method = QueryParticipantTestUtils.getMethod(type, elementName);
            element = QueryParticipantTestUtils.getParameter(method, parameterName);
        }
        QueryParticipantTestUtils.assertNotNull((String)"Java Element not found", (Object)element);
        SearchRequestor requestor = new SearchRequestor();
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IJavaSearchScope scope = factory.createWorkspaceScope(true);
        String description = factory.getWorkspaceScopeDescription(true);
        ElementQuerySpecification specification = new ElementQuerySpecification((IJavaElement)element, 2, scope, description);
        participant.search((ISearchRequestor)requestor, (QuerySpecification)specification, (IProgressMonitor)new NullProgressMonitor());
        List<Match> matchesForCheck = requestor.getMatches();
        QueryParticipantTestUtils.checkMatches(matchesForCheck, matches);
    }

    private static IMethod getMethod(IType type, String name) throws JavaModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static ILocalVariable getParameter(IMethod method, String name) throws JavaModelException {
        ILocalVariable[] parameters;
        ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            if (parameter.getElementName().equals(name)) {
                return parameter;
            }
            ++n2;
        }
        return null;
    }

    private static void checkMatches(List<Match> matchesForCheck, List<MatchStructure> matchList) throws CoreException {
        for (Match match : matchesForCheck) {
            QueryParticipantTestUtils.assertTrue((String)"Match must return IFile", (boolean)(match.getElement() instanceof IFile));
            IFile file = (IFile)match.getElement();
            String filePath = file.getFullPath().toString();
            String text = FileUtil.getContentFromEditorOrFile((IFile)file);
            String name = text.substring(match.getOffset(), match.getOffset() + match.getLength());
            MatchStructure ms = QueryParticipantTestUtils.findMatch(matchList, match, filePath, name);
            QueryParticipantTestUtils.assertNotNull((String)("Unexpected match found (file - " + filePath + " name - " + name + ")"), (Object)ms);
            ms.checked = true;
        }
        for (MatchStructure ms : matchList) {
            QueryParticipantTestUtils.assertTrue((String)("Match not found (file - " + ms.path + " name - " + ms.name + ")"), (boolean)ms.checked);
        }
    }

    protected static MatchStructure findMatch(List<MatchStructure> matchList, Match match, String filePath, String name) {
        for (MatchStructure ms : matchList) {
            if (ms.checked || !ms.path.equals(filePath) || !ms.name.equals(name)) continue;
            return ms;
        }
        return null;
    }

    public static class MatchStructure {
        String path;
        String name;
        boolean checked;

        public MatchStructure(String path, String name) {
            this.path = path;
            this.name = name;
            this.checked = false;
        }
    }

    static class SearchRequestor
    implements ISearchRequestor {
        ArrayList<Match> matches = new ArrayList();

        SearchRequestor() {
        }

        public void reportMatch(Match match) {
            this.matches.add(match);
        }

        public List<Match> getMatches() {
            return this.matches;
        }
    }
}

