/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.validation.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jboss.tools.common.base.test.validation.AbstractAsYouTypeValidationTest;
import org.jboss.tools.common.validation.CommonValidationPlugin;
import org.jboss.tools.tests.AbstractResourceMarkerTest;

public class BaseAsYouTypeInJavaValidationTest
extends AbstractAsYouTypeValidationTest {
    public static final String MARKER_TYPE = "org.jboss.tools.common.validation.temp";
    public static final String RESOURCE_MARKER_TYPE = "org.jboss.tools.jst.web.kb.elproblem";
    private String fResourceMarkerType = null;

    public BaseAsYouTypeInJavaValidationTest(IProject project, String resourceMarkerType) {
        this.project = project;
        this.fResourceMarkerType = resourceMarkerType;
        CommonValidationPlugin.getDefault().earlyStartup();
    }

    public BaseAsYouTypeInJavaValidationTest() {
        this.fResourceMarkerType = RESOURCE_MARKER_TYPE;
        CommonValidationPlugin.getDefault().earlyStartup();
    }

    @Override
    protected void obtainEditor(IEditorPart editorPart) {
        if (!(editorPart instanceof JavaEditor) || editorPart instanceof ClassFileEditor) {
            return;
        }
        this.textEditor = (JavaEditor)editorPart;
        BaseAsYouTypeInJavaValidationTest.assertNotNull((String)("Cannot get the Java Text Editor instance for Java Class file \"" + this.fileName + "\""), (Object)this.textEditor);
        BaseAsYouTypeInJavaValidationTest.assertTrue((String)"Java Editor is opened for a binary Java Class", (boolean)(this.textEditor.getEditorInput() instanceof IFileEditorInput));
        this.file = ((IFileEditorInput)this.textEditor.getEditorInput()).getFile();
        BaseAsYouTypeInJavaValidationTest.assertNotNull((String)"Java Editor is opened for a binary Java Class", (Object)this.file);
    }

    @Override
    protected ISourceViewer getTextViewer() {
        return this.textEditor instanceof JavaEditor ? ((JavaEditor)this.textEditor).getViewer() : null;
    }

    @Override
    protected boolean isAnnotationAcceptable(Annotation annotation) {
        if (!(annotation instanceof CompilationUnitDocumentProvider.ProblemAnnotation)) {
            return false;
        }
        CompilationUnitDocumentProvider.ProblemAnnotation problemAnnotation = (CompilationUnitDocumentProvider.ProblemAnnotation)annotation;
        String markerType = problemAnnotation.getMarkerType();
        return MARKER_TYPE.equalsIgnoreCase(markerType);
    }

    @Override
    protected boolean isMarkerAnnotationAcceptable(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
        IMarker marker = markerAnnotation.getMarker();
        try {
            String type = marker.getType();
            return this.fResourceMarkerType.equals(type);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void assertResourceMarkerIsCreated(IFile file, String errorMessage, int line) throws CoreException {
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers((IResource)file, (String)this.fResourceMarkerType, (String)errorMessage, (boolean)true);
        BaseAsYouTypeInJavaValidationTest.assertNotNull((String)("Resource Marker not found for type: " + this.fResourceMarkerType + ", message: [" + errorMessage + "] at line: " + line), (Object)markers);
        BaseAsYouTypeInJavaValidationTest.assertFalse((String)("Resource Marker not found for type: " + this.fResourceMarkerType + ", message: [" + errorMessage + "] at line: " + line), (markers.length == 0 ? 1 : 0) != 0);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            Integer l = m.getAttribute("lineNumber", -1);
            if (l != null && line == l) {
                return;
            }
            ++n2;
        }
        BaseAsYouTypeInJavaValidationTest.fail((String)("Resource Marker not found for type: " + this.fResourceMarkerType + ", message: [" + errorMessage + "] at line: " + line));
    }

    public void assertNoResourceMarkerIsCreated(IFile file, String errorMessage, int line) throws CoreException {
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers((IResource)file, (String)this.fResourceMarkerType, (String)errorMessage, (boolean)true);
        BaseAsYouTypeInJavaValidationTest.assertTrue((String)("Resource Marker is found for type: " + this.fResourceMarkerType + ", message: [" + errorMessage + "] at line: " + line), (markers == null || markers.length == 0 ? 1 : 0) != 0);
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                Integer l = m.getAttribute("lineNumber", -1);
                if (l != null && line == l) {
                    BaseAsYouTypeInJavaValidationTest.fail((String)("Resource Marker is found for type: " + this.fResourceMarkerType + ", message: [" + errorMessage + "] at line: " + line));
                }
                ++n2;
            }
        }
    }
}

