/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.ui;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.modeshape.ui.UiMessages;

public final class UiUtils {
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_JOIN_DELIMITER = ",";

    public static void configureColumn(TableViewerColumn viewerColumn, CellLabelProvider labelProvider, String headerText, String headerToolTip, boolean moveable, boolean resizable) {
        UiUtils.verifyIsNotNull(viewerColumn, "viewerColumn");
        UiUtils.verifyIsNotNull(labelProvider, "labelProvider");
        viewerColumn.setLabelProvider(labelProvider);
        TableColumn column = viewerColumn.getColumn();
        if (!UiUtils.isEmpty(headerText)) {
            column.setText(headerText);
        }
        column.setToolTipText(headerToolTip);
        column.setMoveable(false);
        column.setResizable(resizable);
        column.pack();
    }

    public static int convertWidthInCharsToPixels(Control control, int numChars) {
        UiUtils.verifyIsNotNull(control, "control");
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)numChars);
    }

    public static IViewPart getView(String viewId) {
        UiUtils.verifyIsNotEmpty(viewId, "viewId");
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
        }
        return null;
    }

    public static String ensureNotNull(String text) {
        return text == null ? EMPTY_STRING : text;
    }

    public static boolean isEmpty(String stringBeingChecked) {
        return stringBeingChecked == null || stringBeingChecked.isEmpty();
    }

    public static String join(Collection<?> items, String delimiter) {
        UiUtils.verifyIsNotNull(items, "items");
        delimiter = delimiter == null || delimiter.isEmpty() ? DEFAULT_JOIN_DELIMITER : delimiter;
        StringBuilder builder = new StringBuilder();
        Iterator<?> itr = items.iterator();
        while (itr.hasNext()) {
            Object item = itr.next();
            if (item == null) {
                item = EMPTY_STRING;
            }
            builder.append(item.toString());
            if (!itr.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static void pack(TableViewer ... viewers) {
        TableViewer[] tableViewerArray = viewers;
        int n = viewers.length;
        int n2 = 0;
        while (n2 < n) {
            TableViewer viewer = tableViewerArray[n2];
            UiUtils.verifyIsNotNull(viewer, "viewer");
            TableColumn[] tableColumnArray = viewer.getTable().getColumns();
            int n3 = tableColumnArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TableColumn column = tableColumnArray[n4];
                column.pack();
                ++n4;
            }
            ++n2;
        }
    }

    public static void verifyIsNotEmpty(String text, String name) {
        if (UiUtils.isEmpty(text)) {
            if (name == null || name.isEmpty()) {
                name = EMPTY_STRING;
            }
            throw new IllegalArgumentException(NLS.bind((String)UiMessages.stringIsEmpty, (Object)name));
        }
    }

    public static void verifyIsNotNull(Object object, String name) {
        if (object == null) {
            if (name == null || name.isEmpty()) {
                name = EMPTY_STRING;
            }
            throw new IllegalArgumentException(NLS.bind((String)UiMessages.objectIsNull, (Object)name));
        }
    }

    private UiUtils() {
    }
}

