/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.ui.forms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jboss.tools.modeshape.ui.Activator;
import org.jboss.tools.modeshape.ui.UiConstants;
import org.jboss.tools.modeshape.ui.UiMessages;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.jboss.tools.modeshape.ui.forms.FormUtils;
import org.jboss.tools.modeshape.ui.forms.MessageLabelProvider;
import org.jboss.tools.modeshape.ui.forms.MessageViewerSorter;

public class MessageSummaryDialog
extends FormDialog {
    private final String dialogTitle;
    private final String messageAreaMessage;
    private final String messageAreaTitle;
    private final int messageType;
    private final IMessage[] messages;

    public MessageSummaryDialog(Shell parent, String dialogTitle, String messageAreaTitle, String messageAreaMessage, int messageType, IMessage[] messages) {
        super(parent);
        UiUtils.verifyIsNotNull(messages, "messages");
        this.dialogTitle = dialogTitle;
        this.messages = messages;
        this.messageAreaTitle = messageAreaTitle;
        this.messageAreaMessage = messageAreaMessage;
        this.messageType = messageType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        Button btn = this.createButton(parent, 1024, UiMessages.export, false);
        btn.setToolTipText(UiMessages.exportMessagesToolTip);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageSummaryDialog.this.handleExportMessages();
            }
        });
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(this.messageAreaTitle);
        scrolledForm.setMessage(this.messageAreaMessage, this.messageType, this.messages);
        scrolledForm.getBody().setLayout((Layout)new GridLayout());
        scrolledForm.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        FormToolkit toolkit = managedForm.getToolkit();
        Composite container = toolkit.createComposite(managedForm.getForm().getBody());
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(container);
        int count = this.messages.length;
        count = count > 20 ? 20 : (count += 2);
        Table table = FormUtils.createTable(toolkit, container);
        GridData gd = (GridData)table.getLayoutData();
        gd.minimumHeight = gd.heightHint = table.getItemHeight() * count;
        TableViewer viewer = new TableViewer(table);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return MessageSummaryDialog.this.getMessages();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        TableViewerColumn messageTypeColumn = new TableViewerColumn(viewer, 0x1000000);
        UiUtils.configureColumn(messageTypeColumn, (CellLabelProvider)new MessageLabelProvider(true), "", "", false, false);
        TableViewerColumn messageColumn = new TableViewerColumn(viewer, 16384);
        UiUtils.configureColumn(messageColumn, (CellLabelProvider)new MessageLabelProvider(false), UiMessages.messageColumnHeader, "", false, true);
        viewer.setSorter((ViewerSorter)new MessageViewerSorter());
        viewer.setInput((Object)this);
        UiUtils.pack(viewer);
    }

    IMessage[] getMessages() {
        return this.messages;
    }

    void handleExportMessages() {
        block21: {
            FileDialog dlg = new FileDialog(this.getShell(), 8192);
            dlg.setFilterExtensions(new String[]{"*.txt"});
            dlg.setText(UiMessages.exportMessagesDialogTitle);
            dlg.setFileName(UiMessages.exportMessagesDialogDefaultFileName);
            String fileName = dlg.open();
            if (fileName != null) {
                StringBuilder builder = new StringBuilder();
                IMessage[] iMessageArray = this.messages;
                int n = this.messages.length;
                int n2 = 0;
                while (n2 < n) {
                    IMessage message = iMessageArray[n2];
                    int messageType = message.getMessageType();
                    if (messageType == 3) {
                        builder.append(UiMessages.errorDialogTitle).append(" - ");
                    } else if (messageType == 2) {
                        builder.append(UiMessages.errorDialogTitle).append(" - ");
                    } else if (messageType == 1) {
                        builder.append(UiMessages.errorDialogTitle).append(" - ");
                    }
                    builder.append(message.getMessage()).append('\n');
                    ++n2;
                }
                BufferedWriter out = null;
                try {
                    try {
                        out = new BufferedWriter(new FileWriter(fileName));
                        out.write(builder.toString());
                        out.flush();
                    }
                    catch (Exception e) {
                        Activator.getSharedInstance().getLog().log((IStatus)new Status(4, UiConstants.PLUGIN_ID, null, (Throwable)e));
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block21;
                        }
                        catch (IOException iOException) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

