/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.ui.graphics;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.modeshape.ui.UiUtils;

public final class GraphicsUtils {
    private static ImageDescriptor createImageDescriptor(AbstractUIPlugin uiPlugin, String pathToImage) {
        assert (uiPlugin != null) : "UI Plugin is null";
        assert (pathToImage != null) : "pathToImage is null";
        String pluginId = uiPlugin.getBundle().getSymbolicName();
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)pathToImage);
    }

    public static final Image getImage(AbstractUIPlugin uiPlugin, String pathToImage) {
        ImageDescriptor newImageDescriptor;
        UiUtils.verifyIsNotNull(uiPlugin, "uiPlugin");
        ImageRegistry imageRegistry = uiPlugin.getImageRegistry();
        Image image = imageRegistry.get(pathToImage);
        if (image == null && pathToImage != null && (newImageDescriptor = GraphicsUtils.createImageDescriptor(uiPlugin, pathToImage)) != null) {
            imageRegistry.put(pathToImage, newImageDescriptor);
            image = imageRegistry.get(pathToImage);
        }
        return image == null ? ImageDescriptor.getMissingImageDescriptor().createImage() : image;
    }

    public static Image getSharedImage(String imageId) {
        UiUtils.verifyIsNotEmpty(imageId, "imageId");
        Image result = PlatformUI.getWorkbench().getSharedImages().getImage(imageId);
        return result == null ? ImageDescriptor.getMissingImageDescriptor().createImage() : result;
    }

    public static ImageDescriptor getSharedImageDescriptor(String imageId) {
        UiUtils.verifyIsNotEmpty(imageId, "imageId");
        ImageDescriptor result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageId);
        if (result != null) {
            return result;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    private GraphicsUtils() {
    }
}

