/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.CostAnalyzer;
import org.teiid.designer.jdbc.relational.impl.ColumnStatistics;
import org.teiid.designer.jdbc.relational.impl.DefaultCostAnalyzerImpl;
import org.teiid.designer.jdbc.relational.impl.OracleCostAnalyzerImpl;
import org.teiid.designer.jdbc.relational.impl.TableStatistics;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.Table;

public class CostAnalyzerFactory {
    private static CostAnalyzerFactory costAnalyzerFactory = null;

    private CostAnalyzerFactory() {
    }

    public static CostAnalyzerFactory getCostAnalyzerFactory() {
        if (costAnalyzerFactory == null) {
            costAnalyzerFactory = new CostAnalyzerFactory();
        }
        return costAnalyzerFactory;
    }

    public CostAnalyzer getCostAnalyzer(JdbcSource src, String password) {
        String dbmsType = this.getDbmsType(src.getDriverName());
        if ("oracle".equals(dbmsType)) {
            return new OracleCostAnalyzerImpl(src, password);
        }
        return new DefaultCostAnalyzerImpl(src, password);
    }

    private String getDbmsType(String driverName) {
        if ((driverName = driverName.toLowerCase()).indexOf("oracle") > -1) {
            return "oracle";
        }
        if (driverName.indexOf("db2") > -1) {
            return "db2";
        }
        if (driverName.indexOf("sqlserver") > -1) {
            return "sqlserver";
        }
        return "";
    }

    public Map createTableInfos(List emfTables) {
        if (emfTables != null) {
            HashMap<String, TableStatistics> tableInfos = new HashMap<String, TableStatistics>();
            for (Table emfTable : emfTables) {
                if (emfTable.getNameInSource() == null) continue;
                Catalog catalog = emfTable.getCatalog();
                String catalogName = catalog == null || catalog.getNameInSource() == null ? null : this.unQualifyName(catalog.getNameInSource());
                Schema schema = emfTable.getSchema();
                String schemaName = schema == null || schema.getNameInSource() == null ? null : this.unQualifyName(schema.getNameInSource());
                String tblName = emfTable.getNameInSource();
                TableStatistics tableInfo = new TableStatistics(catalogName, schemaName, tblName);
                Map columnInfos = tableInfo.getColumnStats();
                for (Column emfColumn : emfTable.getColumns()) {
                    if (emfColumn.getNameInSource() == null) continue;
                    String colName = this.unQualifyName(emfColumn.getNameInSource());
                    ColumnStatistics columnInfo = new ColumnStatistics(colName);
                    columnInfos.put(colName, columnInfo);
                }
                tableInfos.put(this.unQualifyName(tblName), tableInfo);
            }
            return tableInfos;
        }
        return null;
    }

    public void populateEmfColumnStatistics(List emfTables, Map tableInfos) {
        for (Table emfTable : emfTables) {
            TableStatistics tableInfo;
            if (emfTable.getNameInSource() == null || (tableInfo = (TableStatistics)tableInfos.get(this.unQualifyName(emfTable.getNameInSource()))) == null) continue;
            emfTable.setCardinality(tableInfo.getCardinality());
            Map columnInfos = tableInfo.getColumnStats();
            for (Column emfColumn : emfTable.getColumns()) {
                ColumnStatistics columnInfo;
                if (emfColumn.getNameInSource() == null || (columnInfo = (ColumnStatistics)columnInfos.get(this.unQualifyName(emfColumn.getNameInSource()))) == null) continue;
                emfColumn.setMinimumValue(columnInfo.getMin());
                emfColumn.setMaximumValue(columnInfo.getMax());
                emfColumn.setNullValueCount(columnInfo.getNumNullValues());
                emfColumn.setDistinctValueCount(columnInfo.getNumDistinctValues());
            }
        }
    }

    private String unQualifyName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1, qualifiedName.length());
    }

    private static class DBMS {
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SQL_SERVER = "sqlserver";

        private DBMS() {
        }
    }
}

