/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.jdbc.relational.JdbcNodeToRelationalMapping;
import org.teiid.designer.jdbc.relational.JdbcNodeToRelationalMappingImpl;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;

public class JdbcRelationalPlugin
extends Plugin
implements ModelerJdbcRelationalConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcRelationalPlugin.class);
    public static boolean DEBUG = false;
    public static boolean CREATE_MODEL_IN_TRANSACTION = true;
    private static final JdbcNodeToRelationalMapping JDBC_TO_RELATIONAL_MAPPING = new JdbcNodeToRelationalMappingImpl();
    private static final String MODEL_CONTAINER_NAME = JdbcRelationalPlugin.getString("modelContainerName");
    private static JdbcRelationalPlugin plugin;
    private static Container modelCtnr;

    public static JdbcRelationalPlugin getDefault() {
        return plugin;
    }

    public static Container getModelContainer() throws CoreException {
        if (modelCtnr == null) {
            modelCtnr = ModelerCore.createContainer((String)MODEL_CONTAINER_NAME);
        }
        return modelCtnr;
    }

    private static String getString(String id) {
        return ModelerJdbcRelationalConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public static JdbcNodeToRelationalMapping getJdbcNodeToRelationalMapping() {
        return JDBC_TO_RELATIONAL_MAPPING;
    }

    public JdbcRelationalPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)ModelerJdbcRelationalConstants.Util).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        if (modelCtnr != null) {
            modelCtnr.shutdown();
        }
        super.stop(context);
    }
}

