/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.teiid.designer.jdbc.JdbcManager;
import org.teiid.designer.jdbc.JdbcManagerImpl;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.CostAnalyzer;
import org.teiid.designer.jdbc.relational.JdbcRelationalPlugin;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.jdbc.relational.impl.ColumnStatistics;
import org.teiid.designer.jdbc.relational.impl.TableStatistics;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;

public class DefaultCostAnalyzerImpl
implements CostAnalyzer {
    protected JdbcSource src;
    protected String password;
    protected PrintStream outputStream;
    protected Connection connection;

    public DefaultCostAnalyzerImpl(JdbcSource jdbcSource, String password) {
        this.src = jdbcSource;
        this.password = password;
    }

    @Override
    public void collectStatistics(Map tblStats, IProgressMonitor monitor) throws Exception {
        this.log("\nLoading table statistics...");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        long begin = System.currentTimeMillis();
        this.connect();
        try {
            Iterator it = tblStats.values().iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    break;
                }
                TableStatistics tblStat = (TableStatistics)it.next();
                try {
                    if (this.populateTableStatistics(tblStat, monitor)) {
                        this.prepareColumnStatistics(tblStat, monitor);
                        this.populateColumnStatistics(tblStat, monitor);
                        continue;
                    }
                    monitor.worked(tblStat.getColumnStats().size() + 1);
                }
                catch (Exception exception) {
                    this.log("WARNING: Failed to retrieve statistics for table/view " + tblStat.getName());
                }
            }
        }
        finally {
            this.disconnect();
        }
        this.log("Done loading tables, total time = " + (System.currentTimeMillis() - begin) + " ms");
    }

    protected boolean computeColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        String sql;
        ResultSet rs;
        Statement stmt;
        long begin = System.currentTimeMillis();
        String tblName = tblStat.getFullyQualifiedEscapedName();
        String colName = JdbcRelationalUtil.escapeDatabaseObjectName(colStat.getName());
        boolean isNDVCalcuationRequired = colStat.isNDVCalculationRequired();
        boolean isMinMaxCalculationRequired = colStat.isMinMaxCalculationRequired();
        boolean isNNVCalculationRequired = colStat.isNNVCalculationRequired();
        if (isNDVCalcuationRequired || isMinMaxCalculationRequired) {
            stmt = null;
            rs = null;
            try {
                stmt = this.connection.createStatement();
                sql = "select ";
                boolean isUniqueIdentifier = "uniqueidentifier".equalsIgnoreCase(colStat.getNativeType());
                if (isNDVCalcuationRequired) {
                    sql = isUniqueIdentifier ? String.valueOf(sql) + "count(*)" : String.valueOf(sql) + "count(distinct " + colName + ")";
                    if (isMinMaxCalculationRequired) {
                        sql = String.valueOf(sql) + ", ";
                    }
                }
                if (isMinMaxCalculationRequired) {
                    sql = String.valueOf(sql) + "min(" + colName + "), max(" + colName + ")";
                }
                sql = String.valueOf(sql) + " from " + tblName;
                if (isUniqueIdentifier && isNNVCalculationRequired) {
                    sql = String.valueOf(sql) + " where " + colName + " is not null";
                }
                if ((rs = stmt.executeQuery(sql)).next()) {
                    int minOffset = 1;
                    if (isNDVCalcuationRequired) {
                        colStat.setNumDistinctValues(rs.getInt(1));
                        minOffset = 2;
                    }
                    if (isMinMaxCalculationRequired) {
                        colStat.setMin(rs.getString(minOffset));
                        colStat.setMax(rs.getString(++minOffset));
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        if (isNNVCalculationRequired) {
            stmt = null;
            rs = null;
            try {
                stmt = this.connection.createStatement();
                sql = "select count(*) from " + tblName + " where " + colName + " is null";
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    colStat.setNumNullValues(rs.getInt(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        this.log("\t\t" + tblName + "." + colName + ": NDV=" + colStat.getNumDistinctValues() + ", NNV=" + colStat.getNumNullValues() + ", min=" + colStat.getMin() + ", max=" + colStat.getMax() + "    (in " + (System.currentTimeMillis() - begin) + " ms)");
        return true;
    }

    protected void connect() throws Exception {
        if (this.connection == null) {
            JdbcManager mgr = JdbcRelationalPlugin.getDefault() == null ? JdbcManagerImpl.create((String)ModelerJdbcRelationalConstants.Util.getString("JdbcManager.name", new Object[0])) : JdbcRelationalUtil.getJdbcManager();
            this.connection = mgr.createConnection(this.src, this.password);
        }
    }

    protected void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
            this.connection = null;
        }
    }

    protected void log(String message) {
        if (this.outputStream != null) {
            this.outputStream.println(message);
        }
    }

    protected boolean populateColumnStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        Iterator it = tblStat.getColumnStats().values().iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            ColumnStatistics colStat = (ColumnStatistics)it.next();
            monitor.subTask(ModelerJdbcRelationalConstants.Util.getString("DefaultCostAnalyzer.Progress.Calculating_column_statistics", new Object[]{colStat.getName(), tblStat.getName()}));
            try {
                if (this.computeColumnStatistics(tblStat, colStat)) continue;
                return false;
            }
            catch (Exception exception) {
                this.log("WARNING: Failed to retrieve statistics for column " + colStat.getName() + " in table/view " + tblStat.getName());
            }
            finally {
                monitor.worked(1);
            }
        }
        return true;
    }

    protected boolean populateTableStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(ModelerJdbcRelationalConstants.Util.getString("DefaultCostAnalyzer.Progress.Calculating_table_statistics", (Object)tblStat.getName()));
        long begin = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String tblName = tblStat.getFullyQualifiedEscapedName();
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery("select count(*) from " + tblName);
            if (rs.next()) {
                tblStat.setCardinality(rs.getInt(1));
                this.log("\t" + tblName + ": " + tblStat.getCardinality() + " rows    (in " + (System.currentTimeMillis() - begin) + " ms)");
                return true;
            }
        }
        finally {
            monitor.worked(1);
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return false;
    }

    protected void prepareColumnStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return;
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData md = this.connection.getMetaData();
            Map colStats = tblStat.getColumnStats();
            rs = md.getColumns(tblStat.getCatalog(), tblStat.getSchema(), tblStat.getName(), "%");
            while (rs.next()) {
                String colName = JdbcRelationalUtil.escapeDatabaseObjectName(rs.getString(4));
                ColumnStatistics colStat = (ColumnStatistics)colStats.get(colName);
                if (colStat == null) continue;
                colStat.setJdbcType(rs.getInt(5));
                colStat.setNativeType(rs.getString(6));
                colStat.setNullable(rs.getInt(11) != 0);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            monitor.worked(1);
        }
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }
}

