/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.relational.JdbcRelationalPlugin;
import org.teiid.designer.jdbc.relational.impl.MatchValueProvider;
import org.teiid.designer.metamodels.relational.RelationalEntity;

public class ObjectMatcher {
    static MatchValueProvider DEFAULT_MATCH_VALUE_PROVIDER = new MatchValueProvider(){

        @Override
        public String getMatchValue(Object obj) {
            CoreArgCheck.isNotNull((Object)obj);
            return obj.toString();
        }
    };
    static MatchValueProvider JDBC_NODE_VALUE_PROVIDER = new MatchValueProvider(){

        @Override
        public String getMatchValue(Object obj) {
            CoreArgCheck.isNotNull((Object)obj);
            return ((JdbcNode)obj).getName();
        }
    };
    static MatchValueProvider RELATION_OBJECT_NAME_PROVIDER = new MatchValueProvider(){

        @Override
        public String getMatchValue(Object obj) {
            CoreArgCheck.isNotNull((Object)obj);
            return ((RelationalEntity)obj).getName();
        }
    };
    private final Map destination;
    private final LinkedList unmatchedModelObjects;
    private final LinkedList unmatchedNodes;
    private MatchValueProvider modelObjectNameProvider;
    private MatchValueProvider jdbcNodeNameProvider;

    public ObjectMatcher(Map destination) {
        this.destination = destination != null ? destination : new HashMap();
        this.unmatchedModelObjects = new LinkedList();
        this.unmatchedNodes = new LinkedList();
        this.modelObjectNameProvider = RELATION_OBJECT_NAME_PROVIDER;
        this.jdbcNodeNameProvider = JDBC_NODE_VALUE_PROVIDER;
    }

    public void findBestMatches(List jdbcNodes, List modelObjects) {
        if (jdbcNodes.isEmpty()) {
            this.unmatchedModelObjects.addAll(modelObjects);
            return;
        }
        if (modelObjects.isEmpty()) {
            this.unmatchedNodes.addAll(jdbcNodes);
            return;
        }
        LinkedList tempUnmatchedNodes = new LinkedList();
        LinkedList tempUnmatchedObjs = new LinkedList();
        this.process(true, jdbcNodes, modelObjects, tempUnmatchedNodes, tempUnmatchedObjs);
        this.process(false, tempUnmatchedNodes, tempUnmatchedObjs, this.unmatchedNodes, this.unmatchedModelObjects);
    }

    protected boolean isMatchingType(Object node, Object modelObject) {
        if (node instanceof JdbcNode && modelObject instanceof RelationalEntity) {
            EClass nodeEClass;
            JdbcNode theNode = (JdbcNode)node;
            RelationalEntity entity = (RelationalEntity)modelObject;
            EClass entityEClass = entity.eClass();
            if (entityEClass.equals(nodeEClass = JdbcRelationalPlugin.getJdbcNodeToRelationalMapping().getRelationalClassForJdbcNode(theNode))) {
                return true;
            }
        }
        return true;
    }

    protected void process(boolean caseSensitive, List nodes, List objs, List unmatchedNodes, List unmatchedObjs) {
        HashMap<String, Object> objByName = new HashMap<String, Object>();
        for (Object obj : objs) {
            String name;
            Object existing;
            if (obj == null || (existing = objByName.put(name = caseSensitive ? this.modelObjectNameProvider.getMatchValue(obj) : this.modelObjectNameProvider.getMatchValue(obj).toUpperCase(), obj)) == null) continue;
            if (existing instanceof List) {
                ((List)existing).add(obj);
                objByName.put(name, existing);
                continue;
            }
            LinkedList listOfExisting = new LinkedList();
            listOfExisting.add(obj);
            objByName.put(name, listOfExisting);
        }
        for (Object node : nodes) {
            String name = caseSensitive ? this.jdbcNodeNameProvider.getMatchValue(node) : this.jdbcNodeNameProvider.getMatchValue(node).toUpperCase();
            Object objWithExactMatch = objByName.get(name);
            if (objWithExactMatch == null) {
                unmatchedNodes.add(node);
                continue;
            }
            if (objWithExactMatch instanceof LinkedList) {
                LinkedList multipleMatches = (LinkedList)objWithExactMatch;
                objWithExactMatch = null;
                Iterator iterator = multipleMatches.iterator();
                while (iterator.hasNext()) {
                    Object matchingObj = iterator.next();
                    if (!this.isMatchingType(node, matchingObj)) continue;
                    iterator.remove();
                    objWithExactMatch = matchingObj;
                    break;
                }
                if (multipleMatches.isEmpty()) {
                    objByName.remove(name);
                }
            } else if (this.isMatchingType(node, objWithExactMatch)) {
                objByName.remove(name);
            } else {
                objWithExactMatch = null;
            }
            if (objWithExactMatch == null) continue;
            this.destination.put(node, objWithExactMatch);
        }
        for (Map.Entry entry : objByName.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                unmatchedObjs.addAll((List)value);
                continue;
            }
            unmatchedObjs.add(value);
        }
    }

    public MatchValueProvider getJdbcNodeNameProvider() {
        return this.jdbcNodeNameProvider;
    }

    public MatchValueProvider getModelObjectNameProvider() {
        return this.modelObjectNameProvider;
    }

    public void setJdbcNodeNameProvider(MatchValueProvider provider) {
        this.jdbcNodeNameProvider = provider;
    }

    public void setModelObjectNameProvider(MatchValueProvider provider) {
        this.modelObjectNameProvider = provider;
    }

    public Map getDestination() {
        return this.destination;
    }

    public LinkedList getUnmatchedModelObjects() {
        return this.unmatchedModelObjects;
    }

    public LinkedList getUnmatchedJdbcNodes() {
        return this.unmatchedNodes;
    }
}

