/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.impl.ColumnStatistics;
import org.teiid.designer.jdbc.relational.impl.DefaultCostAnalyzerImpl;
import org.teiid.designer.jdbc.relational.impl.TableStatistics;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;

public class OracleCostAnalyzerImpl
extends DefaultCostAnalyzerImpl {
    private static final String NUMBER = "number";
    private static String ORACLE_8 = "8.";
    private static final Map<Integer, String> type_to_raw_mapping = new HashMap<Integer, String>();
    private static final Map<String, String> native_to_raw_mapping = new TreeMap<String, String>();

    static {
        type_to_raw_mapping.put(-5, NUMBER);
        type_to_raw_mapping.put(4, NUMBER);
        type_to_raw_mapping.put(5, NUMBER);
        type_to_raw_mapping.put(16, NUMBER);
        type_to_raw_mapping.put(2, NUMBER);
        type_to_raw_mapping.put(3, NUMBER);
        type_to_raw_mapping.put(7, NUMBER);
        type_to_raw_mapping.put(8, NUMBER);
        type_to_raw_mapping.put(6, NUMBER);
        type_to_raw_mapping.put(4, NUMBER);
        type_to_raw_mapping.put(12, "varchar2");
        type_to_raw_mapping.put(-9, "nvarchar2");
        native_to_raw_mapping.put("binary_float", "binary_float");
        native_to_raw_mapping.put("binary_integer", "binary_integer");
    }

    public OracleCostAnalyzerImpl(JdbcSource src, String password) {
        super(src, password);
    }

    @Override
    protected boolean populateTableStatistics(TableStatistics tblStat, IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return false;
        }
        if (!this.populateOracleTableStatistics(tblStat)) {
            return super.populateTableStatistics(tblStat, monitor);
        }
        monitor.worked(1);
        return true;
    }

    private boolean populateOracleTableStatistics(TableStatistics tblStat) throws Exception {
        long begin = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String tblName = tblStat.getName();
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery("select num_rows from ALL_TABLES where owner = '" + tblStat.getSchema() + "' AND table_name = '" + tblName + "'");
            if (rs.next()) {
                tblStat.setCardinality(rs.getInt(1));
                this.log("\t" + tblName + ": " + tblStat.getCardinality() + " rows    (collected from Oracle stats in " + (System.currentTimeMillis() - begin) + " ms)");
                return true;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return false;
    }

    @Override
    protected boolean computeColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        if (!this.computeOracleColumnStatistics(tblStat, colStat)) {
            return super.computeColumnStatistics(tblStat, colStat);
        }
        return true;
    }

    private boolean computeOracleColumnStatistics(TableStatistics tblStat, ColumnStatistics colStat) throws Exception {
        long begin = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        boolean success = false;
        try {
            DatabaseMetaData metadata = this.connection.getMetaData();
            String sql = "select num_distinct, num_nulls";
            boolean unknownType = false;
            if (colStat.isMinMaxCalculationRequired()) {
                int jdbcType = colStat.jdbcType;
                String type = native_to_raw_mapping.get(colStat.nativeType);
                if (type == null) {
                    type = type_to_raw_mapping.get(jdbcType);
                }
                if (type != null) {
                    sql = String.valueOf(sql) + ", utl_raw.cast_to_" + type + "(low_value), utl_raw.cast_to_" + type + "(high_value)";
                } else {
                    sql = String.valueOf(sql) + ", low_value, high_value";
                    unknownType = true;
                }
            }
            sql = String.valueOf(sql) + " from ALL_TAB_COL_STATISTICS";
            sql = metadata.getDatabaseProductVersion().startsWith(ORACLE_8) ? String.valueOf(sql) + " where TABLE_NAME = '" + tblStat.getName() + "' and COLUMN_NAME = '" + colStat.getName() + "'" : String.valueOf(sql) + " where owner='" + tblStat.getSchema() + "' and TABLE_NAME = '" + tblStat.getName() + "' and COLUMN_NAME = '" + colStat.getName() + "'";
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                colStat.setNumDistinctValues(rs.getInt(1));
                colStat.setNumNullValues(rs.getInt(2));
                if (colStat.isMinMaxCalculationRequired()) {
                    if (unknownType) {
                        int conversionType = colStat.jdbcType;
                        if (conversionType == 92 || conversionType == 93) {
                            conversionType = 91;
                        }
                        byte[] bytes = rs.getBytes(3);
                        String val = this.getRawAsString(colStat, bytes, conversionType);
                        colStat.setMin(val);
                        bytes = rs.getBytes(4);
                        val = this.getRawAsString(colStat, bytes, conversionType);
                        colStat.setMax(val);
                    } else {
                        colStat.setMin(rs.getString(3));
                        colStat.setMax(rs.getString(4));
                    }
                }
                String tblName = tblStat.getFullyQualifiedEscapedName();
                String colName = JdbcRelationalUtil.escapeDatabaseObjectName(colStat.getName());
                success = true;
                this.log("\t\t" + tblName + "." + colName + ": NDV=" + colStat.getNumDistinctValues() + ": NNV=" + colStat.getNumNullValues() + ", min=" + colStat.getMin() + ", max=" + colStat.getMax() + "    (collected from stats in " + (System.currentTimeMillis() - begin) + " ms)");
                boolean bl = success;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private String getRawAsString(ColumnStatistics colStat, byte[] bytes, int type) {
        String string;
        CallableStatement cs;
        block11: {
            String val;
            cs = null;
            cs = this.connection.prepareCall("{call dbms_stats.convert_raw_value(?, ?)}");
            cs.registerOutParameter(2, type);
            cs.setBytes(1, bytes);
            cs.execute();
            string = val = cs.getString(2);
            if (cs == null) break block11;
            try {
                cs.close();
            }
            catch (SQLException sQLException) {}
        }
        return string;
        catch (SQLException sQLException) {
            block12: {
                try {
                    if (cs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (cs != null) {
                        try {
                            cs.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    throw throwable;
                }
                try {
                    cs.close();
                }
                catch (SQLException sQLException3) {}
            }
            return null;
        }
    }
}

