/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl.custom;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.data.Results;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.metadata.impl.GetAccessForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetIndexesRequest;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class ExcelModelProcessor
extends RelationalModelProcessorImpl {
    public ExcelModelProcessor() {
    }

    public ExcelModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public ExcelModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    @Override
    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced, List problems) {
        if (object instanceof Table && node instanceof JdbcTable && "Excel_Sheet".equals(((JdbcTable)node).getRemarks())) {
            return "[" + node.getName() + "$]";
        }
        return super.computeNameInSource(object, name, node, context, forced, problems);
    }

    @Override
    protected void createPrimaryKey(JdbcTable tableNode, Table table, Context context, List problems) {
        if (!(table instanceof BaseTable)) {
            return;
        }
        boolean includeUniqueIndexes = context.getJdbcImportSettings().isIncludeUniqueIndexes();
        boolean includeForeignKeys = context.getJdbcImportSettings().isIncludeForeignKeys();
        if (!includeUniqueIndexes && !includeForeignKeys) {
            return;
        }
        try {
            Column column;
            Request request = tableNode.getRequest(GetIndexesRequest.NAME, false);
            Results results = request.getResults();
            Object[] rows = results.getRows();
            int numRows = results.getRowCount();
            if (numRows == 0) {
                return;
            }
            Map columnsByName = this.createColumnMapKeyedByNames(table, tableNode, context, problems);
            boolean hasPrimaryKey = false;
            String pkName = null;
            Column[] columns = new Column[numRows];
            int i = 0;
            while (i < numRows) {
                Object row = rows[i];
                pkName = results.getString(row, 5);
                if (pkName != null && pkName.equalsIgnoreCase("PrimaryKey")) {
                    String columnName = results.getString(row, 8);
                    column = (Column)columnsByName.get(columnName = tableNode.getUnqualifiedName(columnName));
                    if (column != null) {
                        short seqIndex = results.getShort(row, 7);
                        columns[seqIndex - 1] = column;
                    }
                    hasPrimaryKey = true;
                }
                ++i;
            }
            if (!hasPrimaryKey) {
                return;
            }
            PrimaryKey primaryKey = super.getFactory().createPrimaryKey();
            primaryKey.setTable((BaseTable)table);
            if (pkName != null) {
                this.setNameAndNameInSource((RelationalEntity)primaryKey, pkName, (JdbcNode)tableNode, context, problems);
            }
            EList keyColumns = primaryKey.getColumns();
            int i2 = 0;
            while (i2 < columns.length) {
                column = columns[i2];
                if (column != null) {
                    keyColumns.add(column);
                }
                ++i2;
            }
        }
        catch (JdbcException e) {
            String msg = String.valueOf(ModelerJdbcRelationalConstants.Util.getString("RelationalModelProcessorImpl.Error_while_obtaining_primary_key_info", new Object[0])) + e.getLocalizedMessage();
            Status status = new Status(4, "org.teiid.designer.jdbc.relational", 0, msg, (Throwable)e);
            problems.add(status);
        }
    }

    @Override
    protected Request getForeignKeyRequest(JdbcTable tableNode, String name, boolean includeMetadata) throws JdbcException {
        return tableNode.getRequest(GetAccessForeignKeysRequest.NAME, false);
    }

    @Override
    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }

    @Override
    protected void modifyIndexName(RelationalModelProcessorImpl.IndexSpec indexSpec) {
        if (indexSpec.indexName != null && indexSpec.indexName.equalsIgnoreCase("PrimaryKey")) {
            String indexName = null;
            for (Column column : indexSpec.columns) {
                indexName = indexName == null ? column.getName() : String.valueOf(indexName) + column.getName();
            }
            indexSpec.indexName = indexName;
        }
    }

    @Override
    public String getType() {
        return "excel";
    }
}

