/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl.custom;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class OracleModelProcessor
extends RelationalModelProcessorImpl {
    private static final String BLOB_TYPE_NAME = "BLOB";
    private static final String CLOB_TYPE_NAME = "CLOB";
    private static final String VARCHAR2_TYPE_NAME = "VARCHAR2";
    private static final String NVARCHAR2_TYPE_NAME = "NVARCHAR2";
    private static final String TIMESTAMP_TYPE_NAME = "TIMESTAMP(";
    private static final String REF_CURSOR = "REF CURSOR";

    public OracleModelProcessor() {
    }

    public OracleModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public OracleModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    @Override
    protected boolean isProcedureResultColumn(short columnType, short type, String typeName) {
        return REF_CURSOR.equals(typeName) || super.isProcedureResultColumn(columnType, type, typeName);
    }

    @Override
    protected boolean includeColumnInProcedureResult(short columnType, short type, String typeName) {
        return false;
    }

    @Override
    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (typeName.startsWith(TIMESTAMP_TYPE_NAME)) {
            result = this.findBuiltinType("timestamp", problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    @Override
    protected EObject findType(String jdbcTypeName, List problems) {
        String standardName = jdbcTypeName;
        if (VARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName) || NVARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "VARCHAR";
        }
        return super.findType(standardName, problems);
    }

    @Override
    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        super.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
        if (type == 2004 || type == 2005 || BLOB_TYPE_NAME.equals(typeName) || CLOB_TYPE_NAME.equals(typeName)) {
            column.setLength(0);
        }
    }

    protected int getMaxSetSizeForModel() {
        return 1000;
    }

    @Override
    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        super.updateModelAnnotation(modelAnnotation);
        modelAnnotation.setMaxSetSize(1000);
    }

    @Override
    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }

    @Override
    protected boolean isFixedLength(int type, String typeName) {
        if (NVARCHAR2_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return false;
        }
        return super.isFixedLength(type, typeName);
    }

    @Override
    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced, List problems) {
        String nis = super.computeNameInSource(object, name, node, context, forced, problems);
        if (nis != null) {
            nis = nis.replace('@', '.');
        }
        return nis;
    }

    @Override
    public String getType() {
        return "oracle";
    }
}

