/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl.custom;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class PostgresModelProcessor
extends RelationalModelProcessorImpl {
    private static final String BOOLEAN_TYPE_NAME = "BOOL";
    private static final String TEXT_TYPE_NAME = "TEXT";
    private static final String IMAGE_TYPE_NAME = "IMAGE";
    private static final String CHAR_VARYING_TYPE_NAME = "CHARACTER VARYING";
    private static final String VARCHAR_TYPE_NAME = "VARCHAR";
    private static final String SERIAL_TYPE_NAME = "SERIAL";
    private static final String SERIAL4_TYPE_NAME = "SERIAL4";
    private static final String SERIAL8_TYPE_NAME = "SERIAL8";
    private static final String BIGSERIAL_TYPE_NAME = "BIGSERIAL";
    private static final int TEXT_TYPE_MAX_LENGTH = 4000;

    public PostgresModelProcessor() {
    }

    public PostgresModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public PostgresModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    @Override
    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (BOOLEAN_TYPE_NAME.equalsIgnoreCase(typeName)) {
            result = this.findBuiltinType("boolean", problems);
        } else if (typeName.startsWith(TEXT_TYPE_NAME)) {
            result = this.findBuiltinType("clob", problems);
        } else if (typeName.startsWith(IMAGE_TYPE_NAME)) {
            result = this.findBuiltinType("blob", problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    @Override
    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        super.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
        if ((CHAR_VARYING_TYPE_NAME.equalsIgnoreCase(typeName) || VARCHAR_TYPE_NAME.equalsIgnoreCase(typeName)) && columnSize > 4000) {
            column.setLength(4000);
        }
        if (column.getPrecision() > 1000) {
            column.setPrecision(1000);
        }
        if (defaultValue != null && (SERIAL_TYPE_NAME.equalsIgnoreCase(typeName) || SERIAL4_TYPE_NAME.equalsIgnoreCase(typeName) || SERIAL8_TYPE_NAME.equalsIgnoreCase(typeName) || BIGSERIAL_TYPE_NAME.equalsIgnoreCase(typeName))) {
            column.setDefaultValue(null);
        }
    }

    @Override
    public String getType() {
        return "postgres";
    }
}

