/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.ui.BreakpointTypeCategory;
import org.eclipse.debug.ui.IBreakpointTypeCategory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableColumnPresentationFactory;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.debug.DelegatingJavaBreakpoint;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpoint;
import org.switchyard.tools.ui.debug.TransformSequenceBreakpoint;
import org.switchyard.tools.ui.debug.ValidateHandlerBreakpoint;
import org.switchyard.tools.ui.debug.structure.SwitchYardModelProxyFactory;

public class SwitchYardDebugAdapterFactory
implements IAdapterFactory {
    private static final Class[] TYPES = new Class[]{IBreakpointTypeCategory.class, IWorkbenchAdapter.class, IModelProxyFactory.class, ServiceInteractionBreakpoint.class, TransformSequenceBreakpoint.class, ValidateHandlerBreakpoint.class, IElementLabelProvider.class};
    private static final IElementLabelProvider LABEL_PROVIDER = new JavaVariableLabelProvider(){

        protected ISchedulingRule getRule(ILabelUpdate update) {
            return null;
        }
    };

    public Class[] getAdapterList() {
        return TYPES;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IBreakpointTypeCategory.class) {
            return this.adaptBreakpointCategory(adaptableObject);
        }
        if (adapterType == IWorkbenchAdapter.class) {
            return this.adaptWorkbenchAdapter(adaptableObject);
        }
        if (adapterType == IModelProxyFactory.class) {
            return new SwitchYardModelProxyFactory();
        }
        if (adapterType == IColumnPresentationFactory.class) {
            return new JavaVariableColumnPresentationFactory();
        }
        if (adapterType == ServiceInteractionBreakpoint.class) {
            return this.adaptServiceInteractionBreakpoint(adaptableObject);
        }
        if (adapterType == TransformSequenceBreakpoint.class) {
            return this.adaptTransformSequenceBreakpoint(adaptableObject);
        }
        if (adapterType == ValidateHandlerBreakpoint.class) {
            return this.adaptValidateHandlerBreakpoint(adaptableObject);
        }
        if (adapterType == IElementLabelProvider.class) {
            return LABEL_PROVIDER;
        }
        return null;
    }

    private Object adaptServiceInteractionBreakpoint(Object adaptableObject) {
        if (adaptableObject instanceof Contract) {
            IBreakpoint[] breakpoints;
            Contract contract = (Contract)adaptableObject;
            IProject project = this.getProject((EObject)contract);
            if (project == null) {
                return null;
            }
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.switchyard.tools.ui.debug");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                String markerType = null;
                try {
                    markerType = marker.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (marker != null && project.equals((Object)marker.getResource()) && "org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker".equals(markerType) && this.breakpointMatchesSelection((ServiceInteractionBreakpoint)breakpoint, contract)) {
                    return breakpoint;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object adaptTransformSequenceBreakpoint(Object adaptableObject) {
        if (adaptableObject instanceof Composite) {
            IBreakpoint[] breakpoints;
            IProject project = this.getProject((EObject)((Composite)adaptableObject));
            if (project == null) {
                return null;
            }
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.switchyard.tools.ui.debug");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                String markerType = null;
                try {
                    markerType = marker.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (marker != null && project.equals((Object)marker.getResource()) && "org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(markerType)) {
                    return breakpoint;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object adaptValidateHandlerBreakpoint(Object adaptableObject) {
        if (adaptableObject instanceof Composite) {
            IBreakpoint[] breakpoints;
            IProject project = this.getProject((EObject)((Composite)adaptableObject));
            if (project == null) {
                return null;
            }
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.switchyard.tools.ui.debug");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                String markerType = null;
                try {
                    markerType = marker.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (marker != null && project.equals((Object)marker.getResource()) && "org.switchyard.tools.ui.debug.switchYardValidatorBreakpointMarker".equals(markerType)) {
                    return breakpoint;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object adaptBreakpointCategory(Object adaptableObject) {
        if (adaptableObject instanceof DelegatingJavaBreakpoint) {
            return new BreakpointTypeCategory("SwitchYard Breakpoints", Activator.getDefault().getImageRegistry().getDescriptor("icons/switchyard_icon_16px.png"));
        }
        return null;
    }

    private Object adaptWorkbenchAdapter(Object adaptableObject) {
        if (adaptableObject instanceof DelegatingJavaBreakpoint) {
            final DelegatingJavaBreakpoint breakpoint = (DelegatingJavaBreakpoint)adaptableObject;
            return new IWorkbenchAdapter(){

                public Object getParent(Object o) {
                    return null;
                }

                public String getLabel(Object o) {
                    return DebugUIPlugin.getModelPresentation().getText((Object)breakpoint);
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public Object[] getChildren(Object o) {
                    return null;
                }
            };
        }
        return null;
    }

    private boolean breakpointMatchesSelection(ServiceInteractionBreakpoint breakpoint, Contract contract) {
        IInteractionConfiguration config = breakpoint.getInteractionConfiguration();
        if (config == null) {
            return false;
        }
        QName name = this.getServiceName(contract);
        if (contract instanceof Service || contract instanceof ComponentReference) {
            return config.getProviderName() == null && name.equals(config.getConsumerName());
        }
        return config.getConsumerName() == null && name.equals(config.getProviderName());
    }

    private QName getServiceName(Contract contract) {
        if (contract.getName() == null) {
            return null;
        }
        String targetNamespace = null;
        EObject container = contract.eContainer();
        while (container != null && targetNamespace == null) {
            if (container instanceof Composite) {
                targetNamespace = ((Composite)container).getTargetNamespace();
            } else if (container instanceof SwitchYardType) {
                targetNamespace = ((SwitchYardType)container).getTargetNamespace();
            }
            container = container.eContainer();
        }
        if (contract instanceof Service) {
            return new QName(targetNamespace, contract.getName());
        }
        if (contract instanceof ComponentReference) {
            String componentName = ((Component)contract.eContainer()).getName();
            return new QName(targetNamespace, componentName == null ? contract.getName() : String.valueOf(componentName) + "/" + contract.getName());
        }
        return new QName(targetNamespace, contract.getName());
    }

    private IProject getProject(EObject object) {
        Resource objectResource = object.eResource();
        if (objectResource == null) {
            return null;
        }
        if (objectResource.getResourceSet() == null) {
            IResource iresource;
            if (objectResource.getURI().isPlatformResource() && (iresource = ResourcesPlugin.getWorkspace().getRoot().findMember(objectResource.getURI().toPlatformString(true))) != null) {
                return iresource.getProject();
            }
            return null;
        }
        for (Resource resource : objectResource.getResourceSet().getResources()) {
            IResource iresource;
            if (!resource.getURI().isPlatformResource() || (iresource = ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getURI().toPlatformString(true))) == null) continue;
            return iresource.getProject();
        }
        return null;
    }
}

