/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AbstractJavaBreakpointEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ITransformConfiguration;
import org.switchyard.tools.ui.debug.InteractionConfigurationBuilder;
import org.switchyard.tools.ui.debug.TransformConfigurationBuilder;
import org.switchyard.tools.ui.debug.TransformSequenceBreakpoint;

public class TransformBreakpointEditor
extends AbstractJavaBreakpointEditor {
    public static final int TRIGGER_PROP = 1;
    public static final int TRANSFORMS_PROP = 2;
    private TransformSequenceBreakpoint _breakpoint;
    private Button _inButton;
    private Button _outButton;
    private Button _faultButton;
    private CheckboxTableViewer _typesTable;
    private Set<IInteractionConfiguration.TriggerType> _triggers;
    private boolean _updating;

    public Control createControl(Composite parent) {
        ScrolledComposite scrollable = new ScrolledComposite(parent, 768);
        scrollable.setLayout((Layout)new GridLayout());
        scrollable.setLayoutData((Object)new GridData(1808));
        Composite content = new Composite((Composite)scrollable, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(1808));
        content.setBackground(parent.getBackground());
        content.setBackgroundMode(1);
        Group phaseGroup = new Group(content, 0);
        phaseGroup.setLayout((Layout)new GridLayout(3, false));
        phaseGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        phaseGroup.setText("Triggering phase");
        this._inButton = new Button((Composite)phaseGroup, 32);
        this._inButton.setText("IN");
        this._inButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.IN));
        this._outButton = new Button((Composite)phaseGroup, 32);
        this._outButton.setText("OUT");
        this._outButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.OUT));
        this._faultButton = new Button((Composite)phaseGroup, 32);
        this._faultButton.setText("FAULT");
        this._faultButton.addSelectionListener((SelectionListener)new TriggerSelectionListener(IInteractionConfiguration.TriggerType.FAULT));
        this._typesTable = CheckboxTableViewer.newCheckList((Composite)content, (int)2816);
        this._typesTable.getTable().setHeaderVisible(true);
        TableViewerColumn fromColumn = new TableViewerColumn((TableViewer)this._typesTable, 16384);
        fromColumn.getColumn().setText("From");
        fromColumn.getColumn().setResizable(true);
        fromColumn.getColumn().setWidth(200);
        TableViewerColumn toColumn = new TableViewerColumn((TableViewer)this._typesTable, 16384);
        toColumn.getColumn().setText("To");
        toColumn.getColumn().setResizable(true);
        toColumn.getColumn().setWidth(200);
        GridData gd = new GridData(1808);
        gd.minimumHeight = this._typesTable.getTable().getHeaderHeight() + 5 * this._typesTable.getTable().getItemHeight();
        this._typesTable.getControl().setLayoutData((Object)gd);
        this._typesTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof TransformType) {
                    if (columnIndex == 0) {
                        return this.getText(((TransformType)element).getFrom());
                    }
                    return this.getText(((TransformType)element).getTo());
                }
                return "";
            }

            private String getText(String typeName) {
                if (typeName == null || typeName.length() == 0) {
                    return "";
                }
                QName type = QName.valueOf(typeName);
                String localPart = type.getLocalPart();
                String namespaceUri = type.getNamespaceURI();
                if (namespaceUri == null || "".equals(namespaceUri)) {
                    if (localPart.startsWith("java:")) {
                        int lastDot = localPart.lastIndexOf(46);
                        if (lastDot > 0) {
                            return String.valueOf(localPart.substring(lastDot + 1)) + " {" + localPart.substring(5, lastDot) + "}";
                        }
                        return localPart.substring(5);
                    }
                    return localPart;
                }
                return String.valueOf(localPart) + " {" + namespaceUri + "}";
            }
        });
        this._typesTable.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof TransformType && ((TransformType)element).getFrom() != null && ((TransformType)element).getFrom().length() > 0 && ((TransformType)element).getTo() != null && ((TransformType)element).getTo().length() > 0;
            }
        });
        this._typesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._typesTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (TransformBreakpointEditor.this._updating) {
                    return;
                }
                TransformBreakpointEditor.this.setDirty(2);
            }
        });
        scrollable.setContent((Control)content);
        content.setSize(content.computeSize(-1, -1));
        return scrollable;
    }

    public void setFocus() {
    }

    public IStatus getStatus() {
        if (this._inButton.getSelection() || this._outButton.getSelection() || this._faultButton.getSelection()) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.switchyard.tools.ui.debug", "Must select at least one trigger (IN, OUT or FAULT).");
    }

    public Object getInput() {
        return this._breakpoint;
    }

    public void setInput(Object breakpoint) throws CoreException {
        this._updating = true;
        try {
            if (breakpoint instanceof TransformSequenceBreakpoint) {
                this._breakpoint = (TransformSequenceBreakpoint)breakpoint;
            } else {
                breakpoint = null;
            }
            this.initialize();
        }
        finally {
            this._updating = false;
        }
    }

    public void doSave() throws CoreException {
        if (this._breakpoint != null) {
            InteractionConfigurationBuilder builder = InteractionConfigurationBuilder.createFrom(this._breakpoint.getInteractionConfiguration());
            builder.triggers(this._triggers.isEmpty() ? null : EnumSet.copyOf(this._triggers));
            this._breakpoint.setInteractionConfiguration(builder.build());
            LinkedHashSet<TransformType> transforms = new LinkedHashSet<TransformType>();
            Object[] objectArray = this._typesTable.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                TransformType transform = (TransformType)obj;
                if (transform != null && transform.getFrom() != null && transform.getTo() != null) {
                    transforms.add(transform);
                }
                ++n2;
            }
            TransformConfigurationBuilder transformBuilder = TransformConfigurationBuilder.createFrom(this._breakpoint.getTransformConfiguration());
            transformBuilder.transforms(transforms);
            this._breakpoint.setTransformConfiguration(transformBuilder.build());
        }
        this.setDirty(false);
    }

    private void initialize() {
        if (this._breakpoint == null) {
            this._inButton.setEnabled(false);
            this._inButton.setSelection(false);
            this._outButton.setEnabled(false);
            this._outButton.setSelection(false);
            this._faultButton.setEnabled(false);
            this._faultButton.setSelection(false);
        } else {
            IInteractionConfiguration config = this._breakpoint.getInteractionConfiguration();
            ITransformConfiguration transformConfig = this._breakpoint.getTransformConfiguration();
            this._triggers = config == null ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : config.getTriggers();
            this._triggers = this._triggers == null || this._triggers.isEmpty() ? EnumSet.allOf(IInteractionConfiguration.TriggerType.class) : EnumSet.copyOf(this._triggers);
            this._inButton.setEnabled(true);
            this._inButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.IN));
            this._outButton.setEnabled(true);
            this._outButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT));
            this._faultButton.setSelection(this._triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT));
            this._typesTable.setInput(this.getTransforms());
            if (transformConfig.getTransforms() == null) {
                this._typesTable.setCheckedElements(new Object[0]);
            } else {
                this._typesTable.setCheckedElements(transformConfig.getTransforms().toArray());
            }
            this.updateEnablement();
        }
        this.setDirty(false);
    }

    private void updateEnablement() {
        this._faultButton.setEnabled(!this._outButton.getSelection());
        this._typesTable.getControl().setEnabled(this._triggers != null && this._triggers.size() > 0);
    }

    private Collection<TransformType> getTransforms() {
        IResource markerResource = this._breakpoint.getMarker().getResource();
        if (markerResource == null || markerResource.getProject() == null) {
            return Collections.emptyList();
        }
        ISwitchYardProject switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(markerResource.getProject());
        if (switchYardProject == null) {
            return Collections.emptyList();
        }
        IFile switchYardFile = switchYardProject.getOutputSwitchYardConfigurationFile();
        if (switchYardFile == null || !switchYardFile.isAccessible()) {
            switchYardFile = switchYardProject.getSwitchYardConfigurationFile();
        }
        if (switchYardFile == null || !switchYardFile.isAccessible()) {
            return Collections.emptyList();
        }
        ResourceSet rs = SwitchYardModelUtils.newResourceSet();
        Resource resource = rs.createResource(URI.createPlatformResourceURI((String)switchYardFile.getFullPath().toPortableString(), (boolean)true), "org.switchyard.content-type.1.x");
        try {
            resource.load(null);
            if (resource.getContents().size() > 0) {
                Object content = resource.getContents().get(0);
                if (content instanceof SwitchYardType) {
                    LinkedHashSet<TransformType> transforms = new LinkedHashSet<TransformType>();
                    for (TransformType transform : this.getTransforms((SwitchYardType)content)) {
                        transforms.add((TransformType)new TransformConfigurationBuilder.DummyTransformType(transform));
                    }
                    LinkedHashSet<TransformType> linkedHashSet = transforms;
                    return linkedHashSet;
                }
                if (content instanceof DocumentRoot) {
                    LinkedHashSet<TransformType> transforms = new LinkedHashSet<TransformType>();
                    for (TransformType transform : this.getTransforms(((DocumentRoot)content).getSwitchyard())) {
                        transforms.add((TransformType)new TransformConfigurationBuilder.DummyTransformType(transform));
                    }
                    LinkedHashSet<TransformType> linkedHashSet = transforms;
                    return linkedHashSet;
                }
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        finally {
            resource.unload();
        }
        return Collections.emptyList();
    }

    private Collection<TransformType> getTransforms(SwitchYardType switchyard) {
        if (switchyard == null || switchyard.getTransforms() == null) {
            return Collections.emptyList();
        }
        return switchyard.getTransforms().getTransform();
    }

    private final class TriggerSelectionListener
    extends SelectionAdapter {
        private final IInteractionConfiguration.TriggerType _trigger;

        private TriggerSelectionListener(IInteractionConfiguration.TriggerType trigger) {
            this._trigger = trigger;
        }

        public void widgetSelected(SelectionEvent event) {
            if (TransformBreakpointEditor.this._updating) {
                return;
            }
            if (((Button)event.widget).getSelection()) {
                TransformBreakpointEditor.this._triggers.add(this._trigger);
            } else {
                TransformBreakpointEditor.this._triggers.remove((Object)this._trigger);
            }
            TransformBreakpointEditor.this.updateEnablement();
            TransformBreakpointEditor.this.setDirty(1);
        }
    }
}

