/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.impl.TransformTypeImpl;
import org.switchyard.tools.ui.debug.ITransformConfiguration;

public final class TransformConfigurationBuilder {
    public static final String TRANSFORMS_KEY = "switchYardTransformerBreakpointMarker.transforms";
    private TransformConfigurationImpl _config = new TransformConfigurationImpl();

    private TransformConfigurationBuilder() {
    }

    public TransformConfigurationBuilder transforms(Set<TransformType> transforms) {
        if (transforms == null) {
            this._config._transforms = null;
        } else {
            this._config._transforms = new LinkedHashSet();
            for (TransformType transform : transforms) {
                this._config._transforms.add(new DummyTransformType(transform));
            }
        }
        return this;
    }

    public TransformConfigurationBuilder updateFrom(Map<String, Object> attributes) {
        StringTokenizer tokens;
        Object value = attributes.get(TRANSFORMS_KEY);
        StringTokenizer stringTokenizer = tokens = value instanceof String ? new StringTokenizer((String)value) : null;
        if (tokens == null || !tokens.hasMoreTokens()) {
            this._config._transforms = null;
        } else {
            this._config._transforms = new LinkedHashSet();
            while (tokens.hasMoreTokens()) {
                String to;
                String from = tokens.nextToken();
                String string = to = tokens.hasMoreTokens() ? tokens.nextToken() : null;
                if (to == null) continue;
                DummyTransformType transform = new DummyTransformType(from, to);
                this._config._transforms.add(transform);
            }
        }
        return this;
    }

    public ITransformConfiguration build() {
        return this._config;
    }

    public static TransformConfigurationBuilder create() {
        return new TransformConfigurationBuilder();
    }

    public static TransformConfigurationBuilder createFrom(ITransformConfiguration config) {
        return TransformConfigurationBuilder.create().transforms(config.getTransforms());
    }

    protected static final class DummyTransformType
    extends TransformTypeImpl {
        protected DummyTransformType(String from, String to) {
            this.from = from;
            this.to = to;
        }

        protected DummyTransformType(TransformType other) {
            this.from = other.getFrom();
            this.to = other.getTo();
        }

        public int hashCode() {
            return this.from == null ? 0 : this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof TransformType) {
                TransformType other = (TransformType)obj;
                return (this.from == null && other.getFrom() == null || this.from != null && this.from.equals(other.getFrom())) && (this.to == null && other.getTo() == null || this.to != null && this.to.equals(other.getTo()));
            }
            return false;
        }
    }

    private static final class TransformConfigurationImpl
    implements ITransformConfiguration {
        private Set<TransformType> _transforms;

        private TransformConfigurationImpl() {
        }

        @Override
        public Set<TransformType> getTransforms() {
            return this._transforms == null ? null : Collections.unmodifiableSet(this._transforms);
        }

        @Override
        public Map<String, Object> toAttributesMap() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (this._transforms != null && this._transforms.size() > 0) {
                StringBuffer buffer = new StringBuffer();
                for (TransformType transform : this._transforms) {
                    if (transform.getFrom() == null || transform.getTo() == null) continue;
                    buffer.append(transform.getFrom().toString()).append(' ');
                    buffer.append(transform.getTo().toString()).append(' ');
                }
                if (buffer.length() > 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                attributes.put(TransformConfigurationBuilder.TRANSFORMS_KEY, buffer.toString());
            }
            return attributes;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TransformConfigurationImpl) {
                TransformConfigurationImpl other = (TransformConfigurationImpl)obj;
                return (this._transforms == null || this._transforms.isEmpty()) && (other._transforms == null || other._transforms.isEmpty()) || this._transforms != null && this._transforms.equals(other._transforms);
            }
            return false;
        }
    }
}

