/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug.structure;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.switchyard.tools.ui.debug.structure.SwitchYardCamelExchangeVariable;
import org.switchyard.tools.ui.debug.structure.SwitchYardExchangeMessageVariable;
import org.switchyard.tools.ui.debug.structure.SwitchYardExchangeVariable;

public class SwitchYardContext
extends DebugElement
implements IVariable {
    private final IJavaThread _delegate;
    private IVariable _switchYardVariable;

    public SwitchYardContext(IJavaThread thread) {
        super(thread.getDebugTarget());
        this._delegate = thread;
    }

    public String getModelIdentifier() {
        return "org.switchyard.tools.ui.debug";
    }

    public IDebugTarget getDebugTarget() {
        return this._delegate.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this._delegate.getLaunch();
    }

    public IJavaThread getThread() {
        return this._delegate;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IJavaStackFrame.class) {
            try {
                return (IJavaStackFrame)this.getThread().getTopStackFrame();
            }
            catch (DebugException debugException) {
                return null;
            }
        }
        return super.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return "SwitchYard System Context";
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public String getName() throws DebugException {
        return "SwitchYard System Context";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        if (this._switchYardVariable == null) {
            IStackFrame[] iStackFrameArray = this.getThread().getStackFrames();
            int n = iStackFrameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStackFrame frame = iStackFrameArray[n2];
                IVariable[] iVariableArray = frame.getVariables();
                int n3 = iVariableArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVariable variable = iVariableArray[n4];
                    if (variable instanceof IJavaVariable) {
                        IJavaType type = ((IJavaVariable)variable).getJavaType();
                        if (type instanceof IJavaClassType) {
                            IJavaInterfaceType[] iJavaInterfaceTypeArray = ((IJavaClassType)type).getAllInterfaces();
                            int n5 = iJavaInterfaceTypeArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IJavaInterfaceType iface = iJavaInterfaceTypeArray[n6];
                                String typeName = iface.getName();
                                if ("org.switchyard.Exchange".equals(typeName)) {
                                    this._switchYardVariable = new SwitchYardExchangeVariable((IJavaObject)variable.getValue());
                                    return this._switchYardVariable.getValue();
                                }
                                if ("org.apache.camel.Exchange".equals(typeName)) {
                                    this._switchYardVariable = new SwitchYardCamelExchangeVariable((IJavaObject)variable.getValue());
                                    return this._switchYardVariable.getValue();
                                }
                                if ("org.switchyard.Message".equals(typeName)) {
                                    this._switchYardVariable = new SwitchYardExchangeMessageVariable((IJavaObject)variable.getValue());
                                    return this._switchYardVariable.getValue();
                                }
                                ++n6;
                            }
                        } else if (type instanceof IJavaInterfaceType) {
                            if ("org.switchyard.Exchange".equals(((IJavaInterfaceType)type).getName())) {
                                this._switchYardVariable = new SwitchYardExchangeVariable((IJavaObject)variable.getValue());
                                return this._switchYardVariable.getValue();
                            }
                            if ("org.apache.camel.Exchange".equals(((IJavaInterfaceType)type).getName())) {
                                this._switchYardVariable = new SwitchYardCamelExchangeVariable((IJavaObject)variable.getValue());
                                return this._switchYardVariable.getValue();
                            }
                            if ("org.switchyard.Message".equals(((IJavaInterfaceType)type).getName())) {
                                this._switchYardVariable = new SwitchYardExchangeMessageVariable((IJavaObject)variable.getValue());
                                return this._switchYardVariable.getValue();
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (this._switchYardVariable == null) {
            return null;
        }
        return this._switchYardVariable.getValue();
    }
}

