/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.designer.ddl.importer.node.AbstractImporter;
import org.teiid.designer.ddl.importer.node.StandardImporter;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;

public class DerbyImporter
extends StandardImporter {
    @Override
    protected RelationalProcedure createProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalProcedure procedure = super.createProcedure(procedureNode, model);
        for (AstNode child : procedureNode) {
            if (!this.is(child, "derbyddl:functionParameter")) continue;
            RelationalParameter prm = this.getFactory().createParameter();
            procedure.getParameters().add(prm);
            this.initialize((RelationalReference)prm, child);
            String datatype = child.getProperty("ddl:datatypeName").toString();
            prm.setNativeType(datatype);
            String teiidType = this.getTeiidDataTypeName(datatype);
            prm.setDatatype(teiidType);
            Object prop = child.getProperty("ddl:datatypeLength");
            if (prop != null) {
                prm.setLength(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:datatypePrecision")) != null) {
                prm.setPrecision(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:datatypeScale")) != null) {
                prm.setScale(Integer.parseInt(prop.toString()));
            }
            if ((prop = child.getProperty("ddl:nullable")) != null) {
                prm.setNullable(prop.toString());
            }
            if ((prop = child.getProperty("ddl:defaultValue")) == null) continue;
            prm.setDefaultValue(prop.toString());
        }
        return procedure;
    }

    @Override
    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        if (this.is(node, "derbyddl:createIndexStatement")) {
            deferredMap.put(node, null);
        } else if (this.is(node, "derbyddl:createProcedureStatement")) {
            this.createProcedure(node, model);
        } else if (this.is(node, "derbyddl:createFunctionStatement")) {
            this.createProcedure(node, model).setFunction(true);
        } else {
            return super.createObject(node, model, schema);
        }
        return deferredMap;
    }

    @Override
    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createPrimaryKey(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:addTableConstraintDefinition")) continue;
                this.createPrimaryKey(node1, table, allRefs);
            }
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "derbyddl:createIndexStatement")) {
                RelationalIndex index = this.getFactory().createIndex();
                StandardImporter.Info info = this.createInfo(node, model);
                if (info.getSchema() == null) {
                    model.addChild((RelationalReference)index);
                } else {
                    info.getSchema().getIndexes().add(index);
                }
                this.initialize((RelationalReference)index, node, info.getName());
                Object prop = node.getProperty("derbyddl:unique");
                if (prop != null) {
                    index.setUnique(((Boolean)prop).booleanValue());
                }
                if ((prop = node.getProperty("derbyddl:tableName")) == null) {
                    return;
                }
                try {
                    RelationalTable table2 = this.find(RelationalTable.class, prop.toString(), node, null, allRefs);
                    for (AstNode node1 : node) {
                        if (!node1.hasMixin("derbyddl:indexColumnReference")) continue;
                        try {
                            index.getColumns().add(this.find(RelationalColumn.class, node1, (RelationalReference)table2, allRefs));
                        }
                        catch (AbstractImporter.EntityNotFoundException error) {
                            this.addProgressMessage(error.getMessage());
                        }
                    }
                }
                catch (AbstractImporter.EntityNotFoundException error) {
                    this.addProgressMessage(error.getMessage());
                }
                continue;
            }
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (this.is(node1, "ddl:addTableConstraintDefinition")) {
                    this.createConstraint(node1, table, allRefs);
                    continue;
                }
                if (!this.is(node1, "ddl:addColumnDefinition")) continue;
                this.createColumn(node1, table);
            }
        }
    }
}

