/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.designer.ddl.importer.node.StandardImporter;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;

public class PostgresImporter
extends StandardImporter {
    private static final String TEXT_TYPE_NAME = "TEXT";
    private static final String IMAGE_TYPE_NAME = "IMAGE";

    @Override
    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        if (this.is(node, "postgresddl:createIndexStatement")) {
            deferredMap.put(node, null);
        } else if (this.is(node, "postgresddl:createFunctionStatement")) {
            this.createProcedure(node, model).setFunction(true);
        } else {
            return super.createObject(node, model, schema);
        }
        return deferredMap;
    }

    @Override
    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createPrimaryKey(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (!this.is(node1, "ddl:addTableConstraintDefinition")) continue;
                this.createPrimaryKey(node1, table, allRefs);
            }
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "postgresddl:createIndexStatement")) {
                RelationalIndex index = this.getFactory().createIndex();
                StandardImporter.Info info = this.createInfo(node, model);
                if (info.getSchema() == null) {
                    model.addChild((RelationalReference)index);
                } else {
                    info.getSchema().getIndexes().add(index);
                }
                this.initialize((RelationalReference)index, node, info.getName());
                continue;
            }
            if (this.is(node, "ddl:tableConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, allRefs);
                continue;
            }
            if (!this.is(node, "ddl:alterTableStatement")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            for (AstNode node1 : node) {
                if (this.is(node1, "ddl:addTableConstraintDefinition")) {
                    this.createConstraint(node1, table, allRefs);
                    continue;
                }
                if (!this.is(node1, "ddl:addColumnDefinition")) continue;
                this.createColumn(node1, table);
            }
        }
    }

    @Override
    protected String getTeiidDataTypeName(String jdbcTypeName) throws Exception {
        String standardName = jdbcTypeName;
        if (TEXT_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "CLOB";
        }
        if (IMAGE_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "BLOB";
        }
        return super.getTeiidDataTypeName(standardName);
    }
}

