/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node.teiid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.ddl.DdlImporterManager;
import org.teiid.designer.ddl.importer.DdlImporterI18n;
import org.teiid.designer.ddl.importer.DdlImporterPlugin;
import org.teiid.designer.ddl.importer.node.teiid.MaterializedTableReferenceInfo;
import org.teiid.designer.ddl.importer.node.teiid.TeiidAbstractImporter;
import org.teiid.designer.ddl.importer.node.teiid.TeiidStandardImporter;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.relational.model.RelationalViewTable;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlConstants;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;

public class TeiidDdlImporter
extends TeiidStandardImporter {
    private static final String NS_TEIID_ODATA = "teiid_odata";
    private static final String NS_TEIID_WEBSERVICE = "teiid_ws";
    private static final String NS_TEIID_MONGO = "teiid_mongo";
    private static final String NS_TEIID_SALESFORCE = "teiid_sf";
    private static final String NS_TEIID_RELATIONAL = "teiid_rel";
    private static final String NS_TEIID_ACCUMULO = "teiid_accumulo";
    private static final String NS_TEIID_EXCEL = "teiid_excel";
    private static final String NS_TEIID_JPA = "teiid_jpa";
    private static final String NS_DESIGNER_ODATA = "odata";
    private static final String NS_DESIGNER_WEBSERVICE = "ws";
    private static final String NS_DESIGNER_MONGO = "mongodb";
    private static final String NS_DESIGNER_SALESFORCE = "salesforce";
    private static final String NS_DESIGNER_RELATIONAL = "relational";
    private static final String NS_DESIGNER_ACCUMULO = "accumulo";
    private static final String NS_DESIGNER_EXCEL = "excel";
    private static final String NS_DESIGNER_JPA = "jpa2";
    private static final String REST_COLON_PREFIX = "REST:";
    private static final String REST_URI = "URI";
    private static final String REST_METHOD = "METHOD";
    private static final String REST_CHARSET = "CHARSET";
    private static final String SF_PROPNAME_CALCULATED_BAD = "calculated";
    private static final String SF_PROPNAME_CALCULATED_GOOD = "Calculated";
    private static final String XMLLITERAL_TYPE_NAME = "XMLLiteral";
    static int DEFAULT_NULL_VALUE_COUNT = -1;
    private Map<AstNode, RelationalViewTable> deferredMatViewReferences = new HashMap<AstNode, RelationalViewTable>();

    @Override
    protected TeiidInfo createInfo(AstNode node, RelationalModel model) throws Exception {
        return new TeiidInfo(node, model);
    }

    @Override
    protected String getTeiidDataTypeName(String datatype) throws Exception {
        String resultTypeName = null;
        String targetTypeName = datatype;
        if (datatype.equalsIgnoreCase("xml")) {
            targetTypeName = XMLLITERAL_TYPE_NAME;
        }
        EObject[] builtInTypes = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
        String dtName = null;
        int i = 0;
        while (i < builtInTypes.length) {
            dtName = ModelerCore.getWorkspaceDatatypeManager().getName(builtInTypes[i]);
            if (dtName != null && dtName.equalsIgnoreCase(targetTypeName)) {
                resultTypeName = dtName;
                break;
            }
            ++i;
        }
        if (resultTypeName == null) {
            resultTypeName = super.getTeiidDataTypeName(datatype);
        }
        return resultTypeName;
    }

    private void createConstraint(AstNode constraintNode, RelationalTable table, RelationalModel model, Collection<RelationalReference> allRefs) throws CoreException {
        String type = constraintNode.getProperty("teiidddl:constraintType").toString();
        RelationalPrimaryKey key = null;
        if ("PRIMARY KEY".equals(type)) {
            this.createPrimaryKey(constraintNode, table, allRefs);
            key = table.getPrimaryKey();
        } else if ("INDEX".equals(type)) {
            key = this.createIndex(constraintNode, table, allRefs);
        } else if ("UNIQUE".equals(type)) {
            key = this.createUniqueConstraint(constraintNode, table, allRefs);
        } else if (TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl().equals(type)) {
            key = this.createAccessPattern(constraintNode, table, allRefs);
        } else if ("FOREIGN KEY".equals(type)) {
            key = this.createForeignKey(constraintNode, table, allRefs);
        } else assert (false) : "Unexpected constraint type of '" + type + "'";
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = constraintNode.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        if (!optionNodes.isEmpty()) {
            this.processOptions(optionNodes, (RelationalReference)key);
        }
    }

    private boolean columnsMatch(List<AstNode> columns_1, Collection<RelationalColumn> columns_2) {
        if (columns_1 == null && columns_2 == null) {
            return true;
        }
        if (columns_1 == null || columns_2 == null) {
            return false;
        }
        if (columns_1.size() != columns_2.size()) {
            return false;
        }
        for (AstNode colOuter_1 : columns_1) {
            boolean foundIt = false;
            String columnName = colOuter_1.getName();
            for (RelationalColumn colInner_2 : columns_2) {
                if (!columnName.equals(colInner_2.getName())) continue;
                foundIt = true;
            }
            if (foundIt) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createPrimaryKey(AstNode node, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        RelationalPrimaryKey key = this.getFactory().createPrimaryKey();
        table.setPrimaryKey(key);
        this.initialize((RelationalReference)key, node);
        List references = (List)node.getProperty("teiidddl:tableElementRefs");
        for (AstNode ref : references) {
            try {
                RelationalColumn column = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                key.getColumns().add(column);
            }
            catch (TeiidAbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
    }

    private RelationalReference createUniqueConstraint(AstNode constraintNode, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        RelationalUniqueConstraint constraint = this.getFactory().createUniqueConstraint();
        this.initialize((RelationalReference)constraint, constraintNode);
        table.addUniqueConstraint(constraint);
        List references = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        for (AstNode ref : references) {
            try {
                RelationalColumn col = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                if (col == null) continue;
                constraint.getColumns().add(col);
            }
            catch (TeiidAbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        return constraint;
    }

    private RelationalReference createAccessPattern(AstNode constraintNode, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        RelationalAccessPattern constraint = this.getFactory().createAccessPattern();
        this.initialize((RelationalReference)constraint, constraintNode);
        table.addAccessPattern(constraint);
        List references = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        for (AstNode ref : references) {
            try {
                RelationalColumn col = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                if (col == null) continue;
                constraint.getColumns().add(col);
            }
            catch (TeiidAbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        return constraint;
    }

    private RelationalReference createIndex(AstNode constraintNode, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        RelationalIndex constraint = this.getFactory().createIndex();
        this.initialize((RelationalReference)constraint, constraintNode);
        table.addIndex(constraint);
        List references = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        for (AstNode ref : references) {
            try {
                RelationalColumn col = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                if (col == null) continue;
                constraint.getColumns().add(col);
            }
            catch (TeiidAbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        return constraint;
    }

    private RelationalReference createForeignKey(AstNode constraintNode, RelationalTable table, Collection<RelationalReference> allRefs) throws CoreException {
        RelationalForeignKey foreignKey = this.getFactory().createForeignKey();
        this.initializeFK(table.getForeignKeys(), foreignKey, constraintNode);
        table.addForeignKey(foreignKey);
        List references = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        for (AstNode ref : references) {
            try {
                RelationalColumn col = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                if (col == null) continue;
                foreignKey.getColumns().add(col);
            }
            catch (TeiidAbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        AstNode tableRefNode = (AstNode)constraintNode.getProperty("teiidddl:tableRef");
        if (tableRefNode == null) {
            this.addProgressMessage(String.valueOf(DdlImporterI18n.FK_TABLE_REF_NOT_FOUND_MSG) + " '" + foreignKey.getName() + "'");
            return foreignKey;
        }
        try {
            boolean columnsMatch;
            Object tempRefColumns;
            List foreignTableColumnNodes;
            int numFKTableReferenceColumns;
            RelationalTable tableRef = this.find(RelationalTable.class, tableRefNode, null, allRefs);
            RelationalPrimaryKey tableRefPrimaryKey = tableRef.getPrimaryKey();
            RelationalUniqueConstraint tableRefUC = null;
            if (!tableRef.getUniqueConstraints().isEmpty()) {
                tableRefUC = (RelationalUniqueConstraint)tableRef.getUniqueConstraints().iterator().next();
            }
            if ((numFKTableReferenceColumns = (foreignTableColumnNodes = (tempRefColumns = constraintNode.getProperty("teiidddl:tableRefElementRefs")) == null ? Collections.emptyList() : (List)tempRefColumns).size()) == 0) {
                if (tableRefPrimaryKey != null) {
                    foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                    foreignKey.setUniqueKeyTableName(tableRef.getName());
                } else if (tableRefUC != null) {
                    foreignKey.setUniqueKeyName(tableRefUC.getName());
                    foreignKey.setUniqueKeyTableName(tableRef.getName());
                }
                return foreignKey;
            }
            int numPKColumns = 0;
            if (tableRefPrimaryKey != null) {
                numPKColumns = tableRefPrimaryKey.getColumns().size();
            }
            int numUCColumns = 0;
            if (tableRefUC != null) {
                numUCColumns = tableRefUC.getColumns().size();
            }
            boolean constraintWasPK = false;
            if (numFKTableReferenceColumns == numPKColumns && (columnsMatch = this.columnsMatch(foreignTableColumnNodes, tableRefPrimaryKey.getColumns()))) {
                foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                foreignKey.setUniqueKeyTableName(tableRef.getName());
                constraintWasPK = true;
            }
            if (!constraintWasPK) {
                if (numUCColumns == numFKTableReferenceColumns) {
                    columnsMatch = this.columnsMatch(foreignTableColumnNodes, tableRefUC.getColumns());
                    if (columnsMatch) {
                        foreignKey.setUniqueKeyName(tableRefUC.getName());
                        foreignKey.setUniqueKeyTableName(tableRef.getName());
                    }
                } else {
                    foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                    foreignKey.setUniqueKeyTableName(tableRef.getName());
                }
            }
        }
        catch (TeiidAbstractImporter.EntityNotFoundException error) {
            this.addProgressMessage(error.getMessage());
        }
        return foreignKey;
    }

    @Override
    protected RelationalColumn createColumn(AstNode node, RelationalTable table) throws Exception {
        RelationalColumn column = super.createColumn(node, table);
        column.setNativeType(RelationalColumn.DEFAULT_NATIVE_TYPE);
        Object prop = node.getProperty("teiidddl:autoIncrement");
        if (prop != null) {
            column.setAutoIncremented(((Boolean)prop).booleanValue());
        }
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = node.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        this.processOptions(optionNodes, (RelationalReference)column);
        return column;
    }

    @Override
    protected void setDataType(AstNode node, RelationalColumn column) throws Exception {
        String datatype = node.getProperty("ddl:datatypeName").toString();
        String teiidType = this.getTeiidDataTypeName(datatype);
        if (teiidType.toUpperCase().equals("INTEGER")) {
            column.setDatatype("INT".toLowerCase());
        } else {
            column.setDatatype(teiidType);
        }
        Object prop = node.getProperty("ddl:datatypeLength");
        if (prop != null) {
            column.setLength(Integer.parseInt(prop.toString()));
        } else if (teiidType.equalsIgnoreCase("string")) {
            column.setLength(ModelerCore.getTransformationPreferences().getDefaultStringLength());
        } else if (teiidType.equalsIgnoreCase("char")) {
            column.setLength(1);
        }
        prop = node.getProperty("ddl:datatypePrecision");
        if (prop != null) {
            column.setPrecision(Integer.parseInt(prop.toString()));
        } else if (teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BIGDECIMAL.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DECIMAL.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.FLOAT.name()) || teiidType.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DOUBLE.name())) {
            column.setPrecision(0);
        }
        prop = node.getProperty("ddl:datatypeScale");
        if (prop != null) {
            column.setScale(Integer.parseInt(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:nullable")) != null) {
            column.setNullable(this.getRelRefNullable(prop.toString()));
        }
        if ((prop = node.getProperty("ddl:defaultValue")) != null) {
            column.setDefaultValue(prop.toString());
        }
    }

    @Override
    protected RelationalProcedure createProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalProcedure procedure = super.createProcedure(procedureNode, model);
        ArrayList<AstNode> procOptionNodes = new ArrayList<AstNode>();
        for (AstNode child : procedureNode) {
            if (this.is(child, "teiidddl:procedureParameter")) {
                this.createProcedureParameter(child, procedure);
                continue;
            }
            if (this.is(child, "teiidddl:resultColumns")) {
                RelationalProcedureResultSet result = this.getFactory().createProcedureResultSet();
                procedure.setResultSet(result);
                this.initialize((RelationalReference)result, procedureNode);
                for (AstNode resultCol : child) {
                    if (!resultCol.hasMixin("teiidddl:resultColumn")) continue;
                    this.createColumn(resultCol, (RelationalTable)result);
                }
                continue;
            }
            if (this.is(child, "teiidddl:resultDataType")) {
                RelationalParameter param = this.createProcedureParameter(child, procedure);
                param.setName("resultParam");
                param.setDirection(DirectionKind.RETURN_LITERAL.toString());
                continue;
            }
            if (!this.is(child, "ddl:statementOption")) continue;
            procOptionNodes.add(child);
        }
        this.processOptions(procOptionNodes, (RelationalReference)procedure);
        return procedure;
    }

    protected RelationalProcedure createVirtualProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalViewProcedure procedure = this.getFactory().createViewProcedure();
        TeiidInfo info = this.createInfo(procedureNode, model);
        if (info.getSchema() == null) {
            model.addChild((RelationalReference)procedure);
        } else {
            info.getSchema().getProcedures().add(procedure);
            procedure.setParent((RelationalReference)info.getSchema());
        }
        this.initialize((RelationalReference)procedure, procedureNode, info.getName());
        if (procedureNode.getProperty("ddl:datatypeName") != null) {
            RelationalProcedureResultSet result = this.getFactory().createProcedureResultSet();
            procedure.setResultSet(result);
            this.initialize((RelationalReference)result, procedureNode);
        }
        ArrayList<AstNode> procOptionNodes = new ArrayList<AstNode>();
        for (AstNode child : procedureNode) {
            if (this.is(child, "teiidddl:procedureParameter")) {
                this.createProcedureParameter(child, (RelationalProcedure)procedure);
                continue;
            }
            if (this.is(child, "teiidddl:resultColumns")) {
                RelationalProcedureResultSet result = this.getFactory().createProcedureResultSet();
                procedure.setResultSet(result);
                this.initialize((RelationalReference)result, procedureNode);
                for (AstNode resultCol : child) {
                    if (!resultCol.hasMixin("teiidddl:resultColumn")) continue;
                    this.createColumn(resultCol, (RelationalTable)result);
                }
                continue;
            }
            if (this.is(child, "teiidddl:resultDataType")) {
                RelationalParameter param = this.createProcedureParameter(child, (RelationalProcedure)procedure);
                param.setDirection(DirectionKind.RETURN_LITERAL.toString());
                param.setName("RETURNS");
                continue;
            }
            if (!this.is(child, "ddl:statementOption")) continue;
            procOptionNodes.add(child);
        }
        try {
            NewModelObjectHelperManager.helpCreate((Object)procedure, (Map)new Properties());
        }
        catch (ModelerCoreException err) {
            DdlImporterPlugin.UTIL.log(4, (Throwable)err, err.getMessage());
        }
        String queryExpression = (String)procedureNode.getProperty("teiidddl:statement");
        if (!StringUtilities.isEmpty((String)queryExpression)) {
            procedure.setTransformationSQL(queryExpression);
        }
        this.processOptions(procOptionNodes, (RelationalReference)procedure);
        return procedure;
    }

    @Override
    protected RelationalParameter createProcedureParameter(AstNode node, RelationalProcedure procedure) throws Exception {
        RelationalParameter prm = super.createProcedureParameter(node, procedure);
        Object prop = node.getProperty("teiidddl:parameterType");
        if (prop != null) {
            String direction = prop.toString();
            prm.setDirection(direction);
        }
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = node.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        this.processOptions(optionNodes, (RelationalReference)prm);
        return prm;
    }

    @Override
    public RelationalModel importNode(AstNode rootNode, DdlImporterManager importManager, Properties props) throws Exception {
        boolean doIt;
        this.setImporterManager(importManager);
        this.getImporterManager().optToGenerateDefaultSQL(false);
        this.getImporterManager().optToHelpCreateTransform(false);
        String updatableOverride = (String)props.get("ddlImport_table_updatable_override");
        this.getImporterManager().setTableUpdatableOverride(updatableOverride);
        RelationalModel model = this.getFactory().createModel("ddlImportedModel");
        model.setModelType(importManager.getModelType().getValue());
        if (model.getModelType() == ModelType.VIRTUAL) {
            this.getImporterManager().optToHelpCreateTransform(true);
        }
        HashMap<AstNode, RelationalReference> deferredCreateMap = new HashMap<AstNode, RelationalReference>();
        for (AstNode node : rootNode) {
            Map<AstNode, RelationalReference> deferredMap;
            if (this.is(node, "ddl:createSchemaStatement")) {
                RelationalSchema schema = this.getFactory().createSchema();
                model.addChild((RelationalReference)schema);
                this.initialize((RelationalReference)schema, node);
                for (AstNode node1 : node) {
                    Map<AstNode, RelationalReference> deferredMap2 = this.createObject(node1, model, schema);
                    if (deferredMap2.isEmpty()) continue;
                    deferredCreateMap.putAll(deferredMap2);
                }
                continue;
            }
            if (this.is(node, "teiidddl:optionNamespace") || (deferredMap = this.createObject(node, model, null)).isEmpty()) continue;
            deferredCreateMap.putAll(deferredMap);
        }
        this.createDeferredObjects(deferredCreateMap, model);
        String doFilterStr = (String)props.get("ddlImport_filterConstraints");
        if (doFilterStr != null && (doIt = Boolean.parseBoolean(doFilterStr))) {
            this.removeRedundantConstraints(model);
        }
        return model;
    }

    @Override
    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        boolean isVirtual;
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        boolean bl = isVirtual = model.getModelType() == ModelType.VIRTUAL;
        if (this.is(node, "teiidddl:createTable") || this.is(node, "teiidddl:createGlobalTempTable") || this.is(node, "teiidddl:createLocalTempTable")) {
            RelationalTable baseTable = this.getFactory().createBaseTable();
            this.initializeTable(baseTable, node, model);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            for (AstNode child : node) {
                if (this.is(child, "teiidddl:tableElement")) {
                    this.createColumn(child, baseTable);
                    continue;
                }
                if (this.is(child, "ddl:statementOption")) {
                    optionNodes.add(child);
                    continue;
                }
                if (!this.is(child, "teiidddl:tableElementConstraint") && !this.is(child, "teiidddl:foreignKeyConstraint") && !this.is(child, "teiidddl:indexConstraint")) continue;
                deferredMap.put(child, (RelationalReference)baseTable);
            }
            if (!optionNodes.isEmpty()) {
                this.processOptions(optionNodes, (RelationalReference)baseTable);
            }
            if (isVirtual && this.is(node, "teiidddl:createGlobalTempTable")) {
                baseTable.addExtensionProperty("relational:global-temp-table", Boolean.toString(true));
            }
        } else if (this.is(node, "teiidddl:createView")) {
            String queryExpression;
            Object viewTable = null;
            viewTable = isVirtual ? this.getFactory().createViewTable() : this.getFactory().createBaseTable();
            this.initializeTable(viewTable, node, model);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            for (AstNode child : node) {
                if (this.is(child, "teiidddl:tableElement")) {
                    this.createColumn(child, (RelationalTable)viewTable);
                    continue;
                }
                if (this.is(child, "ddl:statementOption")) {
                    optionNodes.add(child);
                    continue;
                }
                if (!this.is(child, "teiidddl:tableElementConstraint") && !this.is(child, "teiidddl:foreignKeyConstraint") && !this.is(child, "teiidddl:indexConstraint")) continue;
                deferredMap.put(child, (RelationalReference)viewTable);
            }
            if (!optionNodes.isEmpty()) {
                this.processOptions(optionNodes, (RelationalReference)viewTable);
            }
            if (isVirtual && !StringUtilities.isEmpty((String)(queryExpression = (String)node.getProperty("teiidddl:queryExpression")))) {
                viewTable.setTransformationSQL(queryExpression);
            }
        } else if (this.is(node, "teiidddl:createProcedure") || this.is(node, "teiidddl:createFunction")) {
            String modelType = (String)node.getProperty("teiidddl:schemaElementType");
            if (modelType != null) {
                if (modelType.equalsIgnoreCase(ModelType.VIRTUAL_LITERAL.toString())) {
                    this.createVirtualProcedure(node, model);
                } else {
                    this.createProcedure(node, model);
                }
            }
        } else if (this.is(node, "teiidddl:alterTable")) {
            deferredMap.put(node, null);
        } else if (!this.is(node, "teiidddl:alterView") && !this.is(node, "teiidddl:alterProcedure")) {
            return super.createObject(node, model, schema);
        }
        return deferredMap;
    }

    @Override
    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (!this.is(node, "teiidddl:tableElementConstraint")) continue;
            table = (RelationalTable)deferredNodes.get(node);
            this.createConstraint(node, table, model, allRefs);
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "teiidddl:foreignKeyConstraint") || this.is(node, "teiidddl:indexConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, model, allRefs);
                continue;
            }
            if (!this.is(node, "teiidddl:alterTable")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            if (table != null) {
                for (AstNode child : node) {
                    if (!this.is(child, "teiidddl:alterOptionsList")) continue;
                    List nodeList = child.getChildren();
                    for (AstNode listItem : nodeList) {
                        if (!listItem.hasMixin("ddl:statementOption")) continue;
                        optionNodes.add(listItem);
                    }
                }
            }
            if (optionNodes.isEmpty()) continue;
            this.processOptions(optionNodes, (RelationalReference)table);
        }
    }

    private void processOptions(List<AstNode> optionNodes, RelationalReference relationalReference) {
        this.processTeiidStandardOptions(optionNodes, relationalReference);
        this.processTeiidExtensionOptions(optionNodes, relationalReference);
    }

    private void processTeiidStandardOptions(List<AstNode> optionNodes, RelationalReference relationalReference) {
        this.processTeiidCommonOptions(optionNodes, relationalReference);
        if (relationalReference instanceof RelationalTable) {
            this.processTeiidTableOptions(optionNodes, (RelationalTable)relationalReference);
        } else if (relationalReference instanceof RelationalColumn) {
            this.processTeiidColumnOptions(optionNodes, (RelationalColumn)relationalReference);
        } else if (relationalReference instanceof RelationalProcedure) {
            this.processTeiidProcedureOptions(optionNodes, (RelationalProcedure)relationalReference);
        }
    }

    private void processTeiidCommonOptions(List<AstNode> optionNodes, RelationalReference entity) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("ANNOTATION")) {
                entity.setDescription(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("UUID")) {
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("NAMEINSOURCE")) continue;
            entity.setNameInSource(optionValueStr);
            nodeIter.remove();
        }
    }

    private int convertLargeStatisticValueToInt(String optionValueStr) {
        assert (optionValueStr != null && !optionValueStr.isEmpty());
        long value = Long.parseLong(optionValueStr);
        if (value == -1L || value < 0L) {
            return -1;
        }
        if (value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        return Float.floatToRawIntBits(value) | Integer.MIN_VALUE;
    }

    private void processTeiidTableOptions(List<AstNode> optionNodes, RelationalTable table) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("CARDINALITY")) {
                int cardinality = this.convertLargeStatisticValueToInt(optionValueStr);
                table.setCardinality(cardinality);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MATERIALIZED")) {
                table.setMaterialized(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MATERIALIZED_TABLE")) {
                this.deferredMatViewReferences.put(optionNode, (RelationalViewTable)table);
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("UPDATABLE")) continue;
            table.setSupportsUpdate(this.isTrue(optionValueStr));
            nodeIter.remove();
        }
        if (this.hasTableUpdatableOverride()) {
            table.setSupportsUpdate(this.getTableUpdatableOverride());
        }
    }

    private boolean hasTableUpdatableOverride() {
        return this.getImporterManager().getTableUpdatableOverride() != null;
    }

    private boolean getTableUpdatableOverride() {
        return Boolean.parseBoolean(this.getImporterManager().getTableUpdatableOverride());
    }

    private void processTeiidProcedureOptions(List<AstNode> optionNodes, RelationalProcedure procedure) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("UPDATECOUNT")) {
                procedure.setUpdateCount(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CATEGORY")) {
                procedure.setFunctionCategory(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("AGGREGATE")) {
                procedure.setAggregate(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ALLOWS-DISTINCT")) {
                procedure.setAllowsDistinct(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ALLOWS-ORDERBY")) {
                procedure.setAllowsOrderBy(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ANALYTIC")) {
                procedure.setAnalytic(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("DECOMPOSABLE")) {
                procedure.setDecomposable(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NON-PREPARED")) {
                procedure.setNonPrepared(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NULL-ON-NULL")) {
                procedure.setReturnsNullOnNull(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("USES-DISTINCT-ROWS")) {
                procedure.setUseDistinctRows(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("VARARGS")) {
                procedure.setVariableArguments(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("DETERMINISM")) {
                procedure.setDeterministic(this.isDeterministic(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NATIVE-QUERY")) {
                procedure.setNativeQuery(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("FUNCTION-CATEGORY")) {
                procedure.setFunctionCategory(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("JAVA_CLASS")) {
                procedure.setJavaClassName(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("JAVA_METHOD")) continue;
            procedure.setJavaMethodName(optionValueStr);
            procedure.setFunction(true);
            nodeIter.remove();
        }
    }

    private void processTeiidColumnOptions(List<AstNode> optionNodes, RelationalColumn column) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("SELECTABLE")) {
                column.setSelectable(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("UPDATABLE")) {
                column.setUpdateable(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CURRENCY")) {
                column.setCurrency(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CASE_SENSITIVE")) {
                column.setCaseSensitive(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("SIGNED")) {
                column.setSigned(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("FIXED_LENGTH")) {
                column.setLengthFixed(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("SEARCHABLE")) {
                column.setSearchability(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MIN_VALUE")) {
                column.setMinimumValue(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MAX_VALUE")) {
                column.setMaximumValue(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NATIVE_TYPE")) {
                column.setNativeType(optionValueStr);
                nodeIter.remove();
                this.resolveColumnDatatype(column, optionValueStr);
                continue;
            }
            if (optionName.equalsIgnoreCase("NULL_VALUE_COUNT")) {
                int nullValueCount = this.convertLargeStatisticValueToInt(optionValueStr);
                column.setNullValueCount(nullValueCount);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("DISTINCT_VALUES")) {
                int distinctValues = this.convertLargeStatisticValueToInt(optionValueStr);
                column.setDistinctValueCount(distinctValues);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("RADIX")) {
                column.setRadix(Integer.parseInt(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("CHAR_OCTET_LENGTH")) continue;
            column.setCharacterOctetLength(Integer.parseInt(optionValueStr));
            nodeIter.remove();
        }
    }

    private void resolveColumnDatatype(RelationalColumn column, String nativeType) {
        if ((column.getDatatype().equalsIgnoreCase("INTEGER") || column.getDatatype().equalsIgnoreCase("BIGINTEGER")) && nativeType.equalsIgnoreCase("INT")) {
            column.setDatatype(nativeType);
        } else if (column.getDatatype().equalsIgnoreCase("STRING") && nativeType.equalsIgnoreCase("CHAR")) {
            if (column.getLength() > 1) {
                column.setDatatype("STRING");
            } else {
                column.setDatatype(nativeType);
            }
        } else if (column.getDatatype().equalsIgnoreCase("VARBINARY") && nativeType.equalsIgnoreCase("BINARY")) {
            column.setDatatype("OBJECT".toLowerCase());
        } else if (!column.getDatatype().equalsIgnoreCase("TIMESTAMP") || !nativeType.equalsIgnoreCase("DATETIME")) {
            if (column.getDatatype().equalsIgnoreCase("DOUBLE") && nativeType.equalsIgnoreCase("FLOAT")) {
                column.setDatatype(nativeType);
                if (column.getPrecision() == 0) {
                    column.setPrecision(53);
                }
            } else if (column.getDatatype().equalsIgnoreCase("BIGDECIMAL") && nativeType.equalsIgnoreCase("DECIMAL")) {
                column.setDatatype(nativeType);
            } else if (column.getDatatype().equalsIgnoreCase("SHORT") && nativeType.equalsIgnoreCase("TINYINT")) {
                column.setDatatype("BYTE".toLowerCase());
            } else if (column.getDatatype().equalsIgnoreCase("FLOAT") && nativeType.equalsIgnoreCase("REAL") && column.getPrecision() == 0) {
                column.setPrecision(24);
            }
        }
    }

    protected boolean isFixedLength(String typeName) {
        return !"LONGVARBINARY".equalsIgnoreCase(typeName) && !"LONGVARCHAR".equalsIgnoreCase(typeName) && !"VARBINARY".equalsIgnoreCase(typeName) && !"VARCHAR".equalsIgnoreCase(typeName) && !"ARRAY".equalsIgnoreCase(typeName) && !"BLOB".equalsIgnoreCase(typeName) && !"CLOB".equalsIgnoreCase(typeName) && !"IMAGE".equalsIgnoreCase(typeName) && !"TEXT".equalsIgnoreCase(typeName);
    }

    private boolean isDeterministic(String determinismStr) {
        if ("NONDETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("COMMAND_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("SESSION_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("USER_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("VDB_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        return "DETERMINISTIC".equalsIgnoreCase(determinismStr);
    }

    private void processTeiidExtensionOptions(List<AstNode> optionNodes, RelationalReference relationalEntity) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (!CoreStringUtil.isEmpty((String)optionName)) {
                String optionValueStr;
                if (this.isUriNamespaced(optionName) || this.isPrefixNamespaced(optionName)) {
                    optionName = this.translateNamespacedOptionName(optionName);
                }
                if (!CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) {
                    if (relationalEntity instanceof RelationalViewProcedure) {
                        RelationalViewProcedure proc = (RelationalViewProcedure)relationalEntity;
                        if (optionName.startsWith(REST_COLON_PREFIX)) {
                            if (optionName.toUpperCase().endsWith(REST_URI)) {
                                proc.setRestUri(optionValueStr);
                            } else if (optionName.toUpperCase().endsWith(REST_METHOD)) {
                                proc.setRestMethod(optionValueStr);
                            } else if (optionName.toUpperCase().endsWith(REST_CHARSET)) {
                                proc.setRestCharSet(optionValueStr);
                            } else {
                                relationalEntity.addExtensionProperty(optionName, optionValueStr);
                            }
                        }
                    } else {
                        relationalEntity.addExtensionProperty(optionName, optionValueStr);
                    }
                }
            }
            nodeIter.remove();
        }
    }

    private void removeRedundantConstraints(RelationalModel model) {
        for (RelationalReference child : model.getChildren()) {
            if (!(child instanceof RelationalTable)) continue;
            RelationalPrimaryKey pk = ((RelationalTable)child).getPrimaryKey();
            RelationalUniqueConstraint deleteThisConstraint = null;
            if (pk != null) {
                Collection constraints = ((RelationalTable)child).getUniqueConstraints();
                for (RelationalUniqueConstraint uc : constraints) {
                    boolean same = false;
                    if (pk.getColumns().size() == uc.getColumns().size()) {
                        same = true;
                        for (RelationalColumn col : pk.getColumns()) {
                            if (uc.getColumns().contains(col)) continue;
                            same = false;
                        }
                    }
                    if (!same) continue;
                    deleteThisConstraint = uc;
                }
            }
            if (deleteThisConstraint == null) continue;
            ((RelationalTable)child).removeUniqueConstraint(deleteThisConstraint);
        }
    }

    private String translateNamespacedOptionName(String namespacedPropName) {
        String designerNs = null;
        if (this.isUriNamespaced(namespacedPropName)) {
            String propNsUri = this.getExtensionPropertyNsUri(namespacedPropName);
            designerNs = this.translateTeiidNsUriToDesignerNSPrefix(propNsUri);
        } else if (this.isPrefixNamespaced(namespacedPropName)) {
            String propNsPrefix = this.getExtensionPropertyNsPrefix(namespacedPropName);
            designerNs = this.translateTeiidNSPrefixToDesignerNSPrefix(propNsPrefix);
        }
        if (designerNs != null) {
            String propName = this.getExtensionPropertyName(namespacedPropName);
            if (designerNs.equals(NS_DESIGNER_SALESFORCE) && propName.equals(SF_PROPNAME_CALCULATED_BAD)) {
                propName = SF_PROPNAME_CALCULATED_GOOD;
            }
            return String.valueOf(designerNs) + ':' + propName;
        }
        return namespacedPropName;
    }

    private String getExtensionPropertyNsPrefix(String propName) {
        int index;
        String namespace = null;
        if (!CoreStringUtil.isEmpty((String)propName) && this.isPrefixNamespaced(propName) && (index = propName.indexOf(58)) != -1) {
            namespace = propName.substring(0, index);
        }
        return namespace;
    }

    private String getExtensionPropertyNsUri(String propName) {
        String name = null;
        if (propName != null) {
            propName.trim();
            if (this.isUriNamespaced(propName)) {
                int index1 = propName.indexOf(123);
                int index2 = propName.indexOf(125);
                name = propName.substring(index1 + 1, index2);
            }
        }
        return name;
    }

    private String getExtensionPropertyName(String namespacedPropName) {
        String name = namespacedPropName;
        if (this.isPrefixNamespaced(namespacedPropName)) {
            int index = namespacedPropName.indexOf(58);
            name = namespacedPropName.substring(index + 1);
        } else if (this.isUriNamespaced(namespacedPropName)) {
            int index = namespacedPropName.indexOf(125);
            name = namespacedPropName.substring(index + 1);
        }
        return name;
    }

    private boolean isPrefixNamespaced(String propName) {
        boolean isPrefixNamespaced = false;
        if (!CoreStringUtil.isEmpty((String)propName) && !this.hasOpenCloseBraces(propName) && propName.indexOf(58) != -1) {
            isPrefixNamespaced = true;
        }
        return isPrefixNamespaced;
    }

    private boolean isUriNamespaced(String propName) {
        boolean isUriNamespaced = false;
        if (!CoreStringUtil.isEmpty((String)propName) && this.hasOpenCloseBraces(propName)) {
            isUriNamespaced = true;
        }
        return isUriNamespaced;
    }

    private boolean hasOpenCloseBraces(String propName) {
        boolean hasBoth = false;
        if (!CoreStringUtil.isEmpty((String)propName) && propName.indexOf(123) != -1 && propName.indexOf(125) != -1) {
            hasBoth = true;
        }
        return hasBoth;
    }

    private String translateTeiidNSPrefixToDesignerNSPrefix(String teiidNamespace) {
        String designerNS = teiidNamespace;
        if (NS_TEIID_ODATA.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_ODATA;
        } else if (NS_TEIID_RELATIONAL.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_RELATIONAL;
        } else if (NS_TEIID_WEBSERVICE.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_WEBSERVICE;
        } else if (NS_TEIID_SALESFORCE.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_SALESFORCE;
        } else if (NS_TEIID_MONGO.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_MONGO;
        } else if (NS_TEIID_ACCUMULO.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_ACCUMULO;
        } else if (NS_TEIID_EXCEL.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_EXCEL;
        } else if (NS_TEIID_JPA.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_JPA;
        }
        return designerNS;
    }

    private String translateTeiidNsUriToDesignerNSPrefix(String teiidNsUri) {
        String designerNsPrefix = null;
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        Collection meds = registry.getAllDefinitions();
        for (ModelExtensionDefinition med : meds) {
            String designerMedNsUri = med.getNamespaceUri();
            String designerMedNsPrefix = med.getNamespacePrefix();
            if (CoreStringUtil.isEmpty((String)designerMedNsUri) || !designerMedNsUri.equals(teiidNsUri)) continue;
            designerNsPrefix = designerMedNsPrefix;
            break;
        }
        return designerNsPrefix;
    }

    public Set<MaterializedTableReferenceInfo> getMaterializedTableReferences() {
        HashSet<MaterializedTableReferenceInfo> matTableReferences = new HashSet<MaterializedTableReferenceInfo>();
        for (AstNode tableRefNode : this.deferredMatViewReferences.keySet()) {
            String optionName = tableRefNode.getName();
            String fullTableName = (String)tableRefNode.getProperty("ddl:value");
            int modelNameLength = fullTableName.indexOf(46);
            int fullTableNameLength = fullTableName.length();
            String sourceModelName = fullTableName.substring(0, modelNameLength);
            String tableName = fullTableName.substring(modelNameLength + 1, fullTableNameLength);
            if (CoreStringUtil.isEmpty((String)tableName) || !optionName.equalsIgnoreCase("MATERIALIZED_TABLE")) continue;
            RelationalViewTable table = this.deferredMatViewReferences.get(tableRefNode);
            matTableReferences.add(new MaterializedTableReferenceInfo(this.getImporterManager().getModelName(), sourceModelName, table.getName(), tableName));
        }
        return matTableReferences;
    }

    static interface TYPES_UPPER {
        public static final String ARRAY = "ARRAY";
        public static final String BIGDECIMAL = "BIGDECIMAL";
        public static final String BINARY = "BINARY";
        public static final String BIT = "BIT";
        public static final String BLOB = "BLOB";
        public static final String BYTE = "BYTE";
        public static final String CHAR = "CHAR";
        public static final String CLOB = "CLOB";
        public static final String DATE = "DATE";
        public static final String DATETIME = "DATETIME";
        public static final String DECIMAL = "DECIMAL";
        public static final String DOUBLE = "DOUBLE";
        public static final String FLOAT = "FLOAT";
        public static final String INT = "INT";
        public static final String INTEGER = "INTEGER";
        public static final String BIGINTEGER = "BIGINTEGER";
        public static final String LONGVARBINARY = "LONGVARBINARY";
        public static final String LONGVARCHAR = "LONGVARCHAR";
        public static final String NCHAR = "NCHAR";
        public static final String NUMERIC = "NUMERIC";
        public static final String OBJECT = "OBJECT";
        public static final String REAL = "REAL";
        public static final String REF = "REF";
        public static final String SHORT = "SHORT";
        public static final String STRING = "STRING";
        public static final String SMALLINT = "SMALLINT";
        public static final String TIMES = "TIME";
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String TINYINT = "TINYINT";
        public static final String VARBINARY = "VARBINARY";
        public static final String VARCHAR = "VARCHAR";
        public static final String IMAGE = "IMAGE";
        public static final String TEXT = "TEXT";
        public static final String XML = "xml";
    }

    private class TeiidInfo
    extends TeiidStandardImporter.Info {
        public TeiidInfo(AstNode node, RelationalModel model) throws Exception {
            super(node, model);
        }
    }
}

