/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.StudioPagedResultsControl;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifVersionLine;

public class ExportLdifRunnable
implements StudioConnectionRunnableWithProgress {
    private String exportLdifFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;

    public ExportLdifRunnable(String exportLdifFilename, IBrowserConnection browserConnection, SearchParameter searchParameter) {
        this.exportLdifFilename = exportLdifFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__export_ldif_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportLdifFilename));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_ldif_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_ldif_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            FileWriter fileWriter = new FileWriter(this.exportLdifFilename);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int count = 0;
            ExportLdifRunnable.export(this.browserConnection, this.searchParameter, bufferedWriter, count, monitor);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void export(IBrowserConnection browserConnection, SearchParameter searchParameter, BufferedWriter bufferedWriter, int count, StudioProgressMonitor monitor) throws IOException {
        try {
            JndiLdifEnumeration enumeration = ExportLdifRunnable.search(browserConnection, searchParameter, monitor);
            LdifFormatParameters ldifFormatParameters = Utils.getLdifFormatParameters();
            if (BrowserCorePlugin.getDefault().getPluginPreferences().getBoolean("ldifIncludeVersionLine")) {
                LdifVersionLine ldifVersionLine = LdifVersionLine.create();
                String ldifVersionLineString = ldifVersionLine.toFormattedString(ldifFormatParameters);
                bufferedWriter.write(ldifVersionLineString);
                LdifSepLine ldifSepLine = LdifSepLine.create();
                String ldifSepLineString = ldifSepLine.toFormattedString(ldifFormatParameters);
                bufferedWriter.write(ldifSepLineString);
            }
            while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                LdifContainer container = enumeration.next();
                if (!(container instanceof LdifContentRecord)) continue;
                LdifContentRecord record = (LdifContentRecord)container;
                LdifDnLine dnLine = record.getDnLine();
                LdifAttrValLine[] attrValLines = record.getAttrVals();
                LdifSepLine sepLine = record.getSepLine();
                DummyEntry entry = ModelConverter.ldifContentRecordToEntry(record, browserConnection);
                AttributeComparator comparator = new AttributeComparator(entry);
                Arrays.sort(attrValLines, comparator);
                LdifContentRecord newRecord = new LdifContentRecord(dnLine);
                int i = 0;
                while (i < attrValLines.length) {
                    newRecord.addAttrVal(attrValLines[i]);
                    ++i;
                }
                newRecord.finish(sepLine);
                String s = newRecord.toFormattedString(ldifFormatParameters);
                bufferedWriter.write(s);
                monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
            }
        }
        catch (NamingException ne) {
            int ldapStatusCode = JNDIUtils.getLdapStatusCode(ne);
            if (ldapStatusCode != 3 && ldapStatusCode != 4 && ldapStatusCode != 11) {
                monitor.reportError((Exception)ne);
            }
        }
        catch (LdapInvalidDnException e) {
            monitor.reportError((Exception)((Object)e));
        }
    }

    static JndiLdifEnumeration search(IBrowserConnection browserConnection, SearchParameter parameter, StudioProgressMonitor monitor) {
        StudioNamingEnumeration result = SearchRunnable.search(browserConnection, parameter, monitor);
        return new JndiLdifEnumeration(result, browserConnection, parameter, monitor);
    }

    static class JndiLdifEnumeration
    implements LdifEnumeration {
        private StudioNamingEnumeration enumeration;
        private IBrowserConnection browserConnection;
        private SearchParameter parameter;
        private StudioProgressMonitor monitor;

        public JndiLdifEnumeration(StudioNamingEnumeration enumeration, IBrowserConnection browserConnection, SearchParameter parameter, StudioProgressMonitor monitor) {
            this.enumeration = enumeration;
            this.browserConnection = browserConnection;
            this.parameter = parameter;
            this.monitor = monitor;
        }

        public boolean hasNext() throws NamingException {
            if (this.enumeration != null) {
                if (this.enumeration.hasMore()) {
                    return true;
                }
                Control[] jndiControls = this.enumeration.getResponseControls();
                if (jndiControls != null) {
                    Control[] controlArray = jndiControls;
                    int n = jndiControls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PagedResultsResponseControl prrc;
                        byte[] cookie;
                        Control jndiControl = controlArray[n2];
                        if (jndiControl instanceof PagedResultsResponseControl && (cookie = (prrc = (PagedResultsResponseControl)jndiControl).getCookie()) != null) {
                            for (StudioControl studioControl : this.parameter.getControls()) {
                                if (!(studioControl instanceof StudioPagedResultsControl)) continue;
                                StudioPagedResultsControl sprc = (StudioPagedResultsControl)studioControl;
                                sprc.setCookie(cookie);
                            }
                            this.enumeration = SearchRunnable.search(this.browserConnection, this.parameter, this.monitor);
                            return this.enumeration != null && this.enumeration.hasMore();
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }

        public LdifContainer next() throws NamingException, LdapInvalidDnException {
            SearchResult sr = (SearchResult)this.enumeration.next();
            Dn dn = JNDIUtils.getDn(sr);
            LdifContentRecord record = LdifContentRecord.create((String)dn.getName());
            NamingEnumeration<? extends Attribute> attributeEnumeration = sr.getAttributes().getAll();
            while (attributeEnumeration.hasMore()) {
                Attribute attribute = attributeEnumeration.next();
                String attributeName = attribute.getID();
                NamingEnumeration<?> valueEnumeration = attribute.getAll();
                while (valueEnumeration.hasMore()) {
                    Object o = valueEnumeration.next();
                    if (o instanceof String) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)((String)o)));
                    }
                    if (!(o instanceof byte[])) continue;
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])((byte[])o)));
                }
            }
            record.finish(LdifSepLine.create());
            return record;
        }
    }
}

