/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportCsvRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.eclipse.core.runtime.Preferences;
import org.odftoolkit.odfdom.type.ValueType;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;

public class ExportOdfRunnable
implements StudioConnectionRunnableWithProgress {
    public static final int MAX_COUNT_LIMIT = 65000;
    private String exportOdfFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private boolean exportDn;

    public ExportOdfRunnable(String exportOdfFilename, IBrowserConnection browserConnection, SearchParameter searchParameter, boolean exportDn) {
        this.exportOdfFilename = exportOdfFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
        this.exportDn = exportDn;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__export_odf_name;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportOdfFilename)};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_odf_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_odf_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        String valueDelimiter = coreStore.getString("formatOdfValueDelimiter");
        int binaryEncoding = coreStore.getInt("formatOdfBinaryEncoding");
        try {
            SpreadsheetDocument doc = SpreadsheetDocument.newSpreadsheetDocument();
            doc.removeSheet(0);
            Table table = doc.appendSheet("Export");
            Row headerRow = table.appendRow();
            LinkedHashMap<String, Short> attributeNameMap = new LinkedHashMap<String, Short>();
            if (this.exportDn) {
                short cellNum = 0;
                attributeNameMap.put("dn", new Short(cellNum));
                Cell cell = headerRow.getCellByIndex((int)cellNum);
                cell.setValueType(ValueType.STRING.name());
                cell.setStringValue("dn");
            }
            if (this.searchParameter.getCountLimit() < 1 || this.searchParameter.getCountLimit() > 65000) {
                this.searchParameter.setCountLimit(65000);
            }
            int count = 0;
            ExportOdfRunnable.exportToOdf(this.browserConnection, this.searchParameter, table, headerRow, count, monitor, attributeNameMap, valueDelimiter, binaryEncoding, this.exportDn);
            table.removeRowsByIndex(0, 2);
            doc.save(this.exportOdfFilename);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void exportToOdf(IBrowserConnection browserConnection, SearchParameter searchParameter, Table table, Row headerRow, int count, StudioProgressMonitor monitor, LinkedHashMap<String, Short> attributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) throws IOException {
        try {
            ExportLdifRunnable.JndiLdifEnumeration enumeration = ExportLdifRunnable.search(browserConnection, searchParameter, monitor);
            while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                LdifContainer container = enumeration.next();
                if (!(container instanceof LdifContentRecord)) continue;
                LdifContentRecord record = (LdifContentRecord)container;
                ExportOdfRunnable.recordToOdfRow(browserConnection, record, table, headerRow, attributeNameMap, valueDelimiter, binaryEncoding, exportDn);
                monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
            }
        }
        catch (NamingException ne) {
            int ldapStatusCode = JNDIUtils.getLdapStatusCode(ne);
            if (ldapStatusCode != 3 && ldapStatusCode != 4 && ldapStatusCode != 11) {
                monitor.reportError((Exception)ne);
            }
        }
        catch (LdapInvalidDnException e) {
            monitor.reportError((Exception)((Object)e));
        }
    }

    private static void recordToOdfRow(IBrowserConnection browserConnection, LdifContentRecord record, Table table, Row headerRow, Map<String, Short> headerRowAttributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) {
        Map<String, String> attributeMap = ExportCsvRunnable.getAttributeMap(null, record, valueDelimiter, "UTF-16", binaryEncoding);
        Row row = table.appendRow();
        if (exportDn) {
            Cell cell = row.getCellByIndex(0);
            cell.setValueType(ValueType.STRING.name());
            cell.setStringValue(record.getDnLine().getValueAsString());
        }
        for (String attributeName : attributeMap.keySet()) {
            Cell cell;
            short cellNum;
            String value = attributeMap.get(attributeName);
            if (value == null) {
                value = "";
            }
            if (!headerRowAttributeNameMap.containsKey(attributeName)) {
                cellNum = (short)headerRowAttributeNameMap.size();
                headerRowAttributeNameMap.put(attributeName, new Short(cellNum));
                cell = headerRow.getCellByIndex((int)cellNum);
                cell.setValueType(ValueType.STRING.name());
                cell.setStringValue(attributeName);
            }
            if (!headerRowAttributeNameMap.containsKey(attributeName)) continue;
            cellNum = headerRowAttributeNameMap.get(attributeName);
            cell = row.getCellByIndex((int)cellNum);
            cell.setValueType(ValueType.STRING.name());
            cell.setStringValue(value);
        }
    }
}

