/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.studio.connection.core.ConnectionServerType;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;

public class ServerTypeDetector {
    public static ConnectionServerType detectServerType(IRootDSE rootDSE) {
        ConnectionServerType serverType = ConnectionServerType.UNKNOWN;
        IAttribute vnAttribute = rootDSE.getAttribute("vendorName");
        IAttribute vvAttribute = rootDSE.getAttribute("vendorVersion");
        if (vnAttribute != null && vnAttribute.getStringValues().length > 0 && vvAttribute != null && vvAttribute.getStringValues().length > 0) {
            String vendorName = vnAttribute.getStringValues()[0];
            String vendorVersion = vvAttribute.getStringValues()[0];
            serverType = ServerTypeDetector.detectApacheDS(vendorName);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectIbm(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectNetscape(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectNovell(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
            serverType = ServerTypeDetector.detectSun(vendorName, vendorVersion);
            if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
                return serverType;
            }
        }
        if (!ConnectionServerType.UNKNOWN.equals((Object)(serverType = ServerTypeDetector.detectMicrosoft(rootDSE)))) {
            return serverType;
        }
        serverType = ServerTypeDetector.detectOpenLdap(rootDSE);
        if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
            return serverType;
        }
        serverType = ServerTypeDetector.detectSiemens(rootDSE);
        if (!ConnectionServerType.UNKNOWN.equals((Object)serverType)) {
            return serverType;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectApacheDS(String vendorName) {
        if (vendorName.indexOf("Apache Software Foundation") > -1) {
            return ConnectionServerType.APACHEDS;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectIbm(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("International Business Machines") > -1) {
            String[] tdsVersions;
            String[] idsVersions;
            String[] iswVersions;
            String[] stringArray = iswVersions = new String[]{"3.2", "3.2.1", "3.2.2"};
            int n = iswVersions.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (vendorVersion.indexOf(version) > -1) {
                    return ConnectionServerType.IBM_SECUREWAY_DIRECTORY;
                }
                ++n2;
            }
            String[] stringArray2 = idsVersions = new String[]{"4.1", "5.1"};
            int n3 = idsVersions.length;
            n = 0;
            while (n < n3) {
                String version = stringArray2[n];
                if (vendorVersion.indexOf(version) > -1) {
                    return ConnectionServerType.IBM_DIRECTORY_SERVER;
                }
                ++n;
            }
            String[] stringArray3 = tdsVersions = new String[]{"5.2", "6.0", "6.1", "6.2"};
            int n4 = tdsVersions.length;
            n3 = 0;
            while (n3 < n4) {
                String version = stringArray3[n3];
                if (vendorVersion.indexOf(version) > -1) {
                    return ConnectionServerType.IBM_TIVOLI_DIRECTORY_SERVER;
                }
                ++n3;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectMicrosoft(IRootDSE rootDSE) {
        IAttribute rdncAttribute = rootDSE.getAttribute("rootDomainNamingContext");
        if (rdncAttribute != null) {
            IAttribute ffAttribute = rootDSE.getAttribute("forestFunctionality");
            if (ffAttribute != null) {
                return ConnectionServerType.MICROSOFT_ACTIVE_DIRECTORY_2003;
            }
            return ConnectionServerType.MICROSOFT_ACTIVE_DIRECTORY_2000;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectNetscape(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Netscape") > -1 || vendorVersion.indexOf("Netscape") > -1) {
            return ConnectionServerType.NETSCAPE;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectNovell(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Novell") > -1 || vendorVersion.indexOf("eDirectory") > -1) {
            return ConnectionServerType.NOVELL;
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectOpenLdap(IRootDSE rootDSE) {
        IAttribute ocAttribute = rootDSE.getAttribute("objectClass");
        if (ocAttribute != null) {
            int i = 0;
            while (i < ocAttribute.getStringValues().length) {
                if ("OpenLDAProotDSE".equals(ocAttribute.getStringValues()[i])) {
                    IAttribute sfAttribute;
                    IAttribute seAttribute;
                    IAttribute ccAttribute = rootDSE.getAttribute("configContext");
                    if (ccAttribute != null) {
                        return ConnectionServerType.OPENLDAP_2_3;
                    }
                    IAttribute scAttribute = rootDSE.getAttribute("supportedControl");
                    if (scAttribute != null) {
                        int sci = 0;
                        while (sci < scAttribute.getStringValues().length) {
                            if ("2.16.840.1.113730.3.4.18".equals(scAttribute.getStringValues()[sci])) {
                                return ConnectionServerType.OPENLDAP_2_2;
                            }
                            ++sci;
                        }
                    }
                    if ((seAttribute = rootDSE.getAttribute("supportedExtension")) != null) {
                        int sei = 0;
                        while (sei < seAttribute.getStringValues().length) {
                            if ("1.3.6.1.4.1.4203.1.11.3".equals(seAttribute.getStringValues()[sei])) {
                                return ConnectionServerType.OPENLDAP_2_1;
                            }
                            ++sei;
                        }
                    }
                    if ((sfAttribute = rootDSE.getAttribute("supportedFeatures")) != null) {
                        int sfi = 0;
                        while (sfi < sfAttribute.getStringValues().length) {
                            if ("1.3.6.1.4.1.4203.1.5.4".equals(sfAttribute.getStringValues()[sfi])) {
                                return ConnectionServerType.OPENLDAP_2_0;
                            }
                            ++sfi;
                        }
                    }
                    return ConnectionServerType.OPENLDAP;
                }
                ++i;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectSiemens(IRootDSE rootDSE) {
        IAttribute ssseAttribute = rootDSE.getAttribute("subSchemaSubentry");
        if (ssseAttribute != null) {
            int i = 0;
            while (i < ssseAttribute.getStringValues().length) {
                if ("cn=LDAPGlobalSchemaSubentry".equals(ssseAttribute.getStringValues()[i])) {
                    return ConnectionServerType.SIEMENS_DIRX;
                }
                ++i;
            }
        }
        return ConnectionServerType.UNKNOWN;
    }

    private static ConnectionServerType detectSun(String vendorName, String vendorVersion) {
        if (vendorName.indexOf("Sun") > -1 || vendorVersion.indexOf("Sun") > -1) {
            return ConnectionServerType.SUN_DIRECTORY_SERVER;
        }
        return ConnectionServerType.UNKNOWN;
    }
}

