/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;

public final class RootDSE
extends BaseDNEntry
implements IRootDSE {
    private static final long serialVersionUID = -8445018787232919754L;

    protected RootDSE() {
    }

    public RootDSE(IBrowserConnection browserConnection) {
        super(Dn.EMPTY_DN, browserConnection);
    }

    @Override
    public IEntry getParententry() {
        return null;
    }

    @Override
    public String[] getSupportedExtensions() {
        return this.getAttributeValues("supportedExtension");
    }

    @Override
    public String[] getSupportedControls() {
        return this.getAttributeValues("supportedControl");
    }

    @Override
    public String[] getSupportedFeatures() {
        return this.getAttributeValues("supportedFeatures");
    }

    private String[] getAttributeValues(String attributeDescription) {
        IAttribute supportedFeaturesAttr = this.getAttribute(attributeDescription);
        if (supportedFeaturesAttr != null) {
            Object[] stringValues = supportedFeaturesAttr.getStringValues();
            Arrays.sort(stringValues);
            return stringValues;
        }
        return new String[0];
    }

    @Override
    public boolean isSubentry() {
        return false;
    }

    @Override
    public boolean isControlSupported(String oid) {
        String[] supportedControls = this.getSupportedControls();
        return Arrays.asList(supportedControls).contains(oid);
    }

    @Override
    public boolean isFeatureSupported(String oid) {
        String[] supportedFeatures = this.getSupportedFeatures();
        return Arrays.asList(supportedFeatures).contains(oid);
    }
}

