/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchContinuation;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class Search
implements ISearch {
    private static final long serialVersionUID = -3482673086666351174L;
    protected IBrowserConnection connection;
    protected ISearchResult[] searchResults;
    protected SearchParameter searchParameter;
    protected boolean countLimitExceeded;
    protected StudioConnectionBulkRunnableWithProgress nextSearchRunnable;
    protected StudioConnectionBulkRunnableWithProgress topSearchRunnable;
    protected SearchContinuation[] searchContinuations;

    public Search() {
        this(new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date()), null, EMPTY_SEARCH_BASE, "(objectClass=*)", NO_ATTRIBUTES, SearchScope.ONELEVEL, 0, 0, Connection.AliasDereferencingMethod.ALWAYS, Connection.ReferralHandlingMethod.FOLLOW, false, null);
    }

    public Search(IBrowserConnection conn, SearchParameter searchParameter) {
        this.connection = conn;
        this.searchResults = null;
        this.searchParameter = searchParameter;
        this.countLimitExceeded = false;
        this.nextSearchRunnable = null;
        this.searchContinuations = null;
    }

    public Search(String searchName, IBrowserConnection conn, Dn searchBase, String filter, String[] returningAttributes, SearchScope scope, int countLimit, int timeLimit, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Connection.ReferralHandlingMethod referralsHandlingMethod, boolean initHasChildrenFlag, List<StudioControl> controls) {
        this.connection = conn;
        this.searchResults = null;
        this.countLimitExceeded = false;
        this.nextSearchRunnable = null;
        this.searchParameter = new SearchParameter();
        this.searchParameter.setName(searchName);
        this.searchParameter.setSearchBase(searchBase);
        this.searchParameter.setFilter(filter);
        this.searchParameter.setReturningAttributes(returningAttributes);
        this.searchParameter.setScope(scope);
        this.searchParameter.setTimeLimit(timeLimit);
        this.searchParameter.setCountLimit(countLimit);
        this.searchParameter.setAliasesDereferencingMethod(aliasesDereferencingMethod);
        this.searchParameter.setReferralsHandlingMethod(referralsHandlingMethod);
        this.searchParameter.setInitHasChildrenFlag(initHasChildrenFlag);
        if (controls != null) {
            this.searchParameter.getControls().addAll(controls);
        }
    }

    @Override
    public LdapUrl getUrl() {
        return Utils.getLdapURL(this);
    }

    protected void fireSearchUpdated(SearchUpdateEvent.EventDetail detail) {
        if (this.getName() != null && !"".equals(this.getName())) {
            EventRegistry.fireSearchUpdated(new SearchUpdateEvent(this, detail), this);
        }
    }

    @Override
    public boolean isInitHasChildrenFlag() {
        return this.searchParameter.isInitHasChildrenFlag();
    }

    @Override
    public List<StudioControl> getControls() {
        return this.searchParameter.getControls();
    }

    @Override
    public List<StudioControl> getResponseControls() {
        return this.searchParameter.getResponseControls();
    }

    @Override
    public int getCountLimit() {
        return this.searchParameter.getCountLimit();
    }

    @Override
    public void setCountLimit(int countLimit) {
        this.searchParameter.setCountLimit(countLimit);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public String getFilter() {
        return this.searchParameter.getFilter();
    }

    @Override
    public void setFilter(String filter) {
        this.searchParameter.setFilter(filter);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public String[] getReturningAttributes() {
        return this.searchParameter.getReturningAttributes();
    }

    @Override
    public void setReturningAttributes(String[] returningAttributes) {
        this.searchParameter.setReturningAttributes(returningAttributes);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public SearchScope getScope() {
        return this.searchParameter.getScope();
    }

    @Override
    public void setScope(SearchScope scope) {
        this.searchParameter.setScope(scope);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public Connection.AliasDereferencingMethod getAliasesDereferencingMethod() {
        return this.searchParameter.getAliasesDereferencingMethod();
    }

    @Override
    public void setAliasesDereferencingMethod(Connection.AliasDereferencingMethod aliasesDereferencingMethod) {
        this.searchParameter.setAliasesDereferencingMethod(aliasesDereferencingMethod);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public Connection.ReferralHandlingMethod getReferralsHandlingMethod() {
        return this.searchParameter.getReferralsHandlingMethod();
    }

    @Override
    public void setReferralsHandlingMethod(Connection.ReferralHandlingMethod referralsHandlingMethod) {
        this.searchParameter.setReferralsHandlingMethod(referralsHandlingMethod);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public Dn getSearchBase() {
        return this.searchParameter.getSearchBase();
    }

    @Override
    public void setSearchBase(Dn searchBase) {
        this.searchParameter.setSearchBase(searchBase);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public int getTimeLimit() {
        return this.searchParameter.getTimeLimit();
    }

    @Override
    public void setTimeLimit(int timeLimit) {
        this.searchParameter.setTimeLimit(timeLimit);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public String getName() {
        return this.searchParameter.getName();
    }

    @Override
    public void setName(String searchName) {
        this.searchParameter.setName(searchName);
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_RENAMED);
    }

    @Override
    public ISearchResult[] getSearchResults() {
        return this.searchResults;
    }

    @Override
    public void setSearchResults(ISearchResult[] searchResults) {
        this.searchResults = searchResults;
        if (searchResults != null && this.getName() != null) {
            this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PERFORMED);
        }
    }

    @Override
    public boolean isCountLimitExceeded() {
        return this.countLimitExceeded;
    }

    @Override
    public void setCountLimitExceeded(boolean countLimitExceeded) {
        this.countLimitExceeded = countLimitExceeded;
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PERFORMED);
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        return this.connection;
    }

    @Override
    public void setBrowserConnection(IBrowserConnection connection) {
        this.connection = connection;
        this.searchParameter.setCountLimit(connection.getCountLimit());
        this.searchParameter.setTimeLimit(connection.getTimeLimit());
        this.searchParameter.setAliasesDereferencingMethod(connection.getAliasesDereferencingMethod());
        this.searchParameter.setReferralsHandlingMethod(connection.getReferralsHandlingMethod());
        this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PARAMETER_UPDATED);
    }

    @Override
    public StudioConnectionBulkRunnableWithProgress getNextSearchRunnable() {
        return this.nextSearchRunnable;
    }

    @Override
    public void setNextPageSearchRunnable(StudioConnectionBulkRunnableWithProgress nextSearchRunnable) {
        this.nextSearchRunnable = nextSearchRunnable;
    }

    @Override
    public StudioConnectionBulkRunnableWithProgress getTopSearchRunnable() {
        return this.topSearchRunnable;
    }

    @Override
    public void setTopPageSearchRunnable(StudioConnectionBulkRunnableWithProgress topSearchRunnable) {
        this.topSearchRunnable = topSearchRunnable;
    }

    @Override
    public SearchContinuation[] getSearchContinuations() {
        return this.searchContinuations;
    }

    @Override
    public void setSearchContinuations(SearchContinuation[] searchContinuations) {
        this.searchContinuations = searchContinuations;
        if (searchContinuations != null && this.getName() != null) {
            this.fireSearchUpdated(SearchUpdateEvent.EventDetail.SEARCH_PERFORMED);
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getBrowserConnection() + ")";
    }

    @Override
    public Object clone() {
        return new Search(this.getName(), this.getBrowserConnection(), this.getSearchBase(), this.getFilter(), this.getReturningAttributes(), this.getScope(), this.getCountLimit(), this.getTimeLimit(), this.getAliasesDereferencingMethod(), this.getReferralsHandlingMethod(), this.isInitHasChildrenFlag(), this.getControls());
    }

    @Override
    public SearchParameter getSearchParameter() {
        return this.searchParameter;
    }

    @Override
    public void setSearchParameter(SearchParameter searchParameter) {
        this.searchParameter = searchParameter;
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.getBrowserConnection();
        }
        if (clazz.isAssignableFrom(ISearch.class)) {
            return this;
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.searchParameter == null || this.searchParameter.getName() == null ? 0 : this.searchParameter.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Search)) {
            return false;
        }
        Search other = (Search)obj;
        if (this.connection == null ? other.connection != null : !this.connection.equals(other.connection)) {
            return false;
        }
        return !(this.searchParameter == null || this.searchParameter.getName() == null ? other.searchParameter != null && other.searchParameter.getName() != null : !this.searchParameter.getName().equals(other.searchParameter.getName()));
    }
}

