/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueMultiModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;

public class CompoundModification {
    public void renameValues(IValue[] oldValues, String newAttributeDescription) {
        if (ArrayUtils.isEmpty((Object[])oldValues)) {
            throw new IllegalArgumentException("Expected non-null and non-empty values array.");
        }
        if (StringUtils.isEmpty((String)newAttributeDescription)) {
            throw new IllegalArgumentException("Expected non-null and non-empty attribute description.");
        }
        if (newAttributeDescription != null && !"".equals(newAttributeDescription) && !newAttributeDescription.equals(oldValues[0].getAttribute().getDescription())) {
            ValueRenamedEvent event = null;
            try {
                EventRegistry.suspendEventFiringInCurrentThread();
                IValue[] iValueArray = oldValues;
                int n = oldValues.length;
                int n2 = 0;
                while (n2 < n) {
                    IValue oldValue = iValueArray[n2];
                    if (!newAttributeDescription.equals(oldValue.getAttribute().getDescription())) {
                        IAttribute attribute;
                        IAttribute oldAttribute = oldValue.getAttribute();
                        IEntry entry = oldAttribute.getEntry();
                        Value newValue = null;
                        oldAttribute.deleteValue(oldValue);
                        if (oldAttribute.getValueSize() == 0) {
                            entry.deleteAttribute(oldAttribute);
                        }
                        if ((attribute = entry.getAttribute(newAttributeDescription)) == null) {
                            attribute = new Attribute(entry, newAttributeDescription);
                            entry.addAttribute(attribute);
                        }
                        newValue = new Value(attribute, oldValue.getRawValue());
                        attribute.addValue(newValue);
                        if (event == null) {
                            event = new ValueRenamedEvent(entry.getBrowserConnection(), entry, oldValue, newValue);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                EventRegistry.resumeEventFiringInCurrentThread();
            }
            EventRegistry.fireEntryUpdated(event, this);
        }
    }

    public void deleteValues(Collection<IValue> values) {
        if (CollectionUtils.isEmpty(values)) {
            throw new IllegalArgumentException("Expected non-null and non-empty values collection.");
        }
        ValueDeletedEvent event = null;
        try {
            EventRegistry.suspendEventFiringInCurrentThread();
            for (IValue value : values) {
                IAttribute attribute = value.getAttribute();
                IEntry entry = attribute.getEntry();
                attribute.deleteValue(value);
                if (event == null) {
                    event = new ValueDeletedEvent(entry.getBrowserConnection(), entry, attribute, value);
                }
                if (attribute.getValueSize() != 0) continue;
                attribute.getEntry().deleteAttribute(attribute);
            }
        }
        finally {
            EventRegistry.resumeEventFiringInCurrentThread();
        }
        EventRegistry.fireEntryUpdated(event, this);
    }

    public void modifyValue(IValue oldValue, Object newRawValue) {
        Object newValue;
        if (oldValue == null || newRawValue == null) {
            throw new IllegalArgumentException("Expected non-null value.");
        }
        IAttribute attribute = oldValue.getAttribute();
        boolean modify = false;
        if (oldValue != null && newRawValue != null && newRawValue instanceof byte[]) {
            newValue = (byte[])newRawValue;
            if (!Utils.equals(oldValue.getBinaryValue(), newValue)) {
                modify = true;
            }
        } else if (oldValue != null && newRawValue != null && newRawValue instanceof String) {
            newValue = (String)newRawValue;
            if (!oldValue.getStringValue().equals(newValue)) {
                modify = true;
            }
        }
        if (modify) {
            if (oldValue.isEmpty()) {
                EventRegistry.suspendEventFiringInCurrentThread();
                attribute.deleteEmptyValue();
                EventRegistry.resumeEventFiringInCurrentThread();
                Value value = new Value(attribute, newRawValue);
                attribute.addValue(value);
            } else {
                newValue = new Value(attribute, newRawValue);
                attribute.modifyValue(oldValue, (IValue)newValue);
            }
        }
    }

    public void createValue(IEntry entry, String attributeDescription, Object newRawValue) {
        if (entry == null) {
            throw new IllegalArgumentException("Expected non-null entry.");
        }
        if (StringUtils.isEmpty((String)attributeDescription)) {
            throw new IllegalArgumentException("Expected non-null and non-empty attribute description.");
        }
        if (newRawValue == null) {
            throw new IllegalArgumentException("Expected non-null value.");
        }
        IAttribute attribute = entry.getAttribute(attributeDescription);
        if (attribute == null) {
            EventRegistry.suspendEventFiringInCurrentThread();
            attribute = new Attribute(entry, attributeDescription);
            entry.addAttribute(attribute);
            EventRegistry.resumeEventFiringInCurrentThread();
        }
        Value value = new Value(attribute, newRawValue);
        attribute.addValue(value);
    }

    public void createValues(IEntry entry, IValue ... values) {
        if (entry == null) {
            throw new IllegalArgumentException("Expected non-null entry.");
        }
        if (ArrayUtils.isEmpty((Object[])values)) {
            throw new IllegalArgumentException("Expected non-null and non-empty values array.");
        }
        ValueAddedEvent event = null;
        EventRegistry.suspendEventFiringInCurrentThread();
        IValue[] iValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IValue value = iValueArray[n2];
            String attributeDescription = value.getAttribute().getDescription();
            IAttribute attribute = entry.getAttribute(attributeDescription);
            if (attribute == null) {
                attribute = new Attribute(entry, attributeDescription);
                entry.addAttribute(attribute);
            }
            Value newValue = new Value(attribute, value.getRawValue());
            attribute.addValue(newValue);
            if (event == null) {
                event = new ValueAddedEvent(entry.getBrowserConnection(), entry, attribute, newValue);
            }
            ++n2;
        }
        EventRegistry.resumeEventFiringInCurrentThread();
        EventRegistry.fireEntryUpdated(event, this);
    }

    public void replaceAttributes(IEntry fromEntry, IEntry toEntry, Object source) {
        IAttribute attribute;
        EventRegistry.suspendEventFiringInCurrentThread();
        IAttribute[] iAttributeArray = toEntry.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            attribute = iAttributeArray[n2];
            toEntry.deleteAttribute(attribute);
            ++n2;
        }
        iAttributeArray = fromEntry.getAttributes();
        n = iAttributeArray.length;
        n2 = 0;
        while (n2 < n) {
            attribute = iAttributeArray[n2];
            Attribute newAttribute = new Attribute(toEntry, attribute.getDescription());
            IValue[] iValueArray = attribute.getValues();
            int n3 = iValueArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IValue value = iValueArray[n4];
                Value newValue = new Value(newAttribute, value.getRawValue());
                newAttribute.addValue(newValue);
                ++n4;
            }
            toEntry.addAttribute(newAttribute);
            ++n2;
        }
        EventRegistry.resumeEventFiringInCurrentThread();
        ValueMultiModificationEvent event = new ValueMultiModificationEvent(toEntry.getBrowserConnection(), toEntry);
        EventRegistry.fireEntryUpdated(event, source);
    }

    public IEntry cloneEntry(IEntry entry) {
        try {
            DummyEntry clonedEntry;
            EventRegistry.suspendEventFiringInCurrentThread();
            IBrowserConnection browserConnection = entry.getBrowserConnection();
            LdifContentRecord record = ModelConverter.entryToLdifContentRecord(entry);
            DummyEntry dummyEntry = clonedEntry = ModelConverter.ldifContentRecordToEntry(record, browserConnection);
            return dummyEntry;
        }
        catch (LdapInvalidDnException e) {
            throw new RuntimeException(e);
        }
        finally {
            EventRegistry.resumeEventFiringInCurrentThread();
        }
    }
}

