/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import javax.naming.directory.SearchResult;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;

public class JNDIUtils {
    public static Dn getDn(SearchResult sr) throws LdapInvalidDnException {
        String dn = sr.getNameInNamespace();
        Dn ldapDn = new Dn(new String[]{JNDIUtils.unescapeJndiName(dn)});
        return ldapDn;
    }

    public static String unescapeJndiName(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        name = name.replaceAll("\\\\\\\\\"", "\\\\\"");
        name = name.replaceAll("\\\\2C", "\\\\,");
        name = name.replaceAll("\\\\3B", "\\\\;");
        name = name.replaceAll("\\\\22", "\\\\\"");
        name = name.replaceAll("\\\\3C", "\\\\<");
        name = name.replaceAll("\\\\3E", "\\\\>");
        name = name.replaceAll("\\\\2B", "\\\\+");
        name = name.replaceAll("\\\\5C", "\\\\\\\\");
        return name;
    }

    public static int getLdapStatusCode(Exception exception) {
        int ldapStatusCode = -1;
        String message = exception.getMessage();
        if (message != null && message.startsWith("[LDAP: error code ")) {
            int begin = "[LDAP: error code ".length();
            int end = begin + 2;
            try {
                ldapStatusCode = Integer.parseInt(message.substring(begin, end).trim());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ldapStatusCode;
    }
}

