/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Map;
import org.fusesource.ide.camel.model.service.core.CamelManagerException;
import org.fusesource.ide.camel.model.service.core.CamelSchemaProvider;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class CamelManagerServiceProxy
extends ServiceTracker<ICamelManagerService, ICamelManagerService>
implements ICamelManagerService {
    private String serviceVersion;

    public CamelManagerServiceProxy(BundleContext context, String serviceVersion) throws InvalidSyntaxException {
        super(context, context.createFilter(MessageFormat.format("(&(objectClass={0})(camel.version={1}))", ICamelManagerService.class.getCanonicalName(), serviceVersion)), null);
        this.serviceVersion = serviceVersion;
        this.open();
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    private ICamelManagerService checkedGetService() throws CamelManagerException {
        ICamelManagerService service = (ICamelManagerService)this.getService();
        if (service == null) {
            throw new CamelManagerException("Could not acquire Camel Management service");
        }
        return service;
    }

    @Override
    public CamelModel getCamelModel() {
        CamelModel cm = this.checkedGetService().getCamelModel();
        cm.setCamelVersion(this.serviceVersion);
        return cm;
    }

    @Override
    public CamelSchemaProvider getCamelSchemaProvider() {
        return this.checkedGetService().getCamelSchemaProvider();
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> properties) throws URISyntaxException {
        return this.checkedGetService().createEndpointUri(scheme, properties);
    }

    @Override
    public String createEndpointXml(String scheme, Map<String, String> properties) throws URISyntaxException {
        return this.checkedGetService().createEndpointXml(scheme, properties);
    }

    @Override
    public Map<String, String> getEndpointProperties(String uri) throws URISyntaxException {
        return this.checkedGetService().getEndpointProperties(uri);
    }

    @Override
    public String getEndpointScheme(String uri) {
        return this.checkedGetService().getEndpointScheme(uri);
    }

    @Override
    public String testExpression(String language, String expression) {
        return this.checkedGetService().testExpression(language, expression);
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.checkedGetService().createEndpointUri(scheme, properties, encode);
    }

    @Override
    public String createEndpointXml(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.checkedGetService().createEndpointXml(scheme, properties, encode);
    }

    @Override
    public long durationToMillis(String duration) throws IllegalArgumentException {
        return this.checkedGetService().durationToMillis(duration);
    }
}

