/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.adopters;

import java.io.IOException;
import java.net.URL;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentModel;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormatModel;
import org.fusesource.ide.camel.model.service.core.catalog.eips.EipModel;
import org.fusesource.ide.camel.model.service.core.catalog.languages.LanguageModel;

public abstract class CamelModelLoader {
    protected ComponentModel compModel;
    protected EipModel eipModel;
    protected LanguageModel langModel;
    protected DataFormatModel dfModel;
    private CamelModel cachedModel;

    public CamelModel getCamelModel(URL componentModel, URL eipModel, URL languageModel, URL dataformatModel) throws IOException {
        if (this.cachedModel == null) {
            this.cachedModel = new CamelModel();
        }
        try {
            if (this.compModel == null) {
                this.compModel = this.getComponentModel(componentModel);
                this.cachedModel.setComponentModel(this.compModel);
            }
            if (this.eipModel == null) {
                this.eipModel = this.getEipModel(eipModel);
                this.cachedModel.setEipModel(this.eipModel);
            }
            if (this.langModel == null) {
                this.langModel = this.getLanguageModel(languageModel);
                this.cachedModel.setLanguageModel(this.langModel);
            }
            if (this.dfModel == null) {
                this.dfModel = this.getDataFormatModel(dataformatModel);
                this.cachedModel.setDataformatModel(this.dfModel);
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to generate the Camel Model.", ex);
        }
        return this.cachedModel;
    }

    protected abstract ComponentModel getComponentModel(URL var1) throws IOException;

    protected abstract EipModel getEipModel(URL var1) throws IOException;

    protected abstract LanguageModel getLanguageModel(URL var1) throws IOException;

    protected abstract DataFormatModel getDataFormatModel(URL var1) throws IOException;
}

