/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.camel.model.service.core.CamelServiceManagerUtil;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.osgi.framework.Version;

public class CamelModelFactory {
    private static final Map<String, String> camelVersionToFuseBOMMapping = new HashMap<String, String>();
    private static final String LATEST_BOM_VERSION = "6.3.0.redhat-187";
    private static HashMap<String, CamelModel> supportedCamelModels;

    static {
        camelVersionToFuseBOMMapping.put("2.15.1.redhat-621084", "6.2.1.redhat-084");
        camelVersionToFuseBOMMapping.put("2.15.1.redhat-621117", "6.2.1.redhat-117");
        camelVersionToFuseBOMMapping.put("2.17.0.redhat-630187", LATEST_BOM_VERSION);
        camelVersionToFuseBOMMapping.put("2.17.3", LATEST_BOM_VERSION);
    }

    public static void initializeModels() {
        String[] versions;
        supportedCamelModels = new HashMap();
        String[] stringArray = versions = CamelServiceManagerUtil.getAvailableVersions();
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            supportedCamelModels.put(version, null);
            ++n2;
        }
    }

    @Deprecated
    public static void initializeModels(HashMap<String, CamelModel> mockedSupportedCamelModels) {
        supportedCamelModels = mockedSupportedCamelModels;
    }

    public static List<String> getSupportedCamelVersions() {
        if (supportedCamelModels == null || supportedCamelModels.isEmpty()) {
            CamelModelFactory.initializeModels();
        }
        return Arrays.asList(supportedCamelModels.keySet().toArray(new String[supportedCamelModels.size()]));
    }

    public static CamelModel getModelForVersion(String camelVersion) {
        ICamelManagerService svc;
        CamelModel cm = supportedCamelModels.get(camelVersion);
        if (!supportedCamelModels.containsKey(camelVersion)) {
            String alternateVersion = CamelModelFactory.getCompatibleCamelVersion(camelVersion);
            CamelModelServiceCoreActivator.pluginLog().logWarning("Selected Camel version " + camelVersion + " is not directly supported. Using alternative version: " + alternateVersion);
            cm = supportedCamelModels.get(alternateVersion);
        }
        if (cm == null && (svc = CamelServiceManagerUtil.getManagerService(camelVersion)) != null) {
            cm = svc.getCamelModel();
            cm.setCamelVersion(camelVersion);
            supportedCamelModels.put(camelVersion, cm);
        }
        return cm;
    }

    static String getCompatibleCamelVersion(String requestedCamelVersion, List<String> supportedVersions, String latestCamelVersion) {
        String alternative = null;
        String lastFound = null;
        String smallestVersion = null;
        Version reqVersion = new Version(requestedCamelVersion);
        for (String supV : supportedVersions) {
            Version testVersion = new Version(supV);
            if (testVersion.compareTo(reqVersion) == 0) {
                return supV;
            }
            if (testVersion.compareTo(reqVersion) < 0) {
                if (lastFound == null) {
                    lastFound = supV;
                    continue;
                }
                Version lastCompatible = new Version(lastFound);
                if (testVersion.compareTo(lastCompatible) <= 0) continue;
                lastFound = supV;
                continue;
            }
            if (smallestVersion == null) {
                smallestVersion = supV;
                continue;
            }
            Version smallest = new Version(smallestVersion);
            if (testVersion.compareTo(smallest) >= 0) continue;
            smallestVersion = supV;
        }
        alternative = lastFound;
        if (lastFound == null) {
            alternative = smallestVersion;
        }
        return alternative != null ? alternative : latestCamelVersion;
    }

    public static String getCompatibleCamelVersion(String requestedCamelVersion) {
        return CamelModelFactory.getCompatibleCamelVersion(requestedCamelVersion, CamelModelFactory.getSupportedCamelVersions(), CamelModelFactory.getLatestCamelVersion());
    }

    public static String getLatestCamelVersion() {
        String latest = null;
        for (String v : supportedCamelModels.keySet()) {
            if (latest == null) {
                latest = v;
                continue;
            }
            if (v.compareTo(latest) <= 0) continue;
            latest = v;
        }
        if (latest != null) {
            return latest;
        }
        return supportedCamelModels.keySet().iterator().next();
    }

    public static String getCamelVersion(IProject p) {
        String version = CamelModelFactory.getCamelVersionFromMaven(p);
        if (version != null && CamelModelFactory.getSupportedCamelVersions().contains(version)) {
            return version;
        }
        return CamelModelFactory.getLatestCamelVersion();
    }

    public static String getCamelVersionFromMaven(IProject project) {
        if (project == null) {
            return null;
        }
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        File pomFile = new File(pomPath);
        if (!pomFile.exists() || pomFile.isDirectory()) {
            return null;
        }
        try {
            Model model = MavenPlugin.getMaven().readModel(pomFile);
            List deps = model.getDependencies();
            for (Dependency pomDep : deps) {
                if (!pomDep.getGroupId().equalsIgnoreCase("org.apache.camel") || !pomDep.getArtifactId().startsWith("camel-")) continue;
                return pomDep.getVersion();
            }
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to load camel version from " + pomPath, (Throwable)ex);
        }
        return null;
    }

    public static String getFuseVersionForCamelVersion(String camelVersion) {
        String bomVersion = camelVersionToFuseBOMMapping.get(camelVersion);
        if (bomVersion == null) {
            bomVersion = LATEST_BOM_VERSION;
        }
        return bomVersion;
    }
}

