/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.components;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.ICamelCatalogElement;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentProperty;
import org.fusesource.ide.foundation.core.util.Strings;

@XmlRootElement(name="component")
public class Component
implements ICamelCatalogElement {
    private String id;
    private String clazz;
    private String title;
    private String description;
    private String syntax;
    private String kind;
    private String consumerOnly;
    private String producerOnly;
    private String scheme;
    private ArrayList<Dependency> dependencies;
    private ArrayList<String> tags;
    private ArrayList<ComponentProperty> componentProperties;
    private ArrayList<Parameter> uriParameters;

    @Override
    public String getName() {
        return this.getId();
    }

    @XmlElementWrapper(name="componentProperties")
    @XmlElement(name="componentProperty")
    public ArrayList<ComponentProperty> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(ArrayList<ComponentProperty> componentProperties) {
        this.componentProperties = componentProperties;
    }

    @XmlElementWrapper(name="uriParameters")
    @XmlElement(name="uriParameter")
    public ArrayList<Parameter> getUriParameters() {
        return this.uriParameters;
    }

    public void setUriParameters(ArrayList<Parameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    @XmlElement(name="consumerOnly")
    public String getConsumerOnly() {
        return this.consumerOnly;
    }

    public void setConsumerOnly(String consumerOnly) {
        this.consumerOnly = consumerOnly;
    }

    @XmlElement(name="producerOnly")
    public String getProducerOnly() {
        return this.producerOnly;
    }

    public void setProducerOnly(String producerOnly) {
        this.producerOnly = producerOnly;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="scheme")
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @XmlElement(name="kind")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    @XmlElement(name="class")
    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @XmlElement(name="syntax")
    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @XmlElement(name="description")
    public String getDescription() {
        return this.description;
    }

    @XmlElement(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    public ArrayList<String> getTags() {
        return this.tags;
    }

    public void setTags(ArrayList<String> tags) {
        this.tags = tags;
    }

    @XmlElementWrapper(name="dependencies")
    @XmlElement(name="dependency")
    public ArrayList<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(ArrayList<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean supportsScheme(String scheme) {
        return this.getScheme().equals(scheme);
    }

    public String getSchemeTitle() {
        return this.getScheme();
    }

    public Component duplicateFor(final String scheme, String clazz) {
        Component dup = new Component(){

            @Override
            public boolean supportsScheme(String testScheme) {
                return scheme.equals(testScheme);
            }
        };
        dup.setScheme(scheme);
        dup.setId(scheme);
        dup.setClazz(clazz);
        dup.setComponentProperties(this.getComponentProperties());
        dup.setConsumerOnly(this.getConsumerOnly());
        dup.setDescription(this.getDescription());
        dup.setKind(this.getKind());
        dup.setProducerOnly(this.getProducerOnly());
        dup.setSyntax(this.getSyntax().replaceFirst(String.format("%s:", this.getScheme()), String.format("%s:", scheme)));
        dup.setTags(this.getTags());
        dup.setTitle(this.getTitle());
        dup.setUriParameters(this.getUriParameters());
        return dup;
    }

    public String getDisplayTitle() {
        return Strings.isBlank((String)this.getTitle()) ? Strings.humanize((String)this.getSchemeTitle()) : this.getTitle();
    }
}

