/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.components;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.components.ComponentProperty;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.xml.sax.InputSource;

@XmlRootElement(name="components")
public class ComponentModel {
    private CamelModel model;
    private ArrayList<Component> supportedComponents;

    public CamelModel getModel() {
        return this.model;
    }

    public void setModel(CamelModel model) {
        this.model = model;
    }

    @XmlElement(name="component")
    public ArrayList<Component> getSupportedComponents() {
        return this.supportedComponents;
    }

    public void setSupportedComponents(ArrayList<Component> supportedComponents) {
        this.supportedComponents = supportedComponents;
    }

    public Component getComponentForScheme(String scheme) {
        for (Component c : this.supportedComponents) {
            if (!c.supportsScheme(scheme)) continue;
            return c;
        }
        return null;
    }

    public static ComponentModel getXMLFactoryInstance(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ComponentModel.class, Component.class, Dependency.class, ComponentProperty.class, Parameter.class});
            Unmarshaller um = context.createUnmarshaller();
            ComponentModel model = (ComponentModel)um.unmarshal(new InputSource(stream));
            return model;
        }
        catch (JAXBException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

