/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.dataformats;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.xml.sax.InputSource;

@XmlRootElement(name="dataformats")
public class DataFormatModel {
    private CamelModel model;
    private ArrayList<DataFormat> supportedDataFormats;

    public CamelModel getModel() {
        return this.model;
    }

    public void setModel(CamelModel model) {
        this.model = model;
    }

    @XmlElement(name="dataformat")
    public ArrayList<DataFormat> getSupportedDataFormats() {
        return this.supportedDataFormats;
    }

    public void setSupportedDataFormats(ArrayList<DataFormat> supportedDataFormats) {
        this.supportedDataFormats = supportedDataFormats;
    }

    public DataFormat getDataFormatByName(String dataformat) {
        return this.supportedDataFormats.stream().filter(df -> df.getName().equals(dataformat)).findFirst().orElse(null);
    }

    public Set<DataFormat> getDataFormatsByModelName(String dataformat) {
        return this.supportedDataFormats.stream().filter(df -> df.getModelName().equals(dataformat)).collect(Collectors.toSet());
    }

    public static DataFormatModel getXMLFactoryInstance(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DataFormatModel.class, DataFormat.class, Dependency.class, Parameter.class});
            Unmarshaller um = context.createUnmarshaller();
            return (DataFormatModel)um.unmarshal(new InputSource(stream));
        }
        catch (JAXBException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

