/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.eips;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.xml.sax.InputSource;

@XmlRootElement(name="eips")
public class EipModel {
    private CamelModel model;
    private ArrayList<Eip> supportedEIPs;

    public CamelModel getModel() {
        return this.model;
    }

    public void setModel(CamelModel model) {
        this.model = model;
    }

    @XmlElement(name="eip")
    public ArrayList<Eip> getSupportedEIPs() {
        return this.supportedEIPs;
    }

    public void setSupportedEIPs(ArrayList<Eip> supportedEIPs) {
        this.supportedEIPs = supportedEIPs;
    }

    public Eip getEIPByClass(String className) {
        for (Eip eip : this.getSupportedEIPs()) {
            if (!eip.getClazz().equalsIgnoreCase(className)) continue;
            return eip;
        }
        return null;
    }

    public Eip getEIPByName(String eipName) {
        for (Eip eip : this.getSupportedEIPs()) {
            if (!eip.getName().equalsIgnoreCase(eipName)) continue;
            return eip;
        }
        return null;
    }

    public static EipModel getXMLFactoryInstance(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{EipModel.class, Eip.class, Parameter.class});
            Unmarshaller um = context.createUnmarshaller();
            EipModel model = (EipModel)um.unmarshal(new InputSource(stream));
            return model;
        }
        catch (JAXBException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

