/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.catalog.languages;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.languages.Language;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.xml.sax.InputSource;

@XmlRootElement(name="languages")
public class LanguageModel {
    private CamelModel model;
    private ArrayList<Language> supportedLanguages;

    public CamelModel getModel() {
        return this.model;
    }

    public void setModel(CamelModel model) {
        this.model = model;
    }

    @XmlElement(name="language")
    public ArrayList<Language> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setSupportedLanguages(ArrayList<Language> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
    }

    public Language getLanguageByName(String language) {
        for (Language l : this.supportedLanguages) {
            if (!l.getName().equals(language)) continue;
            return l;
        }
        return null;
    }

    public static LanguageModel getXMLFactoryInstance(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LanguageModel.class, Language.class, Dependency.class, Parameter.class});
            Unmarshaller um = context.createUnmarshaller();
            LanguageModel model = (LanguageModel)um.unmarshal(new InputSource(stream));
            return model;
        }
        catch (JAXBException ex) {
            CamelModelServiceCoreActivator.pluginLog().logError((Throwable)ex);
            return null;
        }
    }
}

