/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.fusesource.ide.camel.model.service.core.internal.CamelModelServiceCoreActivator;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Document;

public class CamelIOHandler {
    protected static final int INDENTION_VALUE = 3;
    protected static final String CAMEL_CONTEXT = "camelContext";
    protected static final String CAMEL_ROUTES = "routes";
    public static final String LINE_NUMBER_ATT_NAME = "LINE_NUMBER_ATT_NAME";
    private Document document;

    public CamelFile loadCamelModel(IResource res, IProgressMonitor monitor) {
        File xmlFile;
        block3: {
            CamelFile cf = null;
            try {
                xmlFile = this.getFileFromResource(res);
                if (xmlFile != null) break block3;
                CamelModelServiceCoreActivator.pluginLog().logError("Cannot determine the file path for resource " + res.getFullPath().toOSString());
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                CamelModelServiceCoreActivator.pluginLog().logError("Error loading Camel XML file from " + res.getFullPath().toOSString(), (Throwable)ex);
                return cf;
            }
        }
        return this.loadCamelModel(xmlFile, monitor);
    }

    public CamelFile loadCamelModel(File xmlFile, IProgressMonitor monitor) {
        if (xmlFile == null || !xmlFile.isFile() || !xmlFile.exists()) {
            return null;
        }
        CamelFile cf = null;
        try {
            DocumentBuilder docBuilder = this.createDocumentBuilder();
            this.document = docBuilder.parse(xmlFile);
            IFile documentLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(xmlFile.getCanonicalPath()));
            cf = this.readDocumentToModel(this.document, (IResource)documentLocation);
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Error loading Camel XML file from " + xmlFile.getPath(), (Throwable)ex);
        }
        return cf;
    }

    public CamelFile loadCamelModel(String text, IProgressMonitor monitor, CamelFile cf) {
        CamelFile reloadedModel = null;
        try {
            DocumentBuilder db = this.createDocumentBuilder();
            this.document = db.parse(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
            reloadedModel = this.readDocumentToModel(this.document, cf.getResource());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CamelModelServiceCoreActivator.pluginLog().logError("Error loading Camel XML from string", (Throwable)ex);
        }
        return reloadedModel;
    }

    protected CamelFile readDocumentToModel(Document document, IResource res) {
        CamelFile cf = new CamelFile(null);
        cf.setResource(res);
        cf.setDocument(document);
        cf.initialize();
        return cf;
    }

    public void saveCamelModel(CamelFile camelFile, File outputFile, IProgressMonitor monitor) {
        if (this.document == null) {
            this.document = this.createDocumentBuilder().newDocument();
        }
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("indent-number", 3);
            Transformer transformer = tf.newTransformer();
            StreamResult output = new StreamResult(outputFile);
            DOMSource input = new DOMSource(this.document);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.transform(input, output);
        }
        catch (Exception ex) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to save the camel file to " + outputFile.getPath(), (Throwable)ex);
        }
    }

    public void saveCamelModel(CamelFile camelFile, IResource res, IProgressMonitor monitor) {
        File outputFile = this.getFileFromResource(res != null && res != camelFile.getResource() ? res : camelFile.getResource());
        this.saveCamelModel(camelFile, outputFile, monitor);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    protected File getFileFromResource(IResource res) {
        return new File(res.getLocationURI() != null ? res.getLocationURI().getPath() : res.getFullPath().toOSString());
    }

    protected DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(false);
        dbf.setNamespaceAware(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            CamelModelServiceCoreActivator.pluginLog().logError("Unable to create a document builder for loading the camel file.", (Throwable)e);
            return null;
        }
    }
}

