/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.core.jmx.camel;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelBacklogTracerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelBackwardsCompatibleSupport;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelBrowsableEndpointMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelComponentMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelConsumerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelContextMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelDelayProcessorMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelEndpointMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelFabricTracerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelJMXFacade;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelProcessorMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelRouteMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelScheduledPollConsumerMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelSendProcessorMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelSuspendableRouteMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelThreadPoolMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelThrottleProcessorMBean;

public abstract class CamelFacadeSupport
implements CamelJMXFacade {
    protected String camelContextManagementName;
    protected final MBeanServerConnection mBeanServer;

    protected CamelFacadeSupport(String camelContextManagementName, MBeanServerConnection mBeanServer) throws Exception {
        this.mBeanServer = mBeanServer;
        this.camelContextManagementName = camelContextManagementName;
    }

    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        return this.mBeanServer;
    }

    protected Set<ObjectInstance> queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.getMBeanServerConnection().queryMBeans(name, query);
    }

    public static <T> T addGetId(Class<T> ic, final Object target, final String id) throws Exception {
        return ic.cast(Proxy.newProxyInstance(ic.getClassLoader(), new Class[]{ic}, new InvocationHandler(){

            @Override
            public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
                if (method.getName() == "getId" && method.getParameterTypes().length == 0) {
                    return id;
                }
                return method.invoke(target, objects);
            }
        }));
    }

    protected Object newProxyInstance(ObjectName objectName, Class<?> interfaceClass, boolean notificationBroadcaster) throws Exception {
        Object jmx_proxy = MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServerConnection(), objectName, interfaceClass, notificationBroadcaster);
        return CamelFacadeSupport.addGetId(interfaceClass, jmx_proxy, objectName.getCanonicalName());
    }

    protected Set<ObjectName> findCamelContexts(MBeanServerConnection connection, String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName name = id != null ? new ObjectName("org.apache.camel:context=" + managementName + ",type=context,*") : new ObjectName("org.apache.camel:context=*,type=context,*");
        Set<ObjectName> camels = connection.queryNames(name, null);
        return camels;
    }

    @Override
    public List<CamelContextMBean> getCamelContexts() throws Exception {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        Set<ObjectName> names = this.findCamelContexts(connection, null);
        ArrayList<CamelContextMBean> answer = new ArrayList<CamelContextMBean>();
        for (ObjectName on : names) {
            CamelContextMBean context = (CamelContextMBean)this.newProxyInstance(on, CamelContextMBean.class, true);
            answer.add(context);
        }
        return answer;
    }

    @Override
    public CamelContextMBean getCamelContext(String managementName) throws Exception {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        Set<ObjectName> contexts = this.findCamelContexts(connection, managementName);
        if (contexts.size() == 0) {
            throw new IOException("No CamelContext could be found in the JMX.");
        }
        ObjectName name = contexts.iterator().next();
        CamelContextMBean mbean = (CamelContextMBean)this.newProxyInstance(name, CamelContextMBean.class, true);
        return mbean;
    }

    @Override
    public CamelFabricTracerMBean getFabricTracer(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=fabric,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        for (ObjectInstance on : names) {
            if (!on.getClassName().equals("org.apache.camel.fabric.FabricTracer")) continue;
            CamelFabricTracerMBean tracer = (CamelFabricTracerMBean)this.newProxyInstance(on.getObjectName(), CamelFabricTracerMBean.class, true);
            return tracer;
        }
        return null;
    }

    @Override
    public CamelBacklogTracerMBean getCamelTracer(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=tracer,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        for (ObjectInstance on : names) {
            if (!on.getClassName().equals("org.apache.camel.management.mbean.ManagedBacklogTracer")) continue;
            CamelBacklogTracerMBean tracer = (CamelBacklogTracerMBean)this.newProxyInstance(on.getObjectName(), CamelBacklogTracerMBean.class, true);
            return tracer;
        }
        return null;
    }

    @Override
    public List<CamelComponentMBean> getComponents(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=components,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelComponentMBean> answer = new ArrayList<CamelComponentMBean>();
        for (ObjectInstance on : names) {
            CamelComponentMBean component = (CamelComponentMBean)this.newProxyInstance(on.getObjectName(), CamelComponentMBean.class, true);
            answer.add(component);
        }
        return answer;
    }

    @Override
    public List<CamelRouteMBean> getRoutes(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=routes,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelRouteMBean> answer = new ArrayList<CamelRouteMBean>();
        for (ObjectInstance on : names) {
            CamelRouteMBean route = "org.apache.camel.management.mbean.ManagedSuspendableRoute".equals(on.getClassName()) ? (CamelRouteMBean)this.newProxyInstance(on.getObjectName(), CamelSuspendableRouteMBean.class, true) : (CamelRouteMBean)this.newProxyInstance(on.getObjectName(), CamelRouteMBean.class, true);
            answer.add(route);
        }
        return answer;
    }

    @Override
    public List<CamelEndpointMBean> getEndpoints(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=endpoints,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelEndpointMBean> answer = new ArrayList<CamelEndpointMBean>();
        for (ObjectInstance on : names) {
            CamelEndpointMBean endpoint = "org.apache.camel.management.mbean.ManagedBrowsableEndpoint".equals(on.getClassName()) || "org.apache.camel.component.seda.SedaEndpoint".equals(on.getClassName()) ? (CamelEndpointMBean)this.newProxyInstance(on.getObjectName(), CamelBrowsableEndpointMBean.class, true) : (on.getClassName().startsWith("org.apache.camel.component.jms") ? (CamelEndpointMBean)this.newProxyInstance(on.getObjectName(), CamelBrowsableEndpointMBean.class, true) : (CamelEndpointMBean)this.newProxyInstance(on.getObjectName(), CamelEndpointMBean.class, true));
            answer.add(endpoint);
        }
        return answer;
    }

    @Override
    public List<CamelConsumerMBean> getConsumers(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=consumers,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelConsumerMBean> answer = new ArrayList<CamelConsumerMBean>();
        for (ObjectInstance on : names) {
            CamelConsumerMBean consumer = "org.apache.camel.management.mbean.ManagedScheduledPollConsumer".equals(on.getClassName()) ? (CamelConsumerMBean)this.newProxyInstance(on.getObjectName(), CamelScheduledPollConsumerMBean.class, true) : (CamelConsumerMBean)this.newProxyInstance(on.getObjectName(), CamelConsumerMBean.class, true);
            answer.add(consumer);
        }
        return answer;
    }

    @Override
    public List<CamelProcessorMBean> getProcessors(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=processors,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelProcessorMBean> answer = new ArrayList<CamelProcessorMBean>();
        for (ObjectInstance on : names) {
            CamelProcessorMBean processor = "org.apache.camel.management.mbean.ManagedSendProcessor".equals(on.getClassName()) ? (CamelProcessorMBean)this.newProxyInstance(on.getObjectName(), CamelSendProcessorMBean.class, true) : ("org.apache.camel.management.mbean.ManagedDelayer".equals(on.getClassName()) ? (CamelProcessorMBean)this.newProxyInstance(on.getObjectName(), CamelDelayProcessorMBean.class, true) : ("org.apache.camel.management.mbean.ManagedThrottler".equals(on.getClassName()) ? (CamelProcessorMBean)this.newProxyInstance(on.getObjectName(), CamelThrottleProcessorMBean.class, true) : (CamelProcessorMBean)this.newProxyInstance(on.getObjectName(), CamelProcessorMBean.class, true)));
            answer.add(processor);
        }
        return answer;
    }

    @Override
    public List<CamelThreadPoolMBean> getThreadPools(String managementName) throws Exception {
        String id = managementName != null ? managementName : this.camelContextManagementName;
        ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + id + ",type=threadpools,*");
        Set<ObjectInstance> names = this.queryNames(query, null);
        ArrayList<CamelThreadPoolMBean> answer = new ArrayList<CamelThreadPoolMBean>();
        for (ObjectInstance on : names) {
            CamelThreadPoolMBean pool = (CamelThreadPoolMBean)this.newProxyInstance(on.getObjectName(), CamelThreadPoolMBean.class, true);
            answer.add(pool);
        }
        return answer;
    }

    @Override
    public String dumpRoutesStatsAsXml(String managementName) throws Exception {
        CamelContextMBean context = this.getCamelContext(managementName);
        try {
            return context.dumpRoutesStatsAsXml(false, true);
        }
        catch (Exception exception) {
            return CamelBackwardsCompatibleSupport.dumpRoutesStatsAsXml(this, managementName);
        }
    }
}

